/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.filesVsPrograms;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceFile;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.wu.WUAbstractAnalysis;
import com.ez.report.application.ezreport.reports.wu.filesVsPrograms.FilesVsProgramsJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.ProgramsCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FilesVsProgramsAnalysis
extends WUAbstractAnalysis {
    public FilesVsProgramsAnalysis() {
        this(null);
    }

    public FilesVsProgramsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(((Object)((Object)this)).getClass(), "wizzard.title");
        wizard.setWindowTitle(wizardName);
        GenericSelectInputPage4Report selectProgramsPage = new GenericSelectInputPage4Report("programs page");
        selectProgramsPage.setLeftGroupLabel(Messages.getString(((Object)((Object)this)).getClass(), "av.objectType.Files"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(((Object)((Object)this)).getClass(), "sel.objectType.Files"));
        selectProgramsPage.setResourcesCollector(this.getCollector4Wizard());
        wizard.addPage(selectProgramsPage);
        return wizard;
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ArrayList<BaseMainframeResourceInput> sel = new ArrayList<BaseMainframeResourceInput>();
            HashSet<String> inputNames = new HashSet<String>();
            for (Object inpObj : inputs) {
                if (inpObj instanceof EZSourceProjectInputType) {
                    String prjName = ((EZSourceProjectInputType)inpObj).getName();
                    if (prjName != null) {
                        this.setPrjName(prjName);
                        this.addContextValue("input_project_names", prjName);
                    }
                    this.addContextValue("input_list", inputs);
                    ProjectInfo pInfo = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                    com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                    this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                    continue;
                }
                if (!(inpObj instanceof EZSourceFile)) continue;
                EZSourceFile file = (EZSourceFile)inpObj;
                EZEntityID entity = file.getEntID();
                list.add(entity);
                EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                if (prjSg == null) continue;
                if (!prjSg.getProjectName().equals(this.projectName)) {
                    this.setPrjName(prjSg.getProjectName());
                    this.addContextValue("input_project_names", prjSg.getProjectName());
                    ProjectInfo pInfo = prjSg.getProjectInfo();
                    com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                    this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                }
                String name = (String)(file.hasLogicalName() ? file.getProperty("logical file attribute") : file.getName());
                sel.add((BaseMainframeResourceInput)new ProgramInputNoGUI(name));
                inputNames.add(name);
            }
            if (!sel.isEmpty()) {
                this.setParams(sel);
                this.addAllContextValues(this.params);
                this.addContextValue("input_list", list);
                this.addContextValue("inputs name string", inputNames);
            }
        }
    }

    protected ResourcesCollector getCollector4Wizard() {
        String filesQuery = "select distinct Files.LogicalName FROM Files left join programs on programs.programid=files.progid where files.LogicalName is not null AND files.LogicalName <> 'NULL' AND files.LogicalName <> 'VT_NULL' AND files.LogicalName <> '' AND (files.TypeCode <> 32 OR files.TypeCode IS NULL) AND (files.progid is null or files.progid=0 or (programs.programtypeid not in (9,13,19))) ORDER BY LogicalName";
        ProgramsCollector pc = new ProgramsCollector();
        pc.setProgramsQuery(filesQuery);
        pc.setProgramsForAppQuery(filesQuery);
        return pc;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_FILES_VS_PROGRAMS_ANALYSIS;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, FilesVsProgramsJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }
}

