/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.filesVsPrograms;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.EZCategorySeriesLabelGenerator;
import com.ez.report.application.ezreport.reports.wu.EZLineBorder;
import com.ez.report.application.ezreport.reports.wu.ExtendedStackedBarRenderer;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.filesVsPrograms.FilesVSProgramsDataSource;
import com.ez.report.application.ezreport.reports.wu.filesVsPrograms.FilesVSProgramsReport;
import com.ez.report.application.ezreport.reports.wu.filesVsPrograms.Obj4FilesVSProgramsReport;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesVSProgramsReportBuilder
extends WUReportBuilder {
    private static final Logger L = LoggerFactory.getLogger(FilesVSProgramsReportBuilder.class);
    private static final String EZREP_FILES_VS_PROGRAMS = "EZReports_FilesVsPrograms";
    private static final String EZREP_FILES_VS_PROGRAMS_SEL = "EZReports_FilesVsPrograms_Selective";
    private static final String EZREP_FILES_VS_PROGRAMS_UCMDB = "EZReports_FilesVsPrograms_UCMDB";
    private static final String EZREP_FILES_VS_PROGRAMS_SEL_UCMDB = "EZReports_FilesVsPrograms_UCMDB_Selective";
    protected Map allFilesMap = null;
    protected Map stmtCountMap = null;
    protected Map accesCountMap = null;

    public FilesVSProgramsReportBuilder(String reportName, String settings) {
        this.report = null;
        this.accesCountMap = new HashMap();
        this.allFilesMap = new HashMap();
        this.resultList = new ArrayList();
        this.stmtCountMap = new HashMap();
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(FilesVSProgramsReportBuilder.class, "collectingData.taskName"));
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
        }
        return this.buildReportDS();
    }

    protected AbstractReportDataSource buildReportDS() {
        FilesVSProgramsDataSource dataSource = new FilesVSProgramsDataSource(this.resultList, this.allFilesMap);
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new FilesVSProgramsReport(this.project, this.getSelectionFlagFromInputs());
            Collection selected = (Collection)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            if (selectedApps != null) {
                Collection appNames = (Collection)this.inputs.get("selected applications names");
                for (ProgramInputNoGUI prg : selected) {
                    prg.setApplicationsName((Set)appNames);
                }
            }
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(FilesVSProgramsReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedFiles1.jasper";
    }

    private void clearForJasperReport() {
        this.accesCountMap.clear();
        this.stmtCountMap.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected String getProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return EZREP_FILES_VS_PROGRAMS_UCMDB;
        }
        return EZREP_FILES_VS_PROGRAMS;
    }

    protected String getSelectiveProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return EZREP_FILES_VS_PROGRAMS_SEL_UCMDB;
        }
        return EZREP_FILES_VS_PROGRAMS_SEL;
    }

    protected String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(FilesVSProgramsReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor, EZSourceDataType.String);
        String[][] results = queryResult.data;
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        this.buildData4Report(results, csvWriter);
        if (this.stmtCountMap.size() > 0) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            for (String stmtType : this.stmtCountMap.keySet()) {
                dataset.addValue((Number)((Integer)this.stmtCountMap.get(stmtType)), (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
            }
            String title = Messages.getString(FilesVSProgramsReportBuilder.class, "pie1.title");
            String xAxis = Messages.getString(((Object)((Object)this)).getClass(), "firstbar.category.axis");
            String yAxis = Messages.getString(FilesVSProgramsReportBuilder.class, "firstbar.value.axis");
            this.parameters.put("usagePie", this.createFirstStackedBar(dataset, title, xAxis, yAxis, 1000, 1300));
        }
        if (this.accesCountMap.size() > 0) {
            String titleStr = Messages.getString(((Object)((Object)this)).getClass(), "pie2.title");
            DefaultCategoryDataset dataset = this.buildDataSet(this.accesCountMap);
            String subtitle = null;
            if (this.accesCountMap.keySet().size() >= 20) {
                Object[] msgParams = new String[]{String.valueOf(20)};
                titleStr = titleStr.concat(" ").concat(Messages.getString(FilesVSProgramsReportBuilder.class, "bar.title", msgParams));
                if (this.countsSame != 0) {
                    msgParams = new String[]{String.valueOf(this.countsSame)};
                    titleStr = titleStr.concat("*");
                    subtitle = Messages.getString(((Object)((Object)this)).getClass(), "bar.subtitle", msgParams);
                }
            }
            String xAxisStr = Messages.getString(FilesVSProgramsReportBuilder.class, "bar.category.axis");
            String yAxisStr = Messages.getString(FilesVSProgramsReportBuilder.class, "bar.value.axis");
            this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(dataset, titleStr, xAxisStr, yAxisStr, 880, 600, null, subtitle));
        }
        monitor.setWorkRemaining(0);
        this.putSubreportStream("reports/wuInitialBars2.jasper", "SubreportStream2");
        return results;
    }

    @Override
    protected String getSubreportTemplate1() {
        return "reports/wuInitialBars1.jasper";
    }

    protected void buildData4Report(String[][] results, CSVWriter csvWriter) {
        if (results == null) {
            L.warn("no results for UsedFiles report");
        } else {
            L.debug("Files vs Programs results:");
            int i = 0;
            while (i < results.length) {
                int currentCount;
                int temp;
                Integer countValue;
                String prgPath;
                String fileName = results[i][0];
                String prgName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                String parentName = results[i][4];
                if (parentName != null && !parentName.isEmpty()) {
                    prgName = String.valueOf(parentName) + ": " + prgName;
                }
                if ((prgPath = results[i][5]) != null && !prgPath.isEmpty()) {
                    prgName = prgName.concat(" (").concat(prgPath).concat(")");
                }
                L.debug("file:" + fileName);
                L.debug("program:" + prgName);
                L.debug("stmt type:" + stmtType);
                L.debug("count:" + stmtCount);
                L.debug("\n");
                Obj4FilesVSProgramsReport obj = new Obj4FilesVSProgramsReport();
                obj.setFileName(fileName);
                obj.setProgramName(prgName);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                HashMap<String, Integer> fileMap = (HashMap<String, Integer>)this.allFilesMap.get(fileName);
                if (fileMap == null) {
                    fileMap = new HashMap<String, Integer>();
                    this.allFilesMap.put(fileName, fileMap);
                }
                countValue = (countValue = (Integer)fileMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                fileMap.put(stmtType, countValue);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{fileName, prgName, stmtType, stmtCount.toString()});
                }
                this.resultList.add(obj);
                if (!this.accesCountMap.containsKey(fileName)) {
                    this.accesCountMap.put(fileName, stmtCount);
                } else {
                    temp = (Integer)this.accesCountMap.get(fileName);
                    currentCount = stmtCount;
                    this.accesCountMap.put(fileName, new Integer(temp + currentCount));
                }
                if (!this.stmtCountMap.containsKey(stmtType)) {
                    this.stmtCountMap.put(stmtType, stmtCount);
                } else {
                    temp = (Integer)this.stmtCountMap.get(stmtType);
                    currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType, new Integer(temp + currentCount));
                }
                ++i;
            }
        }
    }

    @Override
    public void cleanMemory() {
        if (this.accesCountMap != null) {
            this.accesCountMap.clear();
            this.accesCountMap = null;
        }
        if (this.allFilesMap != null) {
            this.allFilesMap.clear();
            this.allFilesMap = null;
        }
        if (this.stmtCountMap != null) {
            this.stmtCountMap.clear();
            this.stmtCountMap = null;
        }
        super.cleanMemory();
    }

    @Override
    protected Image createFirstStackedBar(DefaultCategoryDataset dataset, String chartTitle, String xAxis, String yAxis, int imgWidth, int imgHeight) {
        TextTitle title = new TextTitle(chartTitle, this.titleFont);
        this.verticalChart = ChartFactory.createBarChart(null, (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.verticalChart.setTitle(title);
        this.verticalChart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = this.verticalChart.getCategoryPlot();
        this.verticalChart.setBorderVisible(false);
        this.verticalChart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        LegendTitle leg = this.verticalChart.getLegend();
        leg.setFrame((BlockFrame)new EZLineBorder());
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.DARK_GRAY);
        axis.setLabelFont(this.labelFont);
        axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        axis.setCategoryMargin(0.1);
        axis.setTickLabelsVisible(false);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperMargin(0.15);
        rangeAxis.setLabelFont(this.labelFont);
        ExtendedStackedBarRenderer extendedstackedbarrenderer = new ExtendedStackedBarRenderer(this.labelFont);
        extendedstackedbarrenderer.setBaseItemLabelsVisible(true);
        extendedstackedbarrenderer.setLegendItemLabelGenerator(new EZCategorySeriesLabelGenerator("{0} - {2}({1})"));
        extendedstackedbarrenderer.setMaximumBarWidth(0.1);
        extendedstackedbarrenderer.setBaseItemLabelFont(this.labelFont);
        plot.setRenderer((CategoryItemRenderer)extendedstackedbarrenderer);
        return this.verticalChart.createBufferedImage(imgWidth, imgHeight, (double)(imgWidth / 2), (double)(imgHeight / 2), null);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.file"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

