/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.filesVsDDCLElements;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.filesVsDDCLElements.DataSource;
import com.ez.report.application.ezreport.reports.wu.filesVsDDCLElements.ReportModel;
import com.ez.report.application.ezreport.reports.wu.filesVsPrograms.FilesVSProgramsReportBuilder;
import com.ez.report.application.ezreport.reports.wu.filesVsPrograms.Obj4FilesVSProgramsReport;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends FilesVSProgramsReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String EZREP_FILES_VS_DDCLELEMENTS = "EZReports_FilesUsedByDDCL";
    private static final String EZREP_FILES_VS_DDCLELEMENTS_SEL = "EZReports_FilesUsedByDDCL_Selective";

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected AbstractReportDataSource buildReportDS() {
        DataSource dataSource = new DataSource(this.resultList, this.allFilesMap);
        return dataSource;
    }

    @Override
    protected void buildData4Report(String[][] results, CSVWriter csvWriter) {
        if (results == null) {
            L.warn("no results for UsedFilesByDDCL report");
        } else {
            L.debug("Files vs DDCL results:");
            int i = 0;
            while (i < results.length) {
                int currentCount;
                int temp;
                Integer countValue;
                String fileName = results[i][0];
                String elemName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                Integer elemTypeId = new Integer(Integer.parseInt(results[i][4]));
                String textType = Utils.getExternalizedType4DDCLComponent((Integer)elemTypeId);
                elemName = String.valueOf(elemName) + " (" + textType.toLowerCase() + ")";
                L.debug("file:" + fileName);
                L.debug("program:" + elemName);
                L.debug("stmt type:" + stmtType);
                L.debug("count:" + stmtCount);
                L.debug("\n");
                Obj4FilesVSProgramsReport obj = new Obj4FilesVSProgramsReport();
                obj.setFileName(fileName);
                obj.setProgramName(elemName);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                HashMap<String, Integer> fileMap = (HashMap<String, Integer>)this.allFilesMap.get(fileName);
                if (fileMap == null) {
                    fileMap = new HashMap<String, Integer>();
                    this.allFilesMap.put(fileName, fileMap);
                }
                countValue = (countValue = (Integer)fileMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                fileMap.put(stmtType, countValue);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{fileName, elemName, stmtType, stmtCount.toString()});
                }
                this.resultList.add(obj);
                if (!this.accesCountMap.containsKey(fileName)) {
                    this.accesCountMap.put(fileName, stmtCount);
                } else {
                    temp = (Integer)this.accesCountMap.get(fileName);
                    currentCount = stmtCount;
                    this.accesCountMap.put(fileName, new Integer(temp + currentCount));
                }
                if (!this.stmtCountMap.containsKey(stmtType)) {
                    this.stmtCountMap.put(stmtType, stmtCount);
                } else {
                    temp = (Integer)this.stmtCountMap.get(stmtType);
                    currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType, new Integer(temp + currentCount));
                }
                ++i;
            }
        }
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Collection selected = (Collection)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "first.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        params.put("sum2", null);
        params.put("sum3", null);
        params.put("sum4", null);
    }

    @Override
    protected String getProcedure() {
        return EZREP_FILES_VS_DDCLELEMENTS;
    }

    @Override
    protected String getSelectiveProcedure() {
        return EZREP_FILES_VS_DDCLELEMENTS_SEL;
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.file"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.ddcl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.property"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

