/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.ddclElementsVsFiles;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.computation.ProgramsVsCollector;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.ElementsUsingFilesCollector;
import com.ez.report.application.ezreport.reports.wu.ddclElementsVsFiles.DataSource;
import com.ez.report.application.ezreport.reports.wu.ddclElementsVsFiles.ReportModel;
import com.ez.report.application.ezreport.reports.wu.programsVsFiles.Obj4ProgramsVSFilesReport;
import com.ez.report.application.ezreport.reports.wu.programsVsFiles.ProgramsVSFilesReportBuilder;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.Collection;
import java.util.Map;

public class ReportBuilder
extends ProgramsVSFilesReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static final String countInputsQuery = "select Count(DDCLElement.id) from DDCLElement where DDCLElement.isLocal='false' and DDCLElement.DdsTypeId in (27,28) ";

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
        this.inputWasResource = true;
    }

    @Override
    protected AbstractReportDataSource buildReportDS() {
        DataSource dataSource = new DataSource(this.resultList, this.allPrgMap);
        return dataSource;
    }

    @Override
    protected String getUniqueKeyofLine(String[] lineFromResults) {
        return lineFromResults[0];
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "summ1");
        params.put("sum1", externalized);
        params.put("sum2", null);
        params.put("sum3", null);
        params.put("sum4", null);
    }

    @Override
    protected ProgramsVsCollector instantiateCollector() {
        ElementsUsingFilesCollector collector = new ElementsUsingFilesCollector(!this.report.useAllResources());
        return collector;
    }

    @Override
    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms((String)countInputsQuery, (EZSourceConnection)conn);
    }

    protected Collection filterSelectedIDs() {
        if (this.selectedIds == null) {
            this.selectedIds = com.ez.report.application.ezreport.utils.Utils.getIDs(this.getSelected());
        }
        return this.selectedIds;
    }

    @Override
    protected Obj4ProgramsVSFilesReport buildReportRow(String[] resultsRow, CSVWriter csvWriter, String listablename) {
        Obj4ProgramsVSFilesReport obj = super.buildReportRow(resultsRow, null, listablename);
        Integer elemTypeId = new Integer(Integer.parseInt(resultsRow[4]));
        String textType = com.ez.mainframe.data.utils.Utils.getExternalizedType4DDCLComponent((Integer)elemTypeId);
        obj.setPrgWithApp(String.valueOf(obj.getProgramName()) + " (" + textType.toLowerCase() + ")");
        if (csvWriter != null) {
            csvWriter.write(new String[]{String.valueOf(obj.getProgramName()) + " (" + textType.toLowerCase() + ")", obj.getFileName(), obj.getStmtType(), obj.getCount().toString()});
        }
        return obj;
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.ddcl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.file"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.property"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

