/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.dbiVsPrograms;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUDataSource;
import com.ez.report.application.ezreport.reports.wu.dbiVsPrograms.ReportModel;
import com.ez.report.application.ezreport.reports.wu.programsVsDBI.DBIScriptlet;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.twolevels.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.twolevels.WUTwoLevelsBuilder;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUTwoLevelsBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String STORED_PROCEDURE = "EZReports_DBIVsPrograms";
    private static final String STORED_PROCEDURE_SEL = "EZReports_DBIVsPrograms_Selective";
    private static final String STORED_PROCEDURE_UCMDB = "EZReports_DBIVsPrograms_UCMDB";
    private static final String STORED_PROCEDURE_SEL_UCMDB = "EZReports_DBIVsPrograms_UCMDB_Selective";
    private static final String SELECTED_DBI_IDS = "selected DBI ids";
    String reportTitle = Messages.getString(ReportBuilder.class, "report.title");
    private Map<String, Integer> stmtCountMap = new HashMap<String, Integer>();

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        ReportDataSource ds = (ReportDataSource)super.getDataSource(pmonitor);
        ds.setDomainAxisLabel(Messages.getString(ReportBuilder.class, "stackedBar.domainAxis.lbl"));
        ds.setStackedBarTitle(Messages.getString(ReportBuilder.class, "stackedBar.title"));
        return ds;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            selectedApps = this.inputs.get("selected applications names");
            this.report.addProperty("selected app names", selectedApps);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        super.putExternalizedParameters(params);
        params.put("report.title", this.reportTitle);
        Set apps = (Set)this.getReportModel().getProperty("selected app names");
        if (apps != null) {
            params.put("title.appFieldValues", apps.toString());
        }
        String externalized = Messages.getString(ReportBuilder.class, "detail.column1.name");
        params.put("column1.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "detail.column2.name");
        params.put("column2.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    protected String getProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_UCMDB;
        }
        return STORED_PROCEDURE;
    }

    protected String getSelectiveProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_SEL_UCMDB;
        }
        return STORED_PROCEDURE_SEL;
    }

    @Override
    protected List<Obj4Report> getDBData(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        ArrayList<Obj4Report> result = new ArrayList<Obj4Report>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer);
        String[][] results = queryResult.data;
        if (results == null) {
            L.warn("no results for UsedDBI report");
        } else {
            L.debug("DBI Vs Programs results:");
            String currentDBI = null;
            String currentPrg = null;
            int count = 0;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashMap<String, Integer> prgMap;
                String dbiName = results[i][0];
                String pattern = results[i][1];
                String prgName = results[i][2];
                String stmtType = results[i][3];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][4]));
                String programPath = results[i][5];
                if (programPath != null && !programPath.isEmpty()) {
                    prgName = prgName.concat(" (").concat(programPath).concat(")");
                }
                if (currentDBI == null) {
                    currentDBI = dbiName;
                    currentPrg = prgName;
                    ++count;
                } else if (!currentDBI.equalsIgnoreCase(dbiName)) {
                    this.usedResources.put(currentDBI, new Integer(count));
                    currentDBI = dbiName;
                    currentPrg = prgName;
                    count = 1;
                } else if (!currentPrg.equalsIgnoreCase(prgName)) {
                    currentPrg = prgName;
                    ++count;
                }
                if (i == results.length - 1) {
                    this.usedResources.put(currentDBI, new Integer(count));
                }
                if ((prgMap = (HashMap<String, Integer>)this.allResMap.get(dbiName)) == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allResMap.put(dbiName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                if (!this.stmtCountMap.containsKey(stmtType)) {
                    this.stmtCountMap.put(stmtType, stmtCount);
                } else {
                    int temp = this.stmtCountMap.get(stmtType);
                    int currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType, new Integer(temp + currentCount));
                }
                L.debug("dbi name: {}", (Object)dbiName);
                L.debug("program: {}", (Object)prgName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.level1 = dbiName;
                obj.level1Type = Messages.getString(ReportBuilder.class, "detail.resourceType");
                obj.level2 = ReportsUtils.stripNonValidXMLCharacters((String)prgName, (boolean)true);
                obj.level2Type = Messages.getString(ReportBuilder.class, "detail.programType");
                obj.level3 = stmtType;
                obj.setStmtType(pattern);
                obj.setCount(stmtCount);
                result.add(obj);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{dbiName, prgName, stmtType, pattern, stmtCount.toString()});
                }
                ++i;
            }
        }
        monitor.setWorkRemaining(0);
        return result;
    }

    protected String prepareAppendixResrsList(Set prgList) {
        Set apps;
        String ret = "";
        HashSet<String> resNames = new HashSet<String>();
        for (Object inpt : prgList) {
            if (!(inpt instanceof BaseMainframeResourceInput)) continue;
            resNames.add(((BaseMainframeResourceInput)inpt).getListableName());
        }
        ret = ret.concat(((Object)resNames).toString());
        Object selectedApps = this.report.getProperty("filtered by app");
        if (selectedApps != null && ((Boolean)selectedApps).booleanValue() && this.isMultiApp() && (apps = (Set)this.getReportModel().getProperty("selected app names")) != null && !apps.isEmpty()) {
            ret = Messages.getString(ReportBuilder.class, "appendix.applications.part", new String[]{ret, apps.toString()});
            this.setApplicationName(apps);
        }
        return ret;
    }

    protected Collection getSelected() {
        return (Collection)this.getReportModel().getProperty(SELECTED_DBI_IDS);
    }

    @Override
    protected String getUsedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
    }

    @Override
    protected String getUnusedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
    }

    @Override
    protected String getPieTitle() {
        return Messages.getString(ReportBuilder.class, "pie1.title");
    }

    @Override
    protected String getInputTypeName() {
        return Messages.getString(ReportBuilder.class, "inputName.lbl");
    }

    private void buildSelectedIdsList() {
        Set dbiList = (Set)this.getReportModel().getProperty("inputs");
        HashSet<Integer> dbiIds = new HashSet<Integer>();
        for (BaseMainframeResourceInput net : dbiList) {
            dbiIds.add(net.getResourceID());
        }
        this.getReportModel().addProperty(SELECTED_DBI_IDS, dbiIds);
    }

    @Override
    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        this.buildSelectedIdsList();
        this.parameters = super.getReportParameters(pmonitor);
        Utils.addScriptlet(this.parameters, DBIScriptlet.class.getName());
        return this.parameters;
    }

    @Override
    protected Image createFirstStackedBar(DefaultCategoryDataset ds, String title, String xAxis, String yAxis, int width, int height) {
        return WUDataSource.createStackedBar(ds, title, this.titleFont, xAxis, yAxis, width, height, Color.black);
    }

    @Override
    protected void buildSummaryFirstChart(int allPrgNo) {
        if (this.stmtCountMap.size() > 0) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            ArrayList<String> stmtTypes = new ArrayList<String>(this.stmtCountMap.keySet());
            Collections.sort(stmtTypes, String.CASE_INSENSITIVE_ORDER);
            for (String stmtType : stmtTypes) {
                dataset.addValue((Number)this.stmtCountMap.get(stmtType), (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
            }
            String title = Messages.getString(ReportBuilder.class, "pie1.title");
            String xAxis = Messages.getString(ReportBuilder.class, "firstbar.category.axis");
            String yAxis = Messages.getString(ReportBuilder.class, "firstbar.value.axis");
            this.parameters.put("usagePie", this.createFirstStackedBar(dataset, title, xAxis, yAxis, 1000, 760));
        } else {
            super.buildSummaryFirstChart(allPrgNo);
        }
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.dbi"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.function"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.pattern"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

