/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.dbiVsPrograms;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.wu.WUAbstractAnalysis;
import com.ez.report.application.ezreport.reports.wu.dbiVsPrograms.DBIInput;
import com.ez.report.application.ezreport.reports.wu.dbiVsPrograms.DBIVsProgramsJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.InputsCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceDBIIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBIVsProgramsAnalysis
extends WUAbstractAnalysis {
    private static final Logger L = LoggerFactory.getLogger(DBIVsProgramsAnalysis.class);
    private static final String DBI_RESOURCES_QUERY = "SELECT DISTINCT Resources.ResourceID, Resources.Name FROM Resources INNER JOIN StatementReference ON Resources.ResourceID =StatementReference.ResourceID WHERE StatementReference.ResourceType = 190 AND Resources.OccurID<>-1 ";

    public DBIVsProgramsAnalysis() {
        this(null);
    }

    public DBIVsProgramsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    protected void processSpecificInput(EZObjectType objType, List<EZEntityID> list, List<BaseMainframeResourceInput> sel, Set<String> inputNames) {
        EZEntityID entity = objType.getEntID();
        list.add(entity);
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
        if (prjSg != null) {
            EZSourceDBIIDSg dbiIDSg;
            if (!prjSg.getProjectName().equals(this.projectName)) {
                this.setPrjName(prjSg.getProjectName());
                this.addContextValue("input_project_names", prjSg.getProjectName());
                ProjectInfo pInfo = prjSg.getProjectInfo();
                com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
            }
            if ((dbiIDSg = (EZSourceDBIIDSg)objType.getProperty("mainframe resource id sg")) == null) {
                dbiIDSg = (EZSourceDBIIDSg)entity.getSegment(EZSourceDBIIDSg.class);
            }
            if (dbiIDSg != null) {
                String name = dbiIDSg.getResourceName();
                Integer dbiID = dbiIDSg.getTableID();
                sel.add(new DBIInput(name, 190, dbiID));
                inputNames.add(name);
            }
        }
    }

    @Override
    public PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(DBIVsProgramsAnalysis.class, "wizzard.title");
        wizard.setWindowTitle(wizardName);
        GenericSelectInputPage4Report selectProgramsPage = new GenericSelectInputPage4Report("programs page");
        selectProgramsPage.setLeftGroupLabel(Messages.getString(DBIVsProgramsAnalysis.class, "av.objectType.DBISource"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(DBIVsProgramsAnalysis.class, "sel.objectType.DBISource"));
        DBICollector pc = new DBICollector();
        pc.setResourcesQuery(DBI_RESOURCES_QUERY);
        selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
        selectProgramsPage.setSelectedPropName("selected resources");
        wizard.addPage(selectProgramsPage);
        return wizard;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_DBI_VS_PROGRAMS_ANALYSIS;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, DBIVsProgramsJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    @Override
    protected void completeSelectedPrograms(PrepareReportWizard wizard) {
        List old = wizard.getList("selected resources");
        List sel = BaseResourceInput4GUI.extractNonGUIObjects((Collection)old);
        wizard.set("selected resources", (Object)sel);
        if (sel != null) {
            HashSet<String> inputNames = new HashSet<String>();
            for (DBIInput ji : sel) {
                inputNames.add(ji.getName());
            }
            this.addContextValue("inputs name string", inputNames);
        }
    }

    class DBICollector
    extends InputsCollector {
        DBICollector() {
        }

        public List<BaseResourceInput4GUI> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
            ArrayList<BaseResourceInput4GUI> resources = new ArrayList<BaseResourceInput4GUI>();
            try {
                String[][] results = conn.executeSQL(this.resourcesQuery);
                if (results != null && results.length > 0) {
                    String[][] stringArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] result = stringArray[n2];
                        String resourceID = result[0];
                        String resourceName = result[1];
                        DBIInput dbiRes = new DBIInput(resourceName, 190, Integer.valueOf(resourceID));
                        resources.add((BaseResourceInput4GUI)new BaseMainframeResource4GUI((BaseResourceInput)dbiRes));
                        ++n2;
                    }
                }
            }
            catch (EZSourceConnectionException e) {
                L.error("connection error", (Throwable)e);
            }
            return resources;
        }
    }
}

