/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.datasetsVsJobs;

import com.ez.common.model.LogMessage;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.gui.utils.DatasetUtils;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.ProgramComparator;
import com.ez.report.application.ezreport.reports.wu.EZLineBorder;
import com.ez.report.application.ezreport.reports.wu.WUDataSource;
import com.ez.report.application.ezreport.reports.wu.datasetsVsJobs.ReportModel;
import com.ez.report.application.ezreport.reports.wu.twolevels.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.twolevels.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.twolevels.WUTwoLevelsBuilder;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUTwoLevelsBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String STORED_PROCEDURE_SEL = "EZReports_DatasetsVsJobs_Selective";
    private static final String STORED_PROCEDURE_SEL_UCMDB = "EZReports_DatasetsVsJobs_UCMDB_Selective";
    private Map<String, Integer> stmtCountMap = new HashMap<String, Integer>();
    private Set<String[]> selectedDSs;

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected void putExternalizedParameters(Map<String, Object> params) {
        super.putExternalizedParameters(params);
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        params.put("sum3", null);
        params.put("sum4", null);
        externalized = Messages.getString(ReportBuilder.class, "summary");
        params.put("summary", externalized);
        params.put("sum1.1", this.UTILITY_GROUPSUMMARY_LABEL);
        params.put("utilityStmtName", this.UTILITY_COLUMN2_TEXT);
        params.put("sum1.2", this.UNKNOWNPROGRAM_GROUPSUMMARY_LABEL);
        params.put("unknownProgramText", this.LOADMODULE_COLUMN2_TEXT);
    }

    protected Collection filterSelectedIDs() {
        if (this.selectedIds == null) {
            MultipleVSAMInput firstInput;
            this.selectedIds = new HashSet();
            Collection selectedResources = this.getSelected();
            this.selectedDSs = new HashSet<String[]>();
            MultipleVSAMInput multipleVSAMInput = firstInput = selectedResources != null ? (MultipleVSAMInput)selectedResources.iterator().next() : null;
            if (firstInput != null && firstInput instanceof MultipleVSAMInput && firstInput.isIncomplete()) {
                final HashMap<String, MultipleVSAMInput> dsNames = new HashMap<String, MultipleVSAMInput>();
                for (VSAMInput inp : selectedResources) {
                    dsNames.put(inp.getName(), (MultipleVSAMInput)inp);
                }
                final List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[dsNames.size()]);
                Collections.fill(types, EZSourceDataType.String);
                IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
                try {
                    ph.executeWithLock(ph, new IMFRunnable(){

                        public void run(EZSourceConnection bridge, IProgressMonitor pmonitor) {
                            String[][] infoToCompleteInputs = bridge.executeSQL(DatasetUtils.getDatasetInputInfoQuery((ServerType)bridge.getProjectInfo().getDbEngine()), types, new ArrayList(dsNames.keySet()));
                            if (infoToCompleteInputs != null) {
                                String[][] stringArray = infoToCompleteInputs;
                                int n = infoToCompleteInputs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String[] info = stringArray[n2];
                                    MultipleVSAMInput inp = (MultipleVSAMInput)dsNames.get(info[1]);
                                    inp.addInfo(Integer.valueOf(info[0]), info[2]);
                                    ++n2;
                                }
                            }
                        }
                    }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException interruptedException) {
                    throw new CanceledException("connection interrupted");
                }
                catch (ExecutionException e) {
                    ErrorUtils.handleExecutionException((ExecutionException)e);
                }
            }
            for (MultipleVSAMInput inpt : selectedResources) {
                for (Integer value : inpt.getIds()) {
                    this.selectedDSs.add(new String[]{String.valueOf(value), inpt.getMemberName()});
                }
                this.selectedIds.addAll(inpt.getIds());
            }
        }
        return this.selectedIds;
    }

    @Override
    protected List<Obj4Report> getDBData(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        String[][] results;
        List<Obj4Report> result;
        block10: {
            result = null;
            results = null;
            EZSourceConnection bridge = null;
            try {
                try {
                    Collection selectedIDs = this.filterSelectedIDs();
                    SingleQueryResult queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer, selectedIDs);
                    results = queryResult.data;
                }
                catch (EZSourceConnectionException e) {
                    L.error("exception at getting data for report", (Throwable)e);
                    EZReportErrorLog.err(Messages.getString(ReportBuilder.class, "gettingDataError.logMessage"), e);
                    if (bridge != null) {
                        EZSourceConnectionManager.release(bridge);
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (bridge != null) {
                    EZSourceConnectionManager.release(bridge);
                }
                throw throwable;
            }
            if (bridge != null) {
                EZSourceConnectionManager.release(bridge);
            }
        }
        if (results == null) {
            L.warn("no results for UsedDatasetInJobs report");
        } else {
            result = this.prepareReportData(pmonitor, results, csvWriter);
        }
        return result;
    }

    private List<Obj4Report> prepareReportData(IProgressMonitor pmonitor, String[][] results, CSVWriter csvWriter) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)results.length);
        ArrayList<Obj4Report> result = new ArrayList<Obj4Report>();
        L.debug("Dataset Vs Jobs results:");
        String currentDataset = null;
        String currentJob = null;
        int count = 0;
        boolean noStmt = true;
        int i = 0;
        while (i < results.length) {
            block18: {
                Integer countValue;
                HashMap<String, Integer> prgMap;
                String stmtType4Charts;
                WUTwoLevelsBuilder.AccessingType type;
                String jobNameToPrint;
                String prgPath;
                String memberName;
                Integer stmtCount;
                String stmtType;
                String prgName;
                String jobName;
                String datasetName;
                block16: {
                    block17: {
                        block15: {
                            boolean hasAncestor;
                            String[] row = results[i];
                            results[i] = null;
                            String dsMemberName = row[8];
                            datasetName = String.valueOf(row[0]) + (dsMemberName != null && !dsMemberName.isEmpty() ? "(" + dsMemberName + ")" : "");
                            jobName = row[1];
                            prgName = row[2];
                            String ancestor = row[3];
                            stmtType = row[4];
                            stmtCount = new Integer(Integer.parseInt(row[5]));
                            memberName = row.length > 6 ? row[7] : null;
                            prgPath = row[9];
                            jobNameToPrint = memberName != null && !memberName.equalsIgnoreCase(jobName) ? String.valueOf(jobName) + " (" + memberName + ")" : jobName;
                            boolean bl = hasAncestor = ancestor != null && !ancestor.isEmpty();
                            if (hasAncestor) {
                                prgName = String.valueOf(ancestor) + ": " + prgName;
                            }
                            type = WUTwoLevelsBuilder.AccessingType.PROGRAM;
                            stmtType4Charts = "";
                            if (!"#EZ1#".equals(stmtType)) break block15;
                            stmtCount = new Integer(1);
                            noStmt = true;
                            if (com.ez.mainframe.data.utils.Utils.isUtility((String)prgName)) {
                                stmtType = this.UTILITY_COLUMN2_TEXT;
                                stmtType4Charts = this.UTILITY_DETAIL_FIRSTCOLUMN_PART;
                                type = WUTwoLevelsBuilder.AccessingType.UTILITY;
                            } else {
                                stmtType = this.LOADMODULE_COLUMN2_TEXT;
                                stmtType4Charts = this.LOADMODULE_CHART_TEXT;
                                type = WUTwoLevelsBuilder.AccessingType.LOAD_MODULE;
                            }
                            break block16;
                        }
                        if (!"#EZ2#".equals(stmtType)) break block17;
                        if (com.ez.mainframe.data.utils.Utils.isUtility((String)prgName)) break block18;
                        stmtCount = new Integer(1);
                        noStmt = true;
                        stmtType = this.LOADMODULE_COLUMN2_TEXT;
                        stmtType4Charts = this.UNKOWNPROGRAM_CHART_TEXT;
                        type = WUTwoLevelsBuilder.AccessingType.UNKNOWN_PROGRAM;
                        break block16;
                    }
                    noStmt = false;
                    stmtType4Charts = stmtType;
                }
                if (currentDataset == null) {
                    currentDataset = datasetName;
                    currentJob = jobNameToPrint;
                    ++count;
                } else if (!currentDataset.equalsIgnoreCase(datasetName)) {
                    this.usedResources.put(currentDataset, new Integer(count));
                    currentDataset = datasetName;
                    currentJob = jobNameToPrint;
                    count = 1;
                } else if (!currentJob.equalsIgnoreCase(jobNameToPrint)) {
                    currentJob = jobNameToPrint;
                    ++count;
                }
                if (i == results.length - 1) {
                    this.usedResources.put(currentDataset, new Integer(count));
                }
                if ((prgMap = (HashMap<String, Integer>)this.allResMap.get(datasetName)) == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allResMap.put(datasetName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType4Charts)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType4Charts, countValue);
                if (!this.stmtCountMap.containsKey(stmtType4Charts)) {
                    this.stmtCountMap.put(stmtType4Charts, stmtCount);
                } else {
                    int temp = this.stmtCountMap.get(stmtType4Charts);
                    int currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType4Charts, new Integer(temp + currentCount));
                }
                if (prgPath != null && !prgPath.isEmpty()) {
                    prgName = prgName.concat(" (").concat(prgPath).concat(")");
                }
                L.debug("dataset: {}", (Object)datasetName);
                L.debug("job: {}", (Object)jobName);
                L.debug("memberName: {}", (Object)memberName);
                L.debug("program: {}", (Object)prgName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.level1 = datasetName;
                obj.level1Type = Messages.getString(ReportBuilder.class, "dataset.group.type");
                obj.level2 = jobNameToPrint;
                obj.level2Type = Messages.getString(ReportBuilder.class, "detail.resourceType");
                obj.level3 = this.getColum1Text(prgName, type);
                obj.setStmtType(noStmt ? stmtType : this.getColum2Text(stmtType, type));
                obj.setCount(noStmt ? 0 : stmtCount);
                obj.level1Tooltip = datasetName;
                obj.level2Tooltip = jobNameToPrint;
                result.add(obj);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{datasetName, jobNameToPrint, obj.level3, obj.getStmtType(), obj.getCount() == 0 ? "" : obj.getCount().toString()});
                }
                monitor.worked(1);
            }
            ++i;
        }
        return result;
    }

    @Override
    protected void buildSummaryFirstChart(int allPrgNo) {
        if (this.stmtCountMap.size() > 0) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            ArrayList<String> stmtTypes = new ArrayList<String>(this.stmtCountMap.keySet());
            Collections.sort(stmtTypes, String.CASE_INSENSITIVE_ORDER);
            for (String stmtType : stmtTypes) {
                dataset.addValue((Number)this.stmtCountMap.get(stmtType), (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
            }
            String title = Messages.getString(ReportBuilder.class, "pie1.title");
            String xAxis = Messages.getString(ReportBuilder.class, "firstbar.category.axis");
            String yAxis = Messages.getString(ReportBuilder.class, "firstbar.value.axis");
            this.parameters.put("usagePie", this.createFirstStackedBar(dataset, title, xAxis, yAxis, 1000, 760));
        } else {
            super.buildSummaryFirstChart(allPrgNo);
        }
    }

    @Override
    protected String getUsedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
    }

    @Override
    protected String getUnusedCategoryLegendLabel() {
        return Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
    }

    @Override
    protected String getPieTitle() {
        return Messages.getString(ReportBuilder.class, "pie1.title");
    }

    @Override
    protected String getInputTypeName() {
        return Messages.getString(ReportBuilder.class, "inputTypeName.lbl");
    }

    @Override
    protected String getUsedCategoryLabel() {
        return Messages.getString(ReportBuilder.class, "using.lbl");
    }

    @Override
    protected String getUnusedCategoryLabel() {
        return Messages.getString(ReportBuilder.class, "notUsing.lbl");
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        ReportDataSource ds = (ReportDataSource)super.getDataSource(pmonitor);
        ds.setDomainAxisLabel(Messages.getString(ReportBuilder.class, "stackedBar.domainAxis.lbl"));
        ds.setStackedBarTitle(Messages.getString(ReportBuilder.class, "stackedBar.title"));
        return ds;
    }

    protected String getProcedure() {
        return null;
    }

    protected String getSelectiveProcedure() {
        boolean vb;
        Object selectedApps = this.report.getProperty("filtered by app");
        boolean bl = vb = this.isMultiApp() && selectedApps != null && (Boolean)selectedApps != false;
        if (vb) {
            return STORED_PROCEDURE_SEL_UCMDB;
        }
        return STORED_PROCEDURE_SEL;
    }

    protected void queryForData(Object[] procParam, ParameterInfo[] pInfo, EZSourceDataType paramType, Collection selected, SingleQueryResult queryResult, EZSourceConnection conn) {
        EZSourceConnectionException ex = null;
        try {
            Collection app;
            ArrayList<EZSourceDataType> types = new ArrayList<EZSourceDataType>();
            ArrayList values = new ArrayList();
            Object selectedApps = this.report.getProperty("filtered by app");
            if (this.isMultiApp() && selectedApps != null && ((Boolean)selectedApps).booleanValue() && (app = this.report.getSelectedApplications()) != null && !app.isEmpty()) {
                values.addAll(app);
                types.addAll(Arrays.asList(new EZSourceDataType[app.size()]));
                Collections.fill(types, EZSourceDataType.Integer);
            }
            if (selected != null) {
                String selectiveProc = this.getSelectiveProcedure();
                Assert.isNotNull((Object)selectiveProc);
                String tempTableName = "ds_param_temp";
                conn.executeUpdate(Utils.buildCreateStr4DSParamTable(conn, tempTableName));
                ArrayList<EZSourceDataType> dstypes = new ArrayList<EZSourceDataType>();
                dstypes.add(EZSourceDataType.Integer);
                dstypes.add(EZSourceDataType.String);
                String[][] param = this.selectedDSs != null ? (String[][])this.selectedDSs.toArray((T[])new String[this.selectedDSs.size()][2]) : null;
                conn.insertBatch(com.ez.mainframe.data.utils.Utils.getTempTableName((EZSourceConnection)conn, (String)tempTableName), param, dstypes);
                queryResult.data = conn.execNonTransactionalStoredProc(selectiveProc, procParam, types, values);
                queryResult.resourcesCount = this.selectedDSs != null ? this.selectedDSs.size() : 0;
                com.ez.mainframe.data.utils.Utils.dropTempTable((EZSourceConnection)conn, (String)tempTableName);
            }
        }
        catch (EZSourceConnectionException e) {
            ex = e;
            L.error("exception at executing stored procedure", (Throwable)e);
            this.messages.add(new LogMessage(Messages.getString(ReportBuilder.class, "storedProcedureError.logMessage"), 4, "com.ez.mainframe.reports.core", (Throwable)e));
        }
        if (ex != null) {
            throw ex;
        }
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, false);
            this.report.setInput(this.inputs.get("selected resources"));
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            this.report.addProperty("selected app names", this.inputs.get("selected applications names"));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void clearForJasperReport() {
        this.stmtCountMap.clear();
        super.clearForJasperReport();
    }

    @Override
    public void cleanMemory() {
        if (this.stmtCountMap != null) {
            this.stmtCountMap.clear();
            this.stmtCountMap = null;
        }
        super.cleanMemory();
    }

    protected String prepareAppendixResrsList(Set inputs) {
        Set apps;
        StringBuffer buff = new StringBuffer();
        Iterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            MultipleVSAMInput res = (MultipleVSAMInput)iterator.next();
            buff.append(res.getName());
            if (iterator.hasNext()) {
                buff.append(",");
            }
            L.debug("{}", (Object)res);
        }
        String ret = ReportsUtils.stripNonValidXMLCharacters((String)buff.toString(), (boolean)true);
        Object selectedApps = this.report.getProperty("filtered by app");
        if (selectedApps != null && ((Boolean)selectedApps).booleanValue() && this.isMultiApp() && (apps = (Set)this.getReportModel().getProperty("selected app names")) != null && !apps.isEmpty()) {
            ret = ret.concat("\n");
            ret = ret.concat(Messages.getString(ReportBuilder.class, "appendix.applications.part")).concat(apps.toString());
            this.setApplicationName(apps);
        }
        return ret;
    }

    @Override
    protected Image createFirstStackedBar(DefaultCategoryDataset ds, String title, String xAxis, String yAxis, int width, int height) {
        return WUDataSource.createStackedBar(ds, title, this.titleFont, xAxis, yAxis, width, height, Color.black);
    }

    @Override
    protected Image createSecondStackedBar(DefaultCategoryDataset dataset, String titleStr, String xAxis, String yAxis, int imgWidth, int imgHeight, Color seriePaint, String subtitleString) {
        imgWidth = 1000;
        imgHeight = 760;
        TextTitle title = new TextTitle(titleStr, this.titleFont);
        this.verticalChart = ChartFactory.createStackedBarChart(null, (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.verticalChart.setTitle(title);
        this.verticalChart.setBackgroundPaint((Paint)Color.white);
        this.verticalChart.setBorderVisible(false);
        this.verticalChart.setPadding(new RectangleInsets(20.0, 5.0, 5.0, 5.0));
        CategoryPlot plot = this.verticalChart.getCategoryPlot();
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(4.0, 1.0, 1.0, 4.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        LegendTitle leg = this.verticalChart.getLegend();
        leg.setFrame((BlockFrame)new EZLineBorder());
        leg.setItemFont(legendFont);
        leg.setItemPaint((Paint)Color.DARK_GRAY);
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.DARK_GRAY);
        axis.setLabelFont(this.labelFont);
        axis.setTickLabelsVisible(false);
        axis.setVisible(true);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setLabelFont(this.labelFont);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setMaximumBarWidth(0.1);
        renderer.setShadowVisible(false);
        renderer.setDrawBarOutline(true);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setSeriesPaint(0, (Paint)this.ORANGE_COLOR);
        renderer.setBaseItemLabelFont(this.labelFont);
        plot.setRenderer((CategoryItemRenderer)renderer);
        if (this.countsSame != 0 && subtitleString != null) {
            this.parameters.put("footerNote", subtitleString);
        }
        return this.verticalChart.createBufferedImage(imgWidth, imgHeight, (double)(imgWidth / 2), (double)(imgHeight / 2), null);
    }

    @Override
    protected DefaultCategoryDataset buildDataSet(Map dsMap) {
        ArrayList datasets = new ArrayList(dsMap.keySet());
        ProgramComparator pComparator = new ProgramComparator();
        pComparator.setMapWithCounts(dsMap);
        Collections.sort(datasets, pComparator);
        int i = 0;
        int prag = 0;
        this.countsSame = 0;
        boolean endOfBars = false;
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (String datasetName : datasets) {
            Integer nr = (Integer)dsMap.get(datasetName);
            if (i < 20) {
                ds.addValue((Number)nr, (Comparable)((Object)datasetName), (Comparable)((Object)datasetName));
                prag = nr;
            } else if (!endOfBars) {
                if (prag == nr) {
                    ++this.countsSame;
                } else {
                    endOfBars = true;
                }
            }
            ++i;
        }
        return ds;
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
        List pages;
        super.customizeJasperPrint(print);
        if (print != null && (pages = print.getPages()) != null && pages.size() > 0) {
            ReportsUtils.removeEmptyPages((List)pages, (String)"mainframe datasets vs jobs");
        }
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.dataset"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.job"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.accessedBy"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.confirmed"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

