/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.datasetsVsJobs;

import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.wu.WUAbstractAnalysis;
import com.ez.report.application.ezreport.reports.wu.datasetsVsJobs.DatasetsVsJclJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.MultipleVSAMCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.ProjectInfoConverter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DatasetsVsJobsAnalysis
extends WUAbstractAnalysis {
    public DatasetsVsJobsAnalysis() {
        this(null);
    }

    public DatasetsVsJobsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            if (inputs.size() > 0 && inputs.get(0) instanceof EZSourceProjectInputType) {
                super.setInputs(inputs);
            } else {
                ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
                this.params = new HashMap();
                ArrayList<MultipleVSAMInput> sel = new ArrayList<MultipleVSAMInput>();
                HashSet<String> inputNames = new HashSet<String>();
                for (Object inpObj : inputs) {
                    if (!(inpObj instanceof EZSourceDataset)) continue;
                    EZEntityID entity = ((EZSourceDataset)inpObj).getEntID();
                    list.add(entity);
                    EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
                    if (prjSg == null) continue;
                    if (!prjSg.getProjectName().equals(this.projectName)) {
                        this.setPrjName(prjSg.getProjectName());
                        this.addContextValue("input_project_names", prjSg.getProjectName());
                        ProjectInfo pInfo = prjSg.getProjectInfo();
                        com.ez.ezsource.connection.ProjectInfo prjInfo = ProjectInfoConverter.convert((Map)pInfo.getInfo());
                        this.projectDatabasebEngine = prjInfo.getDbEngine().getValue();
                    }
                    EZSourceDatasetIDSg datasetSg = (EZSourceDatasetIDSg)entity.getSegment(EZSourceDatasetIDSg.class);
                    String name = datasetSg.getDatasetName();
                    MultipleVSAMInput mvsami = new MultipleVSAMInput(name, datasetSg.getDatasetMemberName(), datasetSg.getDatasetId(), datasetSg.getGenerationNumber());
                    mvsami.setIncomplete(datasetSg.isIncompleteSegment());
                    sel.add(mvsami);
                    inputNames.add(mvsami.getListableName());
                    this.addContextValue("input_project_names", prjSg.getProjectName());
                }
                if (!sel.isEmpty()) {
                    this.params = new HashMap();
                    this.params.put("project_name", this.projectName);
                    this.params.put("report_model", this.report);
                    this.params.put("selected resources", sel);
                    this.params.put("show summary only", Boolean.FALSE);
                    this.params.put("show appendix", com.ez.mainframe.reports.gui.preferences.PreferenceUtils.getPreferenceStore().getBoolean("showAppendix"));
                    this.params.put("showInputDetails", com.ez.mainframe.reports.gui.preferences.PreferenceUtils.getPreferenceStore().getBoolean("showInputDetails"));
                    this.params.put("all resources selected", Boolean.FALSE);
                    this.addAllContextValues(this.params);
                    this.addContextValue("input_list", list);
                    this.addContextValue("inputs name string", inputNames);
                }
            }
        }
    }

    @Override
    public PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(DatasetsVsJobsAnalysis.class, "wizzard.title");
        wizard.setWindowTitle(wizardName);
        GenericSelectInputPage4Report selectDatasetsPage = new GenericSelectInputPage4Report("programs page");
        selectDatasetsPage.setLeftGroupLabel(Messages.getString(DatasetsVsJobsAnalysis.class, "av.objectType.datasets"));
        selectDatasetsPage.setRightGroupLabel(Messages.getString(DatasetsVsJobsAnalysis.class, "sel.objectType.datasets"));
        boolean showTemporaryDatasets = PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
        MultipleVSAMCollector ic = new MultipleVSAMCollector();
        if (showTemporaryDatasets) {
            ic.setResourcesQuery("SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID WHERE JCLPhysicalDataSet.IsInstream<>1 ORDER BY DataSetName,GenerationNumber, MemberName");
        } else {
            ic.setResourcesQuery("SELECT DISTINCT JCLPhysicalDataSet.DataSetID, DataSetName, GenerationNumber, jclddref.MemberName\nFROM JCLPhysicalDataSet left join jclddref on jclddref.DataSetID = JCLPhysicalDataSet.DataSetID WHERE JCLPhysicalDataSet.IsInstream<>1 AND JCLPhysicalDataSet.Istemp<>1 ORDER BY DataSetName,GenerationNumber, MemberName");
        }
        selectDatasetsPage.setResourcesCollector((ResourcesCollector)ic);
        wizard.setWindowTitle(wizardName);
        wizard.addPage(selectDatasetsPage);
        return wizard;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_DATASETS_VS_JOBS_ANALYSIS;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, DatasetsVsJclJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    @Override
    protected void completeSelectedPrograms(PrepareReportWizard wizard) {
        List old = wizard.getList("selected resources");
        List sel = BaseResourceInput4GUI.extractNonGUIObjects((Collection)old);
        wizard.set("selected resources", (Object)sel);
        if (sel != null) {
            HashSet<String> inputNames = new HashSet<String>();
            for (VSAMInput ji : sel) {
                inputNames.add(ji.getListableName());
            }
            this.addContextValue("inputs name string", inputNames);
        }
    }
}

