/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.datacomTablesVsPrograms;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.datacomTablesVsPrograms.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.datacomTablesVsPrograms.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.datacomTablesVsPrograms.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String EZREP_DATACOMTablesVsPrograms_UCMDB_Selective = "EZReports_DatacomTablesVsPrograms_UCMDB_selective";
    private static final String EZREP_DATACOMTablesVsPrograms = "EZReports_DatacomTablesVsPrograms";
    private static final String EZREP_DATACOMTablesVsPrograms_UCMDB = "EZReports_DatacomTablesVsPrograms_UCMDB";
    private static final String EZREP_DATACOMTablesVsPrograms_Selective = "EZReports_DatacomTablesVsPrograms_Selective";
    private Map allPrgMap = null;
    private Map usedTbls = null;
    private Map stmtCountMap = null;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.resultList = new ArrayList();
        this.allPrgMap = new HashMap();
        this.usedTbls = new HashMap();
        this.stmtCountMap = new HashMap();
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        ReportDataSource dataSource = null;
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
            dataSource = new ReportDataSource(this.resultList, this.allPrgMap);
        }
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            Collection selected = (Collection)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            if (selectedApps != null) {
                Collection appNames = (Collection)this.inputs.get("selected applications names");
                for (ProgramInputNoGUI prg : selected) {
                    prg.setApplicationsName((Set)appNames);
                }
            }
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedFiles.jasper";
    }

    private void clearForJasperReport() {
        this.usedTbls.clear();
        this.stmtCountMap.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected String getProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return EZREP_DATACOMTablesVsPrograms_UCMDB;
        }
        return EZREP_DATACOMTablesVsPrograms;
    }

    protected String getSelectiveProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return EZREP_DATACOMTablesVsPrograms_UCMDB_Selective;
        }
        return EZREP_DATACOMTablesVsPrograms_Selective;
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        String yAxis;
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor);
        String[][] results = queryResult.data;
        this.getSelected().size();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        if (results == null) {
            L.warn("no results for UsedDatacomTables report");
        } else {
            L.debug("DatacomTables Vs Programs results:");
            String currentTable = null;
            String currentPrg = null;
            int count = 0;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashMap<String, Integer> prgMap;
                String tableName = results[i][0];
                String prgName = results[i][1];
                String stmtType = results[i][2];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][3]));
                String parentName = results[i][4];
                String prgPath = results[i][5];
                if (parentName != null && !parentName.isEmpty()) {
                    prgName = String.valueOf(parentName) + ": " + prgName;
                }
                if (prgPath != null && !prgPath.isEmpty()) {
                    prgName = prgName.concat(" (").concat(prgPath).concat(")");
                }
                if (currentTable == null) {
                    currentTable = tableName;
                    currentPrg = prgName;
                    ++count;
                } else if (!currentTable.equalsIgnoreCase(tableName)) {
                    this.usedTbls.put(currentTable, new Integer(count));
                    currentTable = tableName;
                    currentPrg = prgName;
                    count = 1;
                } else if (!currentPrg.equalsIgnoreCase(prgName)) {
                    currentPrg = prgName;
                    ++count;
                }
                if (i == results.length - 1) {
                    this.usedTbls.put(currentTable, new Integer(count));
                }
                L.debug("datacom table: {}", (Object)tableName);
                L.debug("program: {}", (Object)prgName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.setProgramName(tableName);
                obj.setFileName(prgName);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{tableName, prgName, stmtType, stmtCount.toString()});
                }
                if ((prgMap = (HashMap<String, Integer>)this.allPrgMap.get(tableName)) == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allPrgMap.put(tableName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                this.resultList.add(obj);
                if (!this.stmtCountMap.containsKey(stmtType)) {
                    this.stmtCountMap.put(stmtType, stmtCount);
                } else {
                    int temp = (Integer)this.stmtCountMap.get(stmtType);
                    int currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType, new Integer(temp + currentCount));
                }
                ++i;
            }
        }
        if (this.stmtCountMap.size() > 0) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            for (String stmtType : this.stmtCountMap.keySet()) {
                dataset.addValue((Number)((Integer)this.stmtCountMap.get(stmtType)), (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
            }
            String title = Messages.getString(ReportBuilder.class, "pie1.title");
            String xAxis = Messages.getString(ReportBuilder.class, "firstbar.category.axis");
            yAxis = Messages.getString(ReportBuilder.class, "firstbar.value.axis");
            this.parameters.put("usagePie", this.createFirstStackedBar(dataset, title, xAxis, yAxis, 1000, 760));
        }
        if (this.usedTbls.size() > 0) {
            String stackTitle = Messages.getString(ReportBuilder.class, "pie2.title");
            DefaultCategoryDataset ds = this.buildDataSet(this.usedTbls);
            String subtitle = null;
            if (this.usedTbls.keySet().size() >= 20) {
                Object[] msgParams = new String[]{String.valueOf(20)};
                stackTitle = stackTitle.concat(" ").concat(Messages.getString(ReportBuilder.class, "bar.title", msgParams));
                if (this.countsSame != 0) {
                    msgParams = new String[]{String.valueOf(this.countsSame)};
                    stackTitle = stackTitle.concat("*");
                    subtitle = Messages.getString(ReportBuilder.class, "bar.subtitle", msgParams);
                }
            }
            String xAxis = Messages.getString(ReportBuilder.class, "bar.category.axis");
            yAxis = Messages.getString(ReportBuilder.class, "bar.value.axis");
            this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, stackTitle, xAxis, yAxis, 880, 540, null, subtitle));
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    protected String prepareAppendixResrsList(Set prgList) {
        String ret = "";
        ret = ret.concat(prgList.toString());
        Object selectedApps = this.report.getProperty("filtered by app");
        boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
        if (selectedApps != null && ((Boolean)selectedApps).booleanValue() && projectIsUCMDB) {
            Set apps = null;
            Iterator iterator = prgList.iterator();
            while (iterator.hasNext() && apps == null) {
                ProgramInputNoGUI prg = (ProgramInputNoGUI)iterator.next();
                if (prg.getApplications() == null || prg.getApplications().isEmpty()) continue;
                apps = prg.getApplications();
            }
            if (apps != null && !apps.isEmpty()) {
                ret = ret.concat("\n");
                ret = ret.concat(Messages.getString(ReportBuilder.class, "appendix.applications.part")).concat(apps.toString());
                this.setApplicationName(apps);
            }
        }
        return ret;
    }

    @Override
    public void cleanMemory() {
        if (this.allPrgMap != null) {
            this.allPrgMap.clear();
            this.allPrgMap = null;
        }
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        if (this.stmtCountMap != null) {
            this.stmtCountMap.clear();
            this.stmtCountMap = null;
        }
        if (this.usedTbls != null) {
            this.usedTbls.clear();
            this.usedTbls = null;
        }
        super.cleanMemory();
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.datacom"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }
}

