/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.adabasVsPrograms;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.AdabasUtils;
import com.ez.mainframe.model.AdabasFileInput;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.application.ezreport.reports.wu.adabasVsPrograms.Obj4Report;
import com.ez.report.application.ezreport.reports.wu.adabasVsPrograms.ReportDataSource;
import com.ez.report.application.ezreport.reports.wu.adabasVsPrograms.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends WUReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String STORED_PROCEDURE = "EZReports_AdabasVsPrograms";
    private static final String STORED_PROCEDURE_SEL = "EZReports_AdabasVsPrograms_Selective";
    private static final String STORED_PROCEDURE_UCMDB = "EZReports_AdabasVsPrograms_UCMDB";
    private static final String STORED_PROCEDURE_SEL_UCMDB = "EZReports_AdabasVsPrograms_UCMDB_Selective";
    Map<String, Map<String, Integer>> allResMap = new HashMap<String, Map<String, Integer>>();
    private Map<String, Integer> used = new HashMap<String, Integer>();
    private Map<String, Integer> stmtCountMap = new HashMap<String, Integer>();

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        ReportDataSource dataSource = null;
        try (CSVWriter csvWriter = this.doCSVInitOperations();){
            this.data((IProgressMonitor)monitor.newChild(100), csvWriter);
            dataSource = new ReportDataSource(this.resultList, this.allResMap);
        }
        return dataSource;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            List selected = (List)this.inputs.get("selected resources");
            this.report.setInput((Object)selected);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", selectedApps);
            if (selectedApps != null) {
                Collection appNames = (Collection)this.inputs.get("selected applications names");
                for (ProgramInputNoGUI prg : selected) {
                    prg.setApplicationsName((Set)appNames);
                }
            }
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "stmtType.column.name");
        params.put("stmtType.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "file.column.name");
        params.put("file.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "count.column.name");
        params.put("count.column.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "summary");
        params.put("summary", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum1");
        params.put("sum1", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum2");
        params.put("sum2", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum3");
        params.put("sum3", externalized);
        externalized = Messages.getString(ReportBuilder.class, "sum4");
        params.put("sum4", externalized);
    }

    @Override
    protected String getReportTemplatePath() {
        return "reports/usedFiles.jasper";
    }

    private void clearForJasperReport() {
        this.used.clear();
        this.stmtCountMap.clear();
        this.parameters.put("usagePie", null);
        this.parameters.put("progrVSFilesPie", null);
    }

    protected String getProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_UCMDB;
        }
        return STORED_PROCEDURE;
    }

    protected String getSelectiveProcedure() {
        if (this.report.getSelectedApplications() != null && !this.report.getSelectedApplications().isEmpty()) {
            return STORED_PROCEDURE_SEL_UCMDB;
        }
        return STORED_PROCEDURE_SEL;
    }

    protected Collection filterSelectedIDs() {
        if (this.selectedIds == null) {
            this.selectedIds = new HashSet();
            Collection selectedResources = this.getSelected();
            for (AdabasFileInput inpt : selectedResources) {
                this.selectedIds.add(inpt.getResourceID());
            }
        }
        return this.selectedIds;
    }

    private String[][] data(IProgressMonitor pmonitor, CSVWriter csvWriter) {
        String yAxis;
        String xAxis;
        DefaultPieDataset dataset;
        this.clearForJasperReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        SingleQueryResult queryResult = this.queryForData(pmonitor, EZSourceDataType.Integer, this.filterSelectedIDs());
        String[][] results = queryResult.data;
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        if (results == null) {
            L.warn("no results for AdabasVsPrograms report");
            dataset = new DefaultPieDataset();
            String usedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"used.category.lbl");
            String unusedCategory = Messages.getString4ChartLegend(ReportBuilder.class, (String)"unused.category.lbl");
            String not_using_category_lbl = Messages.getString(ReportBuilder.class, "notUsed.lbl");
            String using_category_lbl = Messages.getString(ReportBuilder.class, "used.lbl");
            dataset.setValue((Comparable)((Object)not_using_category_lbl), (Number)new Double(((Collection)this.getReportModel().getProperty("inputs")).size()));
            dataset.setValue((Comparable)((Object)using_category_lbl), (Number)new Double(0.0));
            HashMap<String, String> formatsMap = new HashMap<String, String>();
            formatsMap.put(not_using_category_lbl, unusedCategory);
            formatsMap.put(using_category_lbl, usedCategory);
            String titleStr = Messages.getString(ReportBuilder.class, "pie1.title");
            this.parameters.put("usagePie", this.createPieChartImage(dataset, formatsMap, titleStr, 880, 540, null));
        } else {
            L.debug("AdabasVsPrograms results:");
            String currentFile = null;
            String currentDB = null;
            String current = null;
            String currentPrg = null;
            int count = 0;
            int i = 0;
            while (i < results.length) {
                Integer countValue;
                HashMap<String, Integer> prgMap;
                String adabFile = results[i][0];
                String dbName = results[i][1];
                String program = results[i][2];
                String stmtType = results[i][3];
                Integer stmtCount = new Integer(Integer.parseInt(results[i][4]));
                String prgPath = results[i][5];
                String listableName = prgPath != null ? program.concat(" (").concat(prgPath).concat(")") : program;
                String fName = AdabasUtils.getListableName((String)adabFile, (String)dbName);
                if (currentFile == null) {
                    currentFile = adabFile;
                    currentDB = dbName;
                    currentPrg = listableName;
                    current = fName;
                    ++count;
                } else if (!currentFile.equalsIgnoreCase(adabFile) || !currentDB.equalsIgnoreCase(dbName)) {
                    this.used.put(current, new Integer(count));
                    currentFile = adabFile;
                    currentDB = dbName;
                    currentPrg = listableName;
                    current = fName;
                    count = 1;
                } else if (!currentPrg.equalsIgnoreCase(listableName)) {
                    currentPrg = listableName;
                    ++count;
                }
                if (i == results.length - 1) {
                    this.used.put(current, new Integer(count));
                }
                L.debug("adabas: {}", (Object)fName);
                L.debug("program: {}", (Object)listableName);
                L.debug("stmt type: {}", (Object)stmtType);
                L.debug("count: {}", (Object)stmtCount);
                L.debug("\n");
                Obj4Report obj = new Obj4Report();
                obj.setProgramName(fName);
                obj.setFileName(listableName);
                obj.setStmtType(stmtType);
                obj.setCount(stmtCount);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{adabFile, listableName, stmtType, stmtCount.toString()});
                }
                if ((prgMap = (HashMap<String, Integer>)this.allResMap.get(fName)) == null) {
                    prgMap = new HashMap<String, Integer>();
                    this.allResMap.put(fName, prgMap);
                }
                countValue = (countValue = (Integer)prgMap.get(stmtType)) == null ? stmtCount : new Integer(countValue + stmtCount);
                prgMap.put(stmtType, countValue);
                this.resultList.add(obj);
                if (!this.stmtCountMap.containsKey(stmtType)) {
                    this.stmtCountMap.put(stmtType, stmtCount);
                } else {
                    int temp = this.stmtCountMap.get(stmtType);
                    int currentCount = stmtCount;
                    this.stmtCountMap.put(stmtType, new Integer(temp + currentCount));
                }
                ++i;
            }
        }
        if (this.stmtCountMap.size() > 0) {
            dataset = new DefaultCategoryDataset();
            for (String stmtType : this.stmtCountMap.keySet()) {
                dataset.addValue((Number)this.stmtCountMap.get(stmtType), (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
            }
            String title = Messages.getString(ReportBuilder.class, "pie1.title");
            xAxis = Messages.getString(ReportBuilder.class, "firstbar.category.axis");
            yAxis = Messages.getString(ReportBuilder.class, "firstbar.value.axis");
            this.parameters.put("usagePie", this.createFirstStackedBar((DefaultCategoryDataset)dataset, title, xAxis, yAxis, 1000, 760));
        }
        if (this.used.size() > 0) {
            String stackTitle = Messages.getString(ReportBuilder.class, "pie2.title");
            DefaultCategoryDataset ds = this.buildDataSet(this.used);
            String subtitle = null;
            if (this.used.keySet().size() >= 20) {
                Object[] msgParams = new String[]{String.valueOf(20)};
                stackTitle = stackTitle.concat(" ").concat(Messages.getString(ReportBuilder.class, "bar.title", msgParams));
                if (this.countsSame != 0) {
                    msgParams = new String[]{String.valueOf(this.countsSame)};
                    stackTitle = stackTitle.concat("*");
                    subtitle = Messages.getString(ReportBuilder.class, "bar.subtitle", msgParams);
                }
            }
            xAxis = Messages.getString(ReportBuilder.class, "bar.category.axis");
            yAxis = Messages.getString(ReportBuilder.class, "bar.value.axis");
            this.parameters.put("progrVSFilesPie", this.createSecondStackedBar(ds, stackTitle, xAxis, yAxis, 880, 540, null, subtitle));
        }
        monitor.setWorkRemaining(0);
        return results;
    }

    protected String prepareAppendixResrsList(Set prgList) {
        String ret = "";
        ret = ret.concat(prgList.toString());
        Object selectedApps = this.report.getProperty("filtered by app");
        boolean projectIsUCMDB = (Boolean)this.inputs.get("project_isUCMDB");
        if (selectedApps != null && ((Boolean)selectedApps).booleanValue() && projectIsUCMDB) {
            Set apps = null;
            Iterator iterator = prgList.iterator();
            while (iterator.hasNext() && apps == null) {
                ProgramInputNoGUI prg = (ProgramInputNoGUI)iterator.next();
                if (prg.getApplications() == null || prg.getApplications().isEmpty()) continue;
                apps = prg.getApplications();
            }
            if (apps != null && !apps.isEmpty()) {
                ret = ret.concat("\n");
                ret = ret.concat(Messages.getString(ReportBuilder.class, "appendix.applications.part")).concat(apps.toString());
                this.setApplicationName(apps);
            }
        }
        return ret;
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.header.adabas"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.statement"), Messages.getString(((Object)((Object)this)).getClass(), "csv.header.occurrences")});
        }
    }

    @Override
    public void cleanMemory() {
        if (this.allResMap != null) {
            this.allResMap.clear();
            this.allResMap = null;
        }
        if (this.used != null) {
            this.used.clear();
            this.used = null;
        }
        if (this.stmtCountMap != null) {
            this.stmtCountMap.clear();
            this.stmtCountMap = null;
        }
        super.cleanMemory();
    }
}

