/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu.adabasVsPrograms;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.AdabasFileInput;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.wizard.GenericSelectInputPage4Report;
import com.ez.report.application.ezreport.reports.wu.WUAbstractAnalysis;
import com.ez.report.application.ezreport.reports.wu.adabasVsPrograms.AdabasVsProgramsJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.InputsCollector;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceAdabasIDSg;
import com.ez.workspace.model.segments.EZSourceResourceIDSg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdabasVsProgramsAnalysis
extends WUAbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AdabasVsProgramsAnalysis.class);

    public AdabasVsProgramsAnalysis() {
        this(null);
    }

    public AdabasVsProgramsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    public PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(AdabasVsProgramsAnalysis.class, "wizzard.title");
        wizard.setWindowTitle(wizardName);
        GenericSelectInputPage4Report selectProgramsPage = new GenericSelectInputPage4Report("programs page");
        selectProgramsPage.setLeftGroupLabel(Messages.getString(AdabasVsProgramsAnalysis.class, "available.objectType.adabas"));
        selectProgramsPage.setRightGroupLabel(Messages.getString(AdabasVsProgramsAnalysis.class, "selected.objectType.adabas"));
        String sqlQuery = "select * FROM cacheEZViewer_Adabas_View";
        AdabasFileCollector pc = new AdabasFileCollector();
        pc.setResourcesQuery(sqlQuery);
        selectProgramsPage.setResourcesCollector((ResourcesCollector)pc);
        wizard.addPage(selectProgramsPage);
        return wizard;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_ADABAS_VS_PROGRAMS_ANALYSIS;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(id, AdabasVsProgramsJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    @Override
    protected void completeSelectedPrograms(PrepareReportWizard wizard) {
        List old = wizard.getList("selected resources");
        if (old != null) {
            List sel = BaseResourceInput4GUI.extractNonGUIObjects((Collection)old);
            wizard.set("selected resources", (Object)sel);
            if (sel != null) {
                HashSet<String> inputNames = new HashSet<String>();
                for (AdabasFileInput ji : sel) {
                    inputNames.add(ji.getListableName());
                }
                this.addContextValue("inputs name string", inputNames);
            }
        }
    }

    @Override
    protected void prepareInputFromResourceSg(List<BaseMainframeResourceInput> sel, Set<String> inputNames, EZSourceResourceIDSg resourceSg) {
        String name = resourceSg.getResourceName();
        if (resourceSg.isOfType(EZSourceAdabasIDSg.class)) {
            int dbID = ((EZSourceAdabasIDSg)resourceSg).getNumber();
            AdabasFileInput inpt = new AdabasFileInput(Integer.valueOf(dbID), ((EZSourceAdabasIDSg)resourceSg).getFileName(), ((EZSourceAdabasIDSg)resourceSg).getDbName());
            sel.add((BaseMainframeResourceInput)inpt);
        } else {
            L.warn("wrong input type for AdabasVsPrograms report: {}", resourceSg.getClass());
            sel.add((BaseMainframeResourceInput)new ProgramInputNoGUI(name));
        }
        inputNames.add(name);
    }

    class AdabasFileCollector
    extends InputsCollector {
        AdabasFileCollector() {
        }

        public List<BaseResourceInput4GUI> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
            ArrayList<BaseResourceInput4GUI> resources;
            block5: {
                resources = new ArrayList<BaseResourceInput4GUI>();
                boolean preparedCache = this.prepareCacheIfNecessary("EZViewer_Adabas_View", conn);
                if (preparedCache) break block5;
                L.warn("Cache not prepared. Retry later.");
                return null;
            }
            try {
                String[][] results = conn.executeSQL(this.resourcesQuery);
                if (results != null && results.length > 0) {
                    String[][] stringArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] result = stringArray[n2];
                        String adabFile = result[1];
                        String dbName = result[2];
                        Integer dbID = new Integer(Integer.parseInt(result[0]));
                        AdabasFileInput dbiRes = new AdabasFileInput(dbID, adabFile, dbName);
                        resources.add((BaseResourceInput4GUI)new BaseMainframeResource4GUI((BaseResourceInput)dbiRes));
                        ++n2;
                    }
                }
            }
            catch (EZSourceConnectionException e) {
                L.error("connection error", (Throwable)e);
            }
            return resources;
        }

        public boolean prepareCacheIfNecessary(String viewName, EZSourceConnection conn) {
            boolean preparedCache;
            boolean bl = preparedCache = viewName == null;
            if (!preparedCache) {
                preparedCache = Utils.prepareCache((EZSourceConnection)conn, (String)viewName, (IProgressMonitor)new NullProgressMonitor());
            }
            return preparedCache;
        }
    }
}

