/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu;

import com.ez.common.model.BaseResourceInput;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ApplicationInputNoGUI;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.EZPiePlot;
import com.ez.report.application.ezreport.reports.ProgramComparator;
import com.ez.report.application.ezreport.reports.wu.EZCategorySeriesLabelGenerator;
import com.ez.report.application.ezreport.reports.wu.EZLineBorder;
import com.ez.report.application.ezreport.reports.wu.ExtendedStackedBarRenderer;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public abstract class WUReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected Font labelFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)10, (boolean)false);
    protected Font titleFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)14, (boolean)true);
    protected static Font legendFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)9, (boolean)false);
    protected static final int MAX_BAR_COUNT = 20;
    protected JFreeChart verticalChart;
    protected JFreeChart pieChart;
    protected static Color GREEN_COLOR = new Color(166, 203, 149);
    protected Color YELLOW_COLOR = new Color(255, 204, 102);
    protected Color ORANGE_COLOR = new Color(255, 153, 0);
    protected Color BLUE_COLOR = new Color(107, 149, 173);
    protected Color PIE_PINK_COLOR = new Color(238, 149, 123);
    protected Color PIE_YELLOW_COLOR = new Color(248, 219, 120);
    protected int countsSame = 0;
    protected List resultList = new ArrayList();
    protected boolean inputWasResource = true;

    public Map<String, Object> getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(WUReportBuilder.class, "computeParameters.process.name"));
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        this.parameters.put("appendixFirstLineValue", String.valueOf(this.getSelected().size()));
        this.putSubreportStream(this.getSubreportTemplate1(), "SubreportStream1");
        monitor.worked(100);
        return this.parameters;
    }

    protected String getSubreportTemplate1() {
        return "reports/usingFilesPies.jasper";
    }

    protected abstract void putExternalizedParameters(Map<String, Object> var1);

    public void cleanMemory() {
        this.labelFont = null;
        this.titleFont = null;
        this.pieChart = null;
        this.verticalChart = null;
        this.ORANGE_COLOR = null;
        this.YELLOW_COLOR = null;
        this.BLUE_COLOR = null;
        this.PIE_PINK_COLOR = null;
        this.PIE_YELLOW_COLOR = null;
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        super.cleanMemory();
    }

    protected DefaultCategoryDataset buildDataSet(Map dsMap) {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        ArrayList prgrList = new ArrayList(dsMap.keySet());
        ProgramComparator pComparator = new ProgramComparator();
        pComparator.setMapWithCounts(dsMap);
        Collections.sort(prgrList, pComparator);
        int i = 0;
        int prag = 0;
        this.countsSame = 0;
        boolean endOfBars = false;
        for (String prg : prgrList) {
            Integer nr = (Integer)dsMap.get(prg);
            if (i < 20) {
                ds.addValue((Number)nr, (Comparable)((Object)"program"), (Comparable)((Object)prg));
                prag = nr;
            } else if (!endOfBars) {
                if (prag == nr) {
                    ++this.countsSame;
                } else {
                    endOfBars = true;
                }
            }
            ++i;
        }
        return ds;
    }

    protected Image createSecondStackedBar(DefaultCategoryDataset dataset, String titleStr, String xAxis, String yAxis, int imgWidth, int imgHeight, Color seriePaint, String subtitleString) {
        TextTitle title = new TextTitle(titleStr, this.titleFont);
        this.verticalChart = ChartFactory.createBarChart(null, (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.verticalChart.setTitle(title);
        this.verticalChart.setBackgroundPaint((Paint)Color.white);
        this.verticalChart.setBorderVisible(false);
        this.verticalChart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        CategoryPlot plot = this.verticalChart.getCategoryPlot();
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(4.0, 1.0, 1.0, 4.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinesVisible(true);
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.DARK_GRAY);
        axis.setLabelFont(this.labelFont);
        axis.setTickLabelFont(this.labelFont);
        axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        axis.setLowerMargin(0.03);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setLabelFont(this.labelFont);
        rangeAxis.setTickLabelFont(this.labelFont);
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setMaximumBarWidth(0.1);
        renderer.setShadowVisible(false);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setDrawBarOutline(true);
        renderer.setBaseItemLabelFont(this.labelFont);
        if (seriePaint == null) {
            renderer.setSeriesPaint(0, (Paint)this.ORANGE_COLOR);
        } else {
            renderer.setSeriesPaint(0, (Paint)seriePaint);
        }
        if (this.countsSame != 0 && subtitleString != null) {
            this.parameters.put("footerNote", subtitleString);
        }
        return this.verticalChart.createBufferedImage(imgWidth, imgHeight, (double)(imgWidth / 2), (double)(imgHeight / 2), null);
    }

    protected Image createFirstStackedBar(DefaultCategoryDataset dataset, String chartTitle, String xAxis, String yAxis, int imgWidth, int imgHeight) {
        TextTitle title = new TextTitle(chartTitle, this.titleFont);
        this.verticalChart = ChartFactory.createBarChart(null, (String)xAxis, (String)yAxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.verticalChart.setTitle(title);
        this.verticalChart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = this.verticalChart.getCategoryPlot();
        this.verticalChart.setBorderVisible(false);
        this.verticalChart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        LegendTitle leg = this.verticalChart.getLegend();
        leg.setFrame((BlockFrame)new EZLineBorder());
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.DARK_GRAY);
        axis.setLabelFont(this.labelFont);
        axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        axis.setCategoryMargin(0.1);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperMargin(0.15);
        rangeAxis.setLabelFont(this.labelFont);
        ExtendedStackedBarRenderer extendedstackedbarrenderer = new ExtendedStackedBarRenderer(this.labelFont);
        extendedstackedbarrenderer.setBaseItemLabelsVisible(true);
        extendedstackedbarrenderer.setLegendItemLabelGenerator(new EZCategorySeriesLabelGenerator("{2}({1})"));
        extendedstackedbarrenderer.setMaximumBarWidth(0.1);
        extendedstackedbarrenderer.setBaseItemLabelFont(this.labelFont);
        plot.setRenderer((CategoryItemRenderer)extendedstackedbarrenderer);
        return this.verticalChart.createBufferedImage(imgWidth, imgHeight, (double)(imgWidth / 2), (double)(imgHeight / 2), null);
    }

    protected Image createPieChartImage(DefaultPieDataset dataset, Map formatsMap, String titleStr, int imgWidth, int imgHeight, List colors) {
        EZPiePlot plot = new EZPiePlot((PieDataset)dataset);
        plot.setFormatsMap(formatsMap);
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        this.pieChart = new JFreeChart(titleStr, this.titleFont, (Plot)plot, false);
        this.pieChart.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.pieChart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = new LegendTitle((LegendItemSource)plot);
        legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
        legend.setFrame((BlockFrame)new BlockBorder());
        legend.setBackgroundPaint((Paint)Color.white);
        legend.setPosition(RectangleEdge.BOTTOM);
        this.pieChart.addSubtitle((Title)legend);
        LegendTitle legendTitle = this.pieChart.getLegend();
        legendTitle.setItemFont(this.labelFont);
        plot.setLabelFont(this.labelFont);
        plot.setShadowPaint((Paint)Color.white);
        plot.setLabelShadowPaint((Paint)Color.white);
        StandardPieSectionLabelGenerator labelGenerator = new StandardPieSectionLabelGenerator("{0} {2}");
        plot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        if (colors != null && !colors.isEmpty()) {
            int i = 0;
            while (i < colors.size()) {
                Object color = colors.get(i);
                if (color != null) {
                    plot.setSectionPaint(i, (Paint)((Color)color));
                }
                ++i;
            }
        } else {
            plot.setSectionPaint(0, (Paint)GREEN_COLOR);
            plot.setSectionPaint(1, (Paint)this.YELLOW_COLOR.brighter());
        }
        return this.pieChart.createBufferedImage(imgWidth, imgHeight, (double)(imgWidth / 2), (double)(imgHeight / 2), null);
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    protected String getReportTemplatePath() {
        String template = null;
        Boolean property = (Boolean)this.getReportModel().getProperty("hide images");
        template = property != null && property != false ? "reports/usedFilesNoImages.jasper" : "reports/usedFiles.jasper";
        return template;
    }

    protected String getUniqueKeyofLine(String[] results) {
        return results[results.length - 1];
    }

    protected CSVWriter doCSVInitOperations() {
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        return csvWriter;
    }

    protected void writeCSVHeader(CSVWriter csv) {
    }

    protected void collectData4AppendixonMultiApp(Set<? extends BaseResourceInput> inptList) {
        if (this.inputWasResource) {
            Collection appNames;
            super.collectData4AppendixWhenNoApp(inptList, "resources");
            Object selectedApps = this.report.getProperty("filtered by app");
            if (selectedApps != null && (appNames = (Collection)this.inputs.get("selected applications names")) != null && !appNames.isEmpty()) {
                ArrayList tmp = new ArrayList(appNames);
                Collections.sort(tmp);
                ApplicationInputNoGUI appGroup = new ApplicationInputNoGUI("", "");
                this.apps.put("applications", appGroup);
                for (String app : tmp) {
                    app = ReportsUtils.stripNonValidXMLCharacters((String)app, (boolean)true);
                    appGroup.addProgram(app);
                }
            }
        } else {
            super.collectData4AppendixonMultiApp(inptList);
        }
    }

    protected String detectListableName(Set prgList, Integer prgID, String prgName) {
        String listableNames = prgName;
        for (BaseResourceInput prg : prgList) {
            Integer resID = prg.getResourceID();
            if (resID.intValue() == prgID.intValue()) {
                listableNames = prg.getListableName();
                break;
            }
            if (prg.getTypeCode() != 8 || resID.intValue() == prgID.intValue() || ((ProgramInputNoGUI)prg).getChildrenIDs() == null || !((ProgramInputNoGUI)prg).getChildrenIDs().contains((int)prgID)) continue;
            String ancestorName = prg.getListableName();
            listableNames = ancestorName.concat(": ").concat(prgName);
            break;
        }
        return listableNames;
    }
}

