/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu;

import com.ez.report.application.ezreport.reports.wu.EZLineBorder;
import com.ez.report.application.ezreport.reports.wu.ExtendedStackedBarRenderer;
import com.ez.report.application.ezreport.reports.wu.WUReportBuilder;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WUDataSource
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(WUDataSource.class);
    protected Font titleFont = null;
    protected boolean firstInGroup = true;
    protected boolean lastInGroup = true;
    protected boolean lastInReport = true;
    protected boolean hideImages = false;

    protected DefaultCategoryDataset getCountBarDataset(Map dsMap, String fieldName) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Map stmtMap = (Map)dsMap.get(fieldName);
        ArrayList stmtTypes = new ArrayList(stmtMap.keySet());
        Collections.sort(stmtTypes, String.CASE_INSENSITIVE_ORDER);
        for (String stmtType : stmtTypes) {
            Integer countsInteger = (Integer)stmtMap.get(stmtType);
            dataset.addValue((Number)countsInteger, (Comparable)((Object)stmtType), (Comparable)((Object)stmtType));
        }
        return dataset;
    }

    protected Image createStackedBar(DefaultCategoryDataset ds, String title, String xAxis, String yAxis, int width, int height) {
        if (this.titleFont == null) {
            this.titleFont = ReportsUtils.getFont((Locale)Locale.getDefault(), (int)12, (boolean)false);
        }
        return WUDataSource.createStackedBar(ds, title, this.titleFont, xAxis, yAxis, width, height, null);
    }

    public static Image createStackedBar(DefaultCategoryDataset ds, String title, Font titleFont, String xAxis, String yAxis, int width, int height, Color legendItemPaint) {
        Locale loc = Locale.getDefault();
        JFreeChart verticalChart = ChartFactory.createStackedBarChart(null, (String)xAxis, (String)yAxis, (CategoryDataset)ds, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        verticalChart.setTitle(new TextTitle(title, titleFont));
        verticalChart.setBackgroundPaint((Paint)Color.white);
        verticalChart.setBorderVisible(false);
        verticalChart.setPadding(new RectangleInsets(5.0, 0.0, 0.0, 8.0));
        CategoryPlot plot = verticalChart.getCategoryPlot();
        plot.setOutlinePaint((Paint)Color.white);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        LegendTitle leg = verticalChart.getLegend();
        leg.setFrame((BlockFrame)new EZLineBorder());
        leg.setItemFont(WUReportBuilder.legendFont);
        if (legendItemPaint != null) {
            leg.setItemPaint((Paint)legendItemPaint);
        }
        Font labelFont = ReportsUtils.getFont((Locale)loc, (int)10, (boolean)false);
        CategoryAxis axis = plot.getDomainAxis();
        axis.setAxisLinePaint((Paint)Color.black);
        axis.setLabelFont(labelFont);
        axis.setUpperMargin(0.1);
        axis.setTickLabelsVisible(false);
        axis.setVisible(true);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperMargin(0.15);
        rangeAxis.setAxisLinePaint((Paint)Color.black);
        rangeAxis.setLabelFont(labelFont);
        ExtendedStackedBarRenderer extendedstackedbarrenderer = new ExtendedStackedBarRenderer(ReportsUtils.getFont((Locale)loc, (int)10, (boolean)true));
        extendedstackedbarrenderer.setMaximumBarWidth(0.1);
        extendedstackedbarrenderer.setSeriesPaint(0, WUReportBuilder.GREEN_COLOR);
        extendedstackedbarrenderer.setBaseItemLabelFont(labelFont);
        plot.setRenderer((CategoryItemRenderer)extendedstackedbarrenderer);
        return verticalChart.createBufferedImage(width, height, (double)(width / 2), (double)(height / 2), null);
    }
}

