/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class ExtendedStackedBarRenderer
extends StackedBarRenderer {
    private static final long serialVersionUID = 4344228231942612789L;
    private boolean showPositiveTotal = true;
    private boolean showNegativeTotal = true;
    private Font totalLabelFont = new Font("SansSerif", 1, 12);
    private NumberFormat totalFormatter = NumberFormat.getInstance();

    public ExtendedStackedBarRenderer() {
        this.setShadowVisible(false);
        this.setBarPainter((BarPainter)new StandardBarPainter());
        this.setDrawBarOutline(true);
    }

    public ExtendedStackedBarRenderer(Font totalFont) {
        this();
        this.totalLabelFont = totalFont;
    }

    public NumberFormat getTotalFormatter() {
        return this.totalFormatter;
    }

    public void setTotalFormatter(NumberFormat numberformat) {
        if (numberformat == null) {
            throw new IllegalArgumentException("Null format not permitted.");
        }
        this.totalFormatter = numberformat;
    }

    public void drawItem(Graphics2D graphics2d, CategoryItemRendererState categoryitemrendererstate, Rectangle2D rectangle2d, CategoryPlot categoryplot, CategoryAxis categoryaxis, ValueAxis valueaxis, CategoryDataset categorydataset, int i, int j, int k) {
        CategoryItemLabelGenerator categoryitemlabelgenerator;
        double d6;
        double d4;
        Number number = categorydataset.getValue(i, j);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        PlotOrientation plotorientation = categoryplot.getOrientation();
        double d1 = categoryaxis.getCategoryMiddle(j, this.getColumnCount(), rectangle2d, categoryplot.getDomainAxisEdge()) - categoryitemrendererstate.getBarWidth() / 2.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int l = 0;
        while (l < i) {
            Number number1 = categorydataset.getValue(l, j);
            if (number1 != null) {
                double d5 = number1.doubleValue();
                if (d5 > 0.0) {
                    d2 += d5;
                } else {
                    d3 += d5;
                }
            }
            ++l;
        }
        RectangleEdge rectangleedge = categoryplot.getRangeAxisEdge();
        if (d > 0.0) {
            d4 = valueaxis.valueToJava2D(d2, rectangle2d, rectangleedge);
            d6 = valueaxis.valueToJava2D(d2 + d, rectangle2d, rectangleedge);
        } else {
            d4 = valueaxis.valueToJava2D(d3, rectangle2d, rectangleedge);
            d6 = valueaxis.valueToJava2D(d3 + d, rectangle2d, rectangleedge);
        }
        double d7 = Math.min(d4, d6);
        double d8 = Math.max(Math.abs(d6 - d4), this.getMinimumBarLength());
        Rectangle2D.Double double1 = null;
        double1 = plotorientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d7, d1, d8, categoryitemrendererstate.getBarWidth()) : new Rectangle2D.Double(d1, d7, categoryitemrendererstate.getBarWidth(), d8);
        Paint paint = this.getItemPaint(i, j);
        graphics2d.setPaint(paint);
        graphics2d.fill(double1);
        if (this.isDrawBarOutline() && categoryitemrendererstate.getBarWidth() > 3.0) {
            graphics2d.setStroke(this.getItemStroke(i, j));
            graphics2d.setPaint(this.getItemOutlinePaint(i, j));
            graphics2d.draw(double1);
        }
        if ((categoryitemlabelgenerator = this.getItemLabelGenerator(i, j)) != null && this.isItemLabelVisible(i, j)) {
            this.drawItemLabel(graphics2d, categorydataset, i, j, categoryplot, categoryitemlabelgenerator, double1, d < 0.0);
        }
        if (d > 0.0) {
            if (this.showPositiveTotal && this.isLastPositiveItem(categorydataset, i, j)) {
                graphics2d.setPaint(Color.black);
                graphics2d.setFont(this.totalLabelFont);
                double d9 = this.calculateSumOfPositiveValuesForCategory(categorydataset, j);
                TextUtilities.drawRotatedString((String)this.totalFormatter.format(d9), (Graphics2D)graphics2d, (float)((float)double1.getCenterX()), (float)((float)(double1.getMinY() - 4.0)), (TextAnchor)TextAnchor.BOTTOM_CENTER, (double)0.0, (TextAnchor)TextAnchor.BOTTOM_CENTER);
            }
        } else {
            EntityCollection entitycollection;
            if (this.showNegativeTotal && this.isLastNegativeItem(categorydataset, i, j)) {
                graphics2d.setPaint(Color.black);
                graphics2d.setFont(this.totalLabelFont);
                double d10 = this.calculateSumOfNegativeValuesForCategory(categorydataset, j);
                TextUtilities.drawRotatedString((String)String.valueOf(d10), (Graphics2D)graphics2d, (float)((float)double1.getCenterX()), (float)((float)(double1.getMaxY() + 4.0)), (TextAnchor)TextAnchor.TOP_CENTER, (double)0.0, (TextAnchor)TextAnchor.TOP_CENTER);
            }
            if (categoryitemrendererstate.getInfo() != null && (entitycollection = categoryitemrendererstate.getEntityCollection()) != null) {
                String s = null;
                CategoryToolTipGenerator categorytooltipgenerator = this.getToolTipGenerator(i, j);
                if (categorytooltipgenerator != null) {
                    s = categorytooltipgenerator.generateToolTip(categorydataset, i, j);
                }
                String s1 = null;
                if (this.getItemURLGenerator(i, j) != null) {
                    s1 = this.getItemURLGenerator(i, j).generateURL(categorydataset, i, j);
                }
                CategoryItemEntity categoryitementity = new CategoryItemEntity((Shape)double1, s, s1, categorydataset, categorydataset.getRowKey(i), categorydataset.getColumnKey(j));
                entitycollection.add((ChartEntity)categoryitementity);
            }
        }
    }

    private boolean isLastPositiveItem(CategoryDataset categorydataset, int i, int j) {
        boolean flag = true;
        Number number = categorydataset.getValue(i, j);
        if (number == null) {
            return false;
        }
        int k = i + 1;
        while (k < categorydataset.getRowCount()) {
            Number number1 = categorydataset.getValue(k, j);
            if (number1 != null) {
                flag = flag && number1.doubleValue() <= 0.0;
            }
            ++k;
        }
        return flag;
    }

    private boolean isLastNegativeItem(CategoryDataset categorydataset, int i, int j) {
        boolean flag = true;
        Number number = categorydataset.getValue(i, j);
        if (number == null) {
            return false;
        }
        int k = i + 1;
        while (k < categorydataset.getRowCount()) {
            Number number1 = categorydataset.getValue(k, j);
            if (number1 != null) {
                flag = flag && number1.doubleValue() >= 0.0;
            }
            ++k;
        }
        return flag;
    }

    private double calculateSumOfPositiveValuesForCategory(CategoryDataset categorydataset, int i) {
        double d = 0.0;
        int j = 0;
        while (j < categorydataset.getRowCount()) {
            double d1;
            Number number = categorydataset.getValue(j, i);
            if (number != null && (d1 = number.doubleValue()) > 0.0) {
                d += d1;
            }
            ++j;
        }
        return d;
    }

    private double calculateSumOfNegativeValuesForCategory(CategoryDataset categorydataset, int i) {
        double d = 0.0;
        int j = 0;
        while (j < categorydataset.getRowCount()) {
            double d1;
            Number number = categorydataset.getValue(j, i);
            if (number != null && (d1 = number.doubleValue()) < 0.0) {
                d += d1;
            }
            ++j;
        }
        return d;
    }

    public void drawBackground(Graphics2D g2, CategoryPlot plot, Rectangle2D dataArea) {
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.drawBackground(g2, dataArea);
    }
}

