/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.wu;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.labels.StandardCategorySeriesLabelGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.PublicCloneable;

public class EZCategorySeriesLabelGenerator
implements CategorySeriesLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 4630760091523940820L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;
    private NumberFormat numberFormat;
    private NumberFormat percentFormat;

    public EZCategorySeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public EZCategorySeriesLabelGenerator(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.formatPattern = format;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.percentFormat = NumberFormat.getPercentInstance();
    }

    public String generateLabel(CategoryDataset dataset, int series) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String label = MessageFormat.format(this.formatPattern, this.createItemArray(dataset, series));
        return label;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int series) {
        double v;
        Object[] result = new Object[4];
        double total = EZCategorySeriesLabelGenerator.calculateDatasetTotal(dataset);
        result[0] = dataset.getRowKey(series).toString();
        Number value = dataset.getValue(dataset.getRowKey(series), dataset.getColumnKey(series));
        result[1] = value != null ? this.numberFormat.format(value) : "null";
        double percent = 0.0;
        if (value != null && (v = value.doubleValue()) > 0.0) {
            percent = v / total;
        }
        result[2] = this.percentFormat.format(percent);
        result[3] = this.numberFormat.format(total);
        return result;
    }

    public static double calculateDatasetTotal(CategoryDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        List keys = dataset.getRowKeys();
        double totalValue = 0.0;
        for (Comparable current : keys) {
            if (current == null) continue;
            Number value = dataset.getValue(current, current);
            double v = 0.0;
            if (value != null) {
                v = value.doubleValue();
            }
            if (!(v > 0.0)) continue;
            totalValue += v;
        }
        return totalValue;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategorySeriesLabelGenerator)) {
            return false;
        }
        return super.equals(obj);
    }
}

