/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.weight;

import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.viewer.execution.ReportExecutor;
import com.ez.report.generation.common.ReportsRepository;
import com.ez.report.generation.common.model.ReportInformation;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;

public class HeuristicExecutor
extends ReportExecutor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    String folderName = "";

    public HeuristicExecutor(Map<String, Object> settings) {
        super(settings);
    }

    public HeuristicExecutor(HashMap<String, Object> map, String reportName) {
        this(map);
        this.folderName = reportName;
    }

    @Override
    protected void processInputs(IProgressMonitor pmonitor, Map<String, Object> inputs) {
        Properties prop = this.readDefaultProperties(inputs);
        inputs.put("settings", prop);
        super.processInputs(pmonitor, inputs);
    }

    private Properties readDefaultProperties(Map<String, Object> inputs) {
        String project = (String)inputs.get("project_name");
        if (this.folderName == null || this.folderName.isEmpty()) {
            ReportInformation repInfo = ReportsRepository.getReportInformation((int)5);
            this.folderName = repInfo != null ? repInfo.getReportName() : "";
        }
        String prjPath = Utils.getProjectPathName((String)project);
        String path = prjPath.concat(File.separator).concat(this.folderName).concat(File.separator).concat("default.properties");
        File defaultFile = new File(path);
        Properties defProp = Utils.readSettings((File)defaultFile);
        return defProp;
    }
}

