/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.threshold;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.threshold.ThresholdAbstractSettingsDialog;
import com.ez.report.generation.common.ui.utils.Utils;
import java.util.Properties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdSelectionUI {
    private static final Logger L = LoggerFactory.getLogger(ThresholdSelectionUI.class);
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String FIRST_THRESHOLD = "simpleThresholdPreference";
    private static final String SECOND_THRESHOLD = "mediumThresholdPreference";
    private static final String FIRST_THRESHOLD_COLOR = "simpleColorPreference";
    private static final String SECOND_THRESHOLD_COLOR = "mediumColorPreference";
    private static final String THIRD_THRESHOLD_COLOR = "complexColorPreference";
    private static final int DEFAULT_TEXT_LIMIT = 6;
    private ThresholdAbstractSettingsDialog page;
    private Composite panel;
    private Text firstLevel;
    private Button firstColor;
    private Text secondLevel;
    private Button secondColor;
    private Text txtComplex;
    private Button thirdColor;
    private Button btnDefaults;
    private ColorSelector simpleColorSelector;
    private ColorSelector moderateColorSelector;
    private ColorSelector complexColorSelector;
    private static String errorText = "";
    private static final String ERROR_GREATER_0 = Messages.getString(ThresholdSelectionUI.class, "err.message.greater0");
    private static final String ERROR_INT_VALUE = Messages.getString(ThresholdSelectionUI.class, "err.message.intValue");
    private String ERROR_SIMPLE_SMALL_MEDIUM = null;
    private String ERROR_MEDIUM_GREATER_SIMPLE = null;
    private boolean readOnly = false;
    private boolean simpleAcceptNegativeValues = false;
    private boolean mediumAcceptNegativeValues = false;

    public ThresholdSelectionUI(Composite parent, ThresholdAbstractSettingsDialog page) {
        this.page = page;
        this.panel = new Composite(parent, parent.getStyle());
        GridLayout gl = new GridLayout();
        this.panel.setLayout((Layout)gl);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.panel.setLayoutData((Object)data);
        Text description = new Text(this.panel, 8);
        description.setText(page.getThresholdTypeString());
        data = new GridData();
        description.setLayoutData((Object)data);
        this.createComplexityFields(this.panel);
        this.createLocalButtons(this.panel);
        Object[] param = new String[]{page.getFirstThresholdTypeString().toLowerCase()};
        this.ERROR_MEDIUM_GREATER_SIMPLE = Messages.getString(ThresholdSelectionUI.class, "err.message.meddiumGreaterSimple", param);
        this.ERROR_SIMPLE_SMALL_MEDIUM = Messages.getString(ThresholdSelectionUI.class, "err.message.simpleSmallThanMedium", param);
    }

    private void createComplexityFields(Composite parent) {
        Composite fieldsPanel = new Composite(parent, parent.getStyle());
        GridLayout gl = new GridLayout(3, false);
        fieldsPanel.setLayout((Layout)gl);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        fieldsPanel.setLayoutData((Object)data);
        String txtTooltip = Messages.getString(ThresholdSelectionUI.class, "threshold.tooltip");
        String colorTooltip = Messages.getString(ThresholdSelectionUI.class, "color.tooltip");
        Label simpleLevelLbl = new Label(fieldsPanel, 0);
        simpleLevelLbl.setText(this.page.getFirstThresholdTypeString());
        data = new GridData();
        simpleLevelLbl.setLayoutData((Object)data);
        simpleLevelLbl.setToolTipText(txtTooltip);
        this.firstLevel = new Text(fieldsPanel, 2048);
        this.firstLevel.setToolTipText(txtTooltip);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.firstLevel.setLayoutData((Object)data);
        this.firstLevel.setTextLimit(6);
        SimplePragModifyListener simplePragModifyListener = new SimplePragModifyListener();
        this.firstLevel.addModifyListener((ModifyListener)simplePragModifyListener);
        this.firstLevel.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (ThresholdSelectionUI.this.page.getMessage() != null && !ThresholdSelectionUI.this.page.getMessage().isEmpty()) {
                    event.result = ThresholdSelectionUI.this.page.getMessage();
                } else {
                    super.getDescription(event);
                }
                L.trace("firstLevel.getDescription: {}", (Object)event.result);
            }
        });
        this.simpleColorSelector = new ColorSelector(fieldsPanel);
        this.firstColor = this.simpleColorSelector.getButton();
        data = new GridData();
        this.firstColor.setLayoutData((Object)data);
        this.firstColor.setToolTipText(colorTooltip);
        this.firstColor.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ThresholdSelectionUI.this.getColorSelectorButtonName(ThresholdSelectionUI.this.page.getFirstThresholdTypeString());
            }
        });
        final Label mediumLevelLbl = new Label(fieldsPanel, 0);
        mediumLevelLbl.setText(Messages.getString(ThresholdSelectionUI.class, "lblModerate.text"));
        data = new GridData();
        mediumLevelLbl.setLayoutData((Object)data);
        mediumLevelLbl.setToolTipText(txtTooltip);
        this.secondLevel = new Text(fieldsPanel, 2048);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.secondLevel.setLayoutData((Object)data);
        this.secondLevel.setToolTipText(txtTooltip);
        this.secondLevel.setTextLimit(6);
        ModeratePragModifyListener moderatePragModifyListener = new ModeratePragModifyListener();
        this.secondLevel.addModifyListener((ModifyListener)moderatePragModifyListener);
        this.secondLevel.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                if (ThresholdSelectionUI.this.page.getMessage() != null && !ThresholdSelectionUI.this.page.getMessage().isEmpty()) {
                    event.result = ThresholdSelectionUI.this.page.getMessage();
                } else {
                    super.getDescription(event);
                }
                L.trace("secondLevel.getDescription: {}", (Object)event.result);
            }
        });
        this.moderateColorSelector = new ColorSelector(fieldsPanel);
        this.secondColor = this.moderateColorSelector.getButton();
        data = new GridData();
        this.secondColor.setLayoutData((Object)data);
        this.secondColor.setToolTipText(colorTooltip);
        this.secondColor.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ThresholdSelectionUI.this.getColorSelectorButtonName(mediumLevelLbl.getText());
            }
        });
        Label complexLevelLbl = new Label(fieldsPanel, 0);
        complexLevelLbl.setText(this.page.getThirdThresholdTypeString());
        data = new GridData();
        complexLevelLbl.setLayoutData((Object)data);
        complexLevelLbl.setToolTipText(txtTooltip);
        this.txtComplex = new Text(fieldsPanel, 2048);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.txtComplex.setLayoutData((Object)data);
        this.txtComplex.setToolTipText(txtTooltip);
        this.txtComplex.setEditable(false);
        this.complexColorSelector = new ColorSelector(fieldsPanel);
        this.thirdColor = this.complexColorSelector.getButton();
        data = new GridData();
        this.thirdColor.setLayoutData((Object)data);
        this.thirdColor.setToolTipText(colorTooltip);
        this.thirdColor.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ThresholdSelectionUI.this.getColorSelectorButtonName(ThresholdSelectionUI.this.page.getThirdThresholdTypeString());
            }
        });
    }

    public Composite getPanel() {
        return this.panel;
    }

    private void createLocalButtons(Composite myParent) {
        Composite buttonBar = new Composite(myParent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        buttonBar.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 0x1000008;
        data.horizontalSpan = 4;
        data.grabExcessHorizontalSpace = true;
        buttonBar.setLayoutData((Object)data);
        this.btnDefaults = new Button(buttonBar, 8);
        this.btnDefaults.setText(Messages.getString(ThresholdSelectionUI.class, "restore.button.text"));
        Dialog.applyDialogFont((Control)this.btnDefaults);
        data = new GridData(4);
        this.btnDefaults.computeSize(-1, -1, true);
        this.btnDefaults.setLayoutData((Object)data);
        this.btnDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThresholdSelectionUI.this.restoreDefaults();
                ThresholdSelectionUI.this.removeAllErrMess();
            }
        });
    }

    public void addListener(Listener listener) {
        this.firstLevel.addListener(24, listener);
        this.secondLevel.addListener(24, listener);
    }

    public void restoreDefaults() {
        this.firstLevel.setText(this.page.getFirstDefaultThreshold().toString());
        this.secondLevel.setText(this.page.getSecondDefaultThreshold().toString());
        this.simpleColorSelector.setColorValue(StringConverter.asRGB((String)Utils.rgbToString((RGB)this.page.getFirstDefaultColor()), null));
        this.moderateColorSelector.setColorValue(StringConverter.asRGB((String)Utils.rgbToString((RGB)this.page.getSecondDefaultColor()), null));
        this.complexColorSelector.setColorValue(StringConverter.asRGB((String)Utils.rgbToString((RGB)this.page.getThirdDefaultColor()), null));
        this.panel.update();
    }

    public void loadDefaults(boolean loadFromDefault) {
        Properties prop = null;
        prop = loadFromDefault ? this.page.getDefProp() : this.page.getThisProp();
        String value = null;
        String string = value = prop == null ? null : prop.getProperty(FIRST_THRESHOLD);
        if (value == null) {
            value = this.page.getFirstDefaultThreshold().toString();
        }
        this.firstLevel.setText(value);
        String string2 = value = prop == null ? null : prop.getProperty(SECOND_THRESHOLD);
        if (value == null) {
            value = this.page.getSecondDefaultThreshold().toString();
        }
        this.secondLevel.setText(value);
        String string3 = value = prop == null ? null : prop.getProperty(FIRST_THRESHOLD_COLOR);
        if (value == null) {
            value = Utils.rgbToString((RGB)this.page.getFirstDefaultColor());
        }
        this.simpleColorSelector.setColorValue(StringConverter.asRGB((String)value, null));
        String string4 = value = prop == null ? null : prop.getProperty(SECOND_THRESHOLD_COLOR);
        if (value == null) {
            value = Utils.rgbToString((RGB)this.page.getSecondDefaultColor());
        }
        this.moderateColorSelector.setColorValue(StringConverter.asRGB((String)value, null));
        String string5 = value = prop == null ? null : prop.getProperty(THIRD_THRESHOLD_COLOR);
        if (value == null) {
            value = Utils.rgbToString((RGB)this.page.getThirdDefaultColor());
        }
        this.complexColorSelector.setColorValue(StringConverter.asRGB((String)value, null));
        this.panel.update();
    }

    private void removeAllErrMess() {
        this.page.removeErrorMessage(ERROR_GREATER_0);
        this.page.removeErrorMessage(this.ERROR_SIMPLE_SMALL_MEDIUM);
        this.page.removeErrorMessage(this.ERROR_MEDIUM_GREATER_SIMPLE);
        this.page.removeErrorMessage(ERROR_INT_VALUE);
    }

    public Properties getProperties() {
        Properties fromStore = new Properties();
        fromStore.put(FIRST_THRESHOLD, this.firstLevel.getText());
        fromStore.put(SECOND_THRESHOLD, this.secondLevel.getText());
        fromStore.put(FIRST_THRESHOLD_COLOR, Utils.rgbToString((RGB)this.simpleColorSelector.getColorValue()));
        fromStore.put(SECOND_THRESHOLD_COLOR, Utils.rgbToString((RGB)this.moderateColorSelector.getColorValue()));
        fromStore.put(THIRD_THRESHOLD_COLOR, Utils.rgbToString((RGB)this.complexColorSelector.getColorValue()));
        return fromStore;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.btnDefaults.setEnabled(!readOnly);
        this.secondLevel.setEditable(!readOnly);
        this.firstLevel.setEditable(!readOnly);
    }

    public void setSimpleAcceptNegativeValues(boolean simpleAcceptNegativeValues) {
        this.simpleAcceptNegativeValues = simpleAcceptNegativeValues;
    }

    public void setMediumAcceptNegativeValues(boolean mediumAcceptNegativeValues) {
        this.mediumAcceptNegativeValues = mediumAcceptNegativeValues;
    }

    private String getColorSelectorButtonName(String thresholdName) {
        return Messages.getString(ThresholdSelectionUI.class, "colorSelector.button.name", new String[]{thresholdName});
    }

    class ModeratePragModifyListener
    implements ModifyListener {
        private boolean valid = true;

        ModeratePragModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text txt = (Text)e.getSource();
            String newValue = txt.getText();
            try {
                int nrMed = Integer.valueOf(newValue);
                int nrSimple = new Integer(ThresholdSelectionUI.this.firstLevel.getText());
                if (!ThresholdSelectionUI.this.mediumAcceptNegativeValues) {
                    if (nrMed < 0) {
                        errorText = ERROR_GREATER_0;
                        this.valid = false;
                    } else {
                        this.valid = true;
                    }
                } else {
                    this.valid = true;
                }
                if (this.valid) {
                    if (nrMed > nrSimple) {
                        errorText = "";
                        ThresholdSelectionUI.this.removeAllErrMess();
                        this.valid = true;
                    } else {
                        errorText = ThresholdSelectionUI.this.ERROR_MEDIUM_GREATER_SIMPLE;
                        this.valid = false;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorText = ERROR_INT_VALUE;
                this.valid = false;
            }
            if (this.valid) {
                ThresholdSelectionUI.this.txtComplex.setText(">".concat(newValue));
            }
            ThresholdSelectionUI.this.page.setErrorMessage(errorText);
            if (!this.valid) {
                txt.getAccessible().sendEvent(32781, (Object)errorText);
                txt.setSelection(0, txt.getText().length());
            }
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    class SimplePragModifyListener
    implements ModifyListener {
        private boolean valid = true;

        SimplePragModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text txt = (Text)e.getSource();
            String newValue = txt.getText();
            try {
                int nrSimple = Integer.valueOf(newValue);
                int nrMed = new Integer(ThresholdSelectionUI.this.secondLevel.getText());
                if (!ThresholdSelectionUI.this.simpleAcceptNegativeValues) {
                    if (nrSimple <= 0) {
                        errorText = ERROR_GREATER_0;
                        this.valid = false;
                    } else {
                        this.valid = true;
                    }
                } else {
                    this.valid = true;
                }
                if (this.valid) {
                    if (nrSimple < nrMed) {
                        errorText = "";
                        ThresholdSelectionUI.this.removeAllErrMess();
                        ThresholdSelectionUI.this.txtComplex.setText(">" + nrMed);
                        this.valid = true;
                    } else {
                        errorText = ThresholdSelectionUI.this.ERROR_SIMPLE_SMALL_MEDIUM;
                        this.valid = false;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                errorText = ERROR_INT_VALUE;
                this.valid = false;
            }
            ThresholdSelectionUI.this.page.setErrorMessage(errorText);
            if (!this.valid) {
                txt.getAccessible().sendEvent(32781, (Object)errorText);
                txt.setSelection(0, txt.getText().length());
            }
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

