/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.threshold;

import com.ez.ezsource.connection.ProjectInfo;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.threshold.ThresholdSelectionUI;
import com.ez.report.application.properties.ReportSettingsDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThresholdAbstractSettingsDialog
extends ReportSettingsDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ThresholdAbstractSettingsDialog.class);
    public static final String PATH_SEPARATOR = File.separator;
    protected TabFolder tabFolder;
    protected TabItem threshTab;
    protected ThresholdSelectionUI thresholdSelectionUI;
    protected File defaultFile = null;
    protected Properties defProp;
    protected File thisFile;
    protected Properties thisProp;
    protected boolean simpleAcceptNegativeValues = false;
    protected boolean mediumAcceptNegativeValues = false;

    public ThresholdAbstractSettingsDialog(Shell shell, ProjectInfo pInfo) {
        super(shell, pInfo);
    }

    @Override
    protected void createPage(Composite page) {
        this.tabFolder = new TabFolder(page, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        this.tabFolder.setLayoutData((Object)data);
        this.threshTab = new TabItem(this.tabFolder, 0);
        this.threshTab.setText(Messages.getString(ThresholdAbstractSettingsDialog.class, "threshold.tab.title"));
        this.thresholdSelectionUI = new ThresholdSelectionUI((Composite)this.tabFolder, this);
        this.thresholdSelectionUI.setSimpleAcceptNegativeValues(this.simpleAcceptNegativeValues);
        this.thresholdSelectionUI.setMediumAcceptNegativeValues(this.mediumAcceptNegativeValues);
        this.threshTab.setControl((Control)this.thresholdSelectionUI.getPanel());
    }

    @Override
    protected void update(boolean justDefaults) {
        L.debug("update {}", (Object)justDefaults);
        this.defProp = Utils.readSettings((File)this.defaultFile);
        L.debug("after readSettings {}", (Object)this.defaultFile);
        String prjPath = Utils.getProjectPathName((String)this.projectName);
        String path = prjPath.concat(File.separator).concat(this.getAnalysisFolder()).concat(PATH_SEPARATOR).concat(this.fileName);
        if (!path.endsWith(".properties")) {
            path = path.concat(".properties");
        }
        this.thisFile = new File(path);
        L.debug("before readSettings {}", (Object)this.thisFile);
        this.thisProp = Utils.readSettings((File)this.thisFile);
        L.debug("after readSettings {}", (Object)this.thisFile);
        this.thresholdSelectionUI.loadDefaults(justDefaults);
    }

    @Override
    protected void save() {
        String prjPath = Utils.getProjectPathName((String)this.projectName);
        String path = prjPath.concat(File.separator).concat(this.getAnalysisFolder()).concat(PATH_SEPARATOR).concat(this.fileName);
        if (!path.endsWith(".properties")) {
            path = path.concat(".properties");
        }
        File sFile = new File(path);
        this.saveToFile(sFile, false);
    }

    public Properties getDefProp() {
        return this.defProp;
    }

    public Properties getThisProp() {
        return this.thisProp;
    }

    @Override
    protected void initPage() {
        this.defaultFile = this.getDefaultSettFile();
        this.defProp = Utils.readSettings((File)this.defaultFile);
        this.initiated = true;
    }

    @Override
    protected File getDefaultSettFile() {
        String prjPath = Utils.getProjectPathName((String)this.projectName);
        String analysisPath = prjPath.concat(File.separator).concat(this.getAnalysisFolder());
        File folder = new File(analysisPath);
        boolean created = false;
        if (!folder.exists()) {
            try {
                created = folder.mkdirs();
            }
            catch (Exception e) {
                L.error("error at creating analysis setting directory: {}", (Object)analysisPath, (Object)e);
            }
        }
        String path = analysisPath.concat(PATH_SEPARATOR).concat("default.properties");
        return new File(path);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.thresholdSelectionUI.setReadOnly(readOnly);
        if (!readOnly && this.defaultFile == null) {
            this.defaultFile = this.getDefaultSettFile();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    protected void saveToFile(File where, boolean asDefault) {
        Properties properties = new Properties();
        Properties prop = this.thresholdSelectionUI.getProperties();
        properties.putAll((Map<?, ?>)prop);
        if (!asDefault) {
            this.thisProp.clear();
            this.thisProp.putAll((Map<?, ?>)properties);
        }
        L.debug("saving to file: {}", (Object)where);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(where);
                properties.store(fileOutputStream, "#comment");
            }
            catch (FileNotFoundException e) {
                L.error("error at saving to file: {}", (Object)where, (Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e2) {
                    L.error("saveToFile", (Throwable)e2);
                }
            }
            catch (IOException e) {
                L.error("error at saving to file: {}", (Object)where, (Object)e);
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e3) {
                    L.error("saveToFile", (Throwable)e3);
                }
            }
            catch (Throwable t) {
                L.error("error at saving to file: {}", (Object)where, (Object)t);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    L.error("saveToFile", (Throwable)e);
                }
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                L.error("saveToFile", (Throwable)e);
            }
        }
    }

    public abstract String getThresholdTypeString();

    public abstract String getFirstThresholdTypeString();

    public abstract String getThirdThresholdTypeString();

    public abstract RGB getFirstDefaultColor();

    public abstract RGB getSecondDefaultColor();

    public abstract RGB getThirdDefaultColor();

    public abstract Integer getFirstDefaultThreshold();

    public abstract Integer getSecondDefaultThreshold();

    public String getMessage() {
        return this.msg.getMessage();
    }
}

