/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.projectInventory;

import com.ez.common.model.BaseResourceInput;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.projectInventory.DataSource;
import com.ez.report.application.ezreport.reports.summary.projectInventory.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends com.ez.report.application.ezreport.reports.summary.programSummary.ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = this.buildModel();
            this.report.addProperty("filtered by app", (Object)false);
            this.setOwnerInfos(this.inputs);
            Boolean value = (Boolean)this.inputs.get("show summary only");
            this.report.addProperty("show summary only", (Object)value);
            this.addAppendixProperties(this.report);
        }
        return this.report;
    }

    protected AbstractReport buildModel() {
        return new ReportModel(this.project, true);
    }

    @Override
    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        this.parameters.put("appendixFirstLineLabel", null);
        params.put("showInputs1", params.get("showAppendix"));
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        String externalized = null;
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        if (showSummaryOnly) {
            params.put("report.title", this.getReportTitle(true));
        } else {
            params.put("report.title", this.getReportTitle(false));
        }
        externalized = Messages.getString(ReportBuilder.class, "report.summary");
        params.put("report.summary", externalized);
        externalized = Messages.getString(ReportBuilder.class, "details.group.name");
        params.put("group1.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "summary.group.name");
        params.put("group2.name", externalized);
    }

    protected String getReportTitle(boolean onlySummary) {
        if (onlySummary) {
            return Messages.getString(((Object)((Object)this)).getClass(), "onlySummaryReport.title");
        }
        return Messages.getString(((Object)((Object)this)).getClass(), "report.title");
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        Boolean showOnlySummary = (Boolean)this.getReportModel().getProperty("show summary only");
        DataSource dataSource = this.buildDSObject(showOnlySummary, csvWriter);
        dataSource.setData(this.getData(pmonitor));
        this.parameters.put("inputResources", this.project);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        if (csvWriter != null) {
            csvWriter.close();
        }
        monitor.done();
        return dataSource;
    }

    protected DataSource buildDSObject(Boolean showOnlySummary, CSVWriter csvWriter) {
        return new DataSource(showOnlySummary != null ? showOnlySummary : false, csvWriter);
    }

    protected Map<String, List<ProgramInputNoGUI>> getData(IProgressMonitor pmonitor) {
        this.clearForJasperReport();
        HashMap<String, List<ProgramInputNoGUI>> results = new HashMap<String, List<ProgramInputNoGUI>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        SingleQueryResult queryResult = this.querySQLForData("select * from pj_folder", (IProgressMonitor)monitor);
        String[][] res = queryResult.data;
        if (res == null) {
            L.warn("project has no folders!");
        } else {
            HashMap<Integer, Object[]> temp = new HashMap<Integer, Object[]>();
            int i = 0;
            while (i < res.length) {
                Integer idFolder = new Integer(Integer.parseInt(res[i][0]));
                String folderName = res[i][1];
                Integer idParent = new Integer(Integer.parseInt(res[i][3]));
                temp.put(idFolder, new Object[]{folderName, idParent});
                ++i;
            }
            for (Integer idFolder : temp.keySet()) {
                queryResult = this.querySQLForData("select * from pj_file where id_folder = " + idFolder, (IProgressMonitor)monitor);
                res = queryResult.data;
                if (res == null) {
                    L.info("folder {} has no files!", (Object)idFolder);
                    continue;
                }
                int i2 = 0;
                while (i2 < res.length) {
                    Integer idFile = new Integer(Integer.parseInt(res[i2][0]));
                    String fileName = res[i2][1];
                    Integer idFileType = new Integer(Integer.parseInt(res[i2][2]));
                    String prgTypeStr = Utils.getResourceExternalizedType((Integer)idFileType);
                    ArrayList<ProgramInputNoGUI> prgs = (ArrayList<ProgramInputNoGUI>)results.get(prgTypeStr);
                    if (prgs == null) {
                        prgs = new ArrayList<ProgramInputNoGUI>();
                        results.put(prgTypeStr, prgs);
                    }
                    prgs.add(new ProgramInputNoGUI(fileName, idFileType, idFile));
                    ++i2;
                }
            }
            temp = null;
        }
        return results;
    }

    protected void buildInputs4Appendix(Set<? extends BaseResourceInput> prgList) {
        String appendixStr = this.prepareAppendixResrsList(prgList);
        this.parameters.put("inputResources", appendixStr);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.type"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.name")});
        }
    }
}

