/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.projectInventory;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.SummaryGenericDataSource;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
extends SummaryGenericDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DataSource.class);
    private Map<String, List<ProgramInputNoGUI>> reportData;

    public DataSource(boolean showOnlySummary, CSVWriter csvWriter) {
        super(null, showOnlySummary, csvWriter);
    }

    @Override
    protected void init() {
        if (this.isOnlySummary()) {
            this.list.add(new ElementGroupInfo(null));
        }
    }

    @Override
    public void setData(StoredProcedureResults data) {
    }

    public void setData(Map<String, List<ProgramInputNoGUI>> data) {
        this.reportData = data;
        if (!this.isOnlySummary()) {
            this.buildDetails();
        }
    }

    protected String getSummaryTotalLabel(String type) {
        return Messages.getString(((Object)((Object)this)).getClass(), "summary.total.label.ofType", new String[]{type});
    }

    private void buildDetails() {
        DSFactory factory = new DSFactory();
        this.list.clear();
        ElementGroupInfo elem = null;
        ArrayList<ObjectForSubreport> objList = null;
        BaseSubreportDataSource elemDS = null;
        ObjectForSubreport obj = null;
        if (!this.reportData.isEmpty()) {
            ArrayList<String> restypes = new ArrayList<String>(this.reportData.keySet());
            Collections.sort(restypes);
            for (String resType : restypes) {
                elemDS = factory.createDS(1);
                objList = new ArrayList<ObjectForSubreport>();
                elemDS.setList(objList);
                elem = new ElementGroupInfo(resType);
                elem.addDataSource((SubreportDataSource)elemDS);
                List<ProgramInputNoGUI> resources = this.reportData.get(resType);
                Collections.sort(resources);
                for (ProgramInputNoGUI inpt : resources) {
                    String[] results = new String[]{inpt.getTypeCode().toString(), inpt.getName()};
                    obj = factory.createObj(1, results, "");
                    objList.add(obj);
                    this.csvWriter.write(new String[]{resType, inpt.getName()});
                }
                this.list.add(elem);
            }
        }
    }

    @Override
    protected SubreportDataSource getTotalSummaryDataSource(String appName) {
        SubreportDataSource subReportDS = null;
        ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
        this.prgTotalsDS = new SC1DataSource(null, lst);
        if (this.reportData == null || this.reportData.keySet().size() == 0) {
            ObjectForSubreport obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(DataSource.class, "noData.entry"));
            obj.setExpVal("");
            lst.add(obj);
        } else {
            int total = 0;
            ArrayList<String> restypes = new ArrayList<String>(this.reportData.keySet());
            Collections.sort(restypes);
            for (String type : restypes) {
                ObjectForSubreport obj = new ObjectForSubreport();
                String totalString = this.getSummaryTotalLabel(type);
                obj.setExp(totalString);
                Integer prgNo = this.reportData.get(type).size();
                obj.setExpVal("" + prgNo);
                lst.add(obj);
                total += prgNo.intValue();
            }
        }
        return subReportDS;
    }

    @Override
    protected SubreportDataSource getAvgSummaryDataSource(String appName) {
        return null;
    }
}

