/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.programSummary;

import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.Triplet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryDS
extends AbstractReportDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SummaryDS.class);
    protected Iterator<String> it = null;
    private String currentApplication = null;
    private Map<String, Triplet<SubreportDataSource, SubreportDataSource, SubreportDataSource>> summaryMap;

    public SummaryDS(Map<String, Triplet<SubreportDataSource, SubreportDataSource, SubreportDataSource>> summDS) {
        this.summaryMap = summDS;
        if (this.summaryMap != null) {
            ArrayList<String> ordered = new ArrayList<String>(this.summaryMap.keySet());
            Collections.sort(ordered);
            this.it = ordered.iterator();
        }
    }

    public boolean nextItem() throws JRException {
        String string = this.currentApplication = this.it != null && this.it.hasNext() ? this.it.next() : null;
        return this.currentApplication != null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field.getName().equals("totalSummaryDataSource")) {
            value = this.getTotalSummaryDataSource(this.currentApplication);
        }
        if (field.getName().equals("avgSummaryDataSource")) {
            value = this.getAvgSummaryDataSource(this.currentApplication);
        }
        if (field.getName().equals("app_name")) {
            value = this.currentApplication;
        }
        if (field.getName().equals("programTypesDataSource")) {
            value = this.getPrgTypesDataSource(this.currentApplication);
        }
        return value;
    }

    private SubreportDataSource getPrgTypesDataSource(String application) {
        return (SubreportDataSource)this.summaryMap.get(application).getThird();
    }

    private SubreportDataSource getAvgSummaryDataSource(String application) {
        return (SubreportDataSource)this.summaryMap.get(application).getSecond();
    }

    private SubreportDataSource getTotalSummaryDataSource(String application) {
        return (SubreportDataSource)this.summaryMap.get(application).getFirst();
    }
}

