/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.programSummary;

import com.ez.common.model.BaseResourceInput;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.computation.NumberOfStatementsCollector;
import com.ez.mainframe.computation.ProgramVsDatacomTablesCollector;
import com.ez.mainframe.computation.ProgramVsFilesCollector;
import com.ez.mainframe.computation.ProgramVsIDMSRecordsAndSetsCollector;
import com.ez.mainframe.computation.ProgramVsIMSDBCollector;
import com.ez.mainframe.computation.ProgramVsIncludesCollector;
import com.ez.mainframe.computation.ProgramVsSqlTablesCollector;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.model.ApplicationInputNoGUI;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProjectType;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.selection.Manager;
import com.ez.report.application.ezreport.reports.SummaryGenericDataSource;
import com.ez.report.application.ezreport.reports.summary.ProgramSummaryScriptlet;
import com.ez.report.application.ezreport.reports.summary.programSummary.SummaryGenericReport;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    List resultList = null;
    private static final String EZREP_PROC_NO = "EZReports_NumberOfProcedures";
    private static final String EZREP_ADS_DOALOG_PROC_NO = "EZReports_NumberOfProcedures_ADSDialog";
    private static final String EZREP_CALLS_NO = "EZReports_NumberOfProgramCalls";
    private static final String EZREP_TOTAL_BFP_COBOL_SELECTIVE = "EZReports_TotalBFP_COBOL_Selective";
    private static final String EZREP_TOTAL_BFP_PL1_SELECTIVE = "EZReports_TotalBFP_PL1_Selective";
    private static final String EZREP_TOTAL_BFP_NATURAL_SELECTIVE = "EZReports_TotalBFP_NATURAL_Selective";
    private static final String EZREP_TOTAL_BFP_ASSEMBLER_SELECTIVE = "EZReports_TotalBFP_ASSEMBLER_Selective";
    private static final String EZREP_BFP_COBOL = "EZReports_BFP_COBOL";
    private static final String EZREP_BFP_PL1 = "EZReports_BFP_PL1";
    private static final String EZREP_BFP_NATURAL = "EZReports_BFP_NATURAL";
    private static final String EZREP_BFP_ASSEMBLER = "EZReports_BFP_ASSEMBLER";
    private static final String EZREP_TOTAL_BFP_COBOL = "EZReports_TotalBFP_COBOL";
    private static final String EZREP_TOTAL_BFP_PL1 = "EZReports_TotalBFP_PL1";
    private static final String EZREP_TOTAL_BFP_NATURAL = "EZReports_TotalBFP_NATURAL";
    private static final String EZREP_TOTAL_BFP_ASSEMBLER = "EZReports_TotalBFP_ASSEMBLER";
    protected int queryStep = 0;
    String currentApp = "";

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.resultList = new LinkedList();
    }

    protected String getProcedure() {
        switch (this.queryStep) {
            case 0: {
                return "EZReports_ProgramsVsFiles";
            }
            case 1: {
                return "EZReports_ProgramsVsSQLTables";
            }
            case 2: {
                return "EZReports_ProgramsVsSmartTable";
            }
            case 3: {
                return "EZReports_ListingOfAllIncludeFilesUsedInProgram";
            }
            case 4: {
                return "EZReports_ProgramsVsSmartScreens";
            }
            case 5: {
                return "EZReports_ProgramsVsSmartLogicalFile";
            }
            case 6: {
                return "EZReports_ProgramsVsPrinterFiles";
            }
            case 7: {
                return "EZReports_CLProgramsVsCLFiles";
            }
            case 8: {
                return EZREP_PROC_NO;
            }
            case 81: {
                return EZREP_ADS_DOALOG_PROC_NO;
            }
            case 82: {
                return "EZReports_NumberOfStatements";
            }
            case 9: {
                return EZREP_CALLS_NO;
            }
            case 10: {
                return "EZReports_ProgramsVsIdmsRecordsUsage";
            }
            case 11: {
                return "EZReports_ProgramsVsIdmsSetUsage2";
            }
            case 12: {
                return EZREP_BFP_COBOL;
            }
            case 13: {
                return EZREP_BFP_PL1;
            }
            case 14: {
                return EZREP_BFP_NATURAL;
            }
            case 15: {
                return EZREP_TOTAL_BFP_COBOL;
            }
            case 16: {
                return EZREP_TOTAL_BFP_PL1;
            }
            case 17: {
                return EZREP_TOTAL_BFP_NATURAL;
            }
            case 18: {
                return EZREP_BFP_ASSEMBLER;
            }
            case 19: {
                return EZREP_TOTAL_BFP_ASSEMBLER;
            }
            case 20: {
                return "EZReports_ProgramsVsDatacomTables";
            }
            case 21: {
                return "EZViewer_IMSDBProgVsSegUsage";
            }
        }
        return "EZReports_ProgramsVsFiles";
    }

    protected String getSelectiveProcedure() {
        switch (this.queryStep) {
            case 0: {
                return "EZReports_ProgramsVsFiles_Selective";
            }
            case 1: {
                return "EZReports_ProgramsVsSQLTables_Selective";
            }
            case 2: {
                return "EZReports_ProgramsVsSmartTable_Selective";
            }
            case 3: {
                return "EZReports_ListingOfAllIncludeFilesUsedInProgram_Selective";
            }
            case 4: {
                return "EZReports_ProgramsVsSmartScreens_Selective";
            }
            case 5: {
                return "EZReports_ProgramsVsSmartLogicalFile_Selective";
            }
            case 6: {
                return "EZReports_ProgramsVsPrinterFiles_Selective";
            }
            case 7: {
                return "EZReports_CLProgramsVsCLFiles_Selective";
            }
            case 8: {
                return "EZReports_NumberOfProcedures_Selective";
            }
            case 81: {
                return "EZReports_NumberOfProcedures_ADSDialog_Selective";
            }
            case 82: {
                return "EZReports_NumberOfStatements_Selective";
            }
            case 9: {
                return "EZReports_NumberOfProgramCalls_Selective";
            }
            case 10: {
                return "EZReports_ProgramsVsIdmsRecordsUsage_Selective";
            }
            case 11: {
                return "EZReports_ProgramsVsIdmsSetUsage2_Selective";
            }
            case 12: {
                return "EZReports_BFP_COBOL_Selective";
            }
            case 13: {
                return "EZReports_BFP_PL1_Selective";
            }
            case 14: {
                return "EZReports_BFP_NATURAL_Selective";
            }
            case 15: {
                return EZREP_TOTAL_BFP_COBOL_SELECTIVE;
            }
            case 16: {
                return EZREP_TOTAL_BFP_PL1_SELECTIVE;
            }
            case 17: {
                return EZREP_TOTAL_BFP_NATURAL_SELECTIVE;
            }
            case 18: {
                return "EZReports_BFP_ASSEMBLER_Selective";
            }
            case 19: {
                return EZREP_TOTAL_BFP_ASSEMBLER_SELECTIVE;
            }
            case 20: {
                return "EZReports_ProgramsVsDatacomTables_Selective";
            }
            case 21: {
                return "EZViewer_IMSDBProgVsSegUsage";
            }
        }
        return "EZReports_ProgramsVsFiles_Selective";
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        HashMap<BaseResourceInput, ElementGroupInfo> inputPrgMap = new HashMap<BaseResourceInput, ElementGroupInfo>();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.parameters.put("appendixFirstLineValue", String.valueOf(prgList.size()));
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        for (BaseResourceInput prg : prgList) {
            String prgName = prg.getListableName();
            inputPrgMap.put(prg, new ElementGroupInfo(prgName));
        }
        boolean isVME = this.pInfo.getEnvironment().equalsIgnoreCase(ProjectType.vme.toString()) && this.pInfo.getDbTypes().contains("IDMSX");
        SummaryGenericDataSource dataSource = new SummaryGenericDataSource(inputPrgMap, showSummaryOnly, csvWriter);
        dataSource.setIsVME(isVME);
        dataSource.setData(this.data((IProgressMonitor)monitor));
        if (csvWriter != null) {
            csvWriter.close();
        }
        monitor.done();
        return dataSource;
    }

    protected StoredProcedureResults data(IProgressMonitor monitor) {
        final StoredProcedureResults dbData = new StoredProcedureResults();
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    ReportBuilder.this.data(conn, dbData, pmonitor);
                }
            }, LockType.Shared, monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        return dbData;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        this.parameters.put("totalLbl", Messages.getString(ReportBuilder.class, "summary.totals.label"));
        this.parameters.put("avgLbl", Messages.getString(ReportBuilder.class, "summary.averages.label"));
        com.ez.report.application.ezreport.utils.Utils.addScriptlet(this.parameters, ProgramSummaryScriptlet.class.getName());
        this.parameters.put("separateColumn", false);
        this.putSubreportStream("/reports/inventorySummary.jasper", "summarySubreportTemplate");
        this.putSubreportStream("/reports/subCols1.jasper", "summarySubreportTemplateS1");
        this.putSubreportStream("/reports/subCols2.jasper", "summarySubreportTemplateS2");
        this.putSubreportStream("/reports/subBase.jasper", "detailsSubreportTemplate");
        monitor.worked(100);
        return this.parameters;
    }

    protected String getReportTemplatePath() {
        return "reports/summaryReport.jasper";
    }

    private StoredProcedureResults data(EZSourceConnection conn, StoredProcedureResults spr, IProgressMonitor pmonitor) {
        this.clearForJasperReport();
        SingleQueryResult queryResult = null;
        int selectedPrgNo = 0;
        Collection selected = this.getSelected();
        if (selected != null) {
            selectedPrgNo = selected.size();
        }
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        if (selectedPrgNo == 0) {
            L.warn("no results for Program Programs Inventory (Summary) report");
        } else {
            ProgramVsDatacomTablesCollector collector;
            ProgramVsIDMSRecordsAndSetsCollector collector2;
            Collection prgIDs;
            ProgramVsFilesCollector procCalc;
            L.debug("Program Summary results:");
            if (Manager.getInstance().checkAvailability(this.pInfo, "summReport", "0")) {
                this.queryStep = 0;
                procCalc = new ProgramVsFilesCollector(!this.report.useAllResources(), false);
                String[][] results = procCalc.compute(pmonitor, prgIDs = this.filterSelectedIDs(), conn);
                if (results != null) {
                    spr.setResultsPrgVSFiles(results);
                }
            }
            if (Manager.getInstance().checkAvailability(this.pInfo, "summReport", "3")) {
                this.queryStep = 1;
                ProgramVsSqlTablesCollector collector3 = new ProgramVsSqlTablesCollector(!this.report.useAllResources(), false);
                String[][] resultsPrgsVSSQLTables = collector3.compute(pmonitor, prgIDs = this.filterSelectedIDs(), conn);
                if (resultsPrgsVSSQLTables != null) {
                    spr.setResultsPrgVSSQLTables(resultsPrgsVSSQLTables);
                }
            }
            this.queryStep = 3;
            procCalc = new ProgramVsIncludesCollector(!this.report.useAllResources(), false);
            String[][] resultsPrgsVSInclude = procCalc.compute(pmonitor, prgIDs = this.filterSelectedIDs(), conn);
            if (resultsPrgsVSInclude != null) {
                spr.setResultsPrgsVSInclude(resultsPrgsVSInclude);
            }
            if (Manager.getInstance().checkAvailability(this.pInfo, "summReport", "5")) {
                this.queryStep = 2;
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.String, this.getSelected(), queryResult, conn);
                String[][] resultsPrgsVSSmartTables = queryResult.data;
                if (resultsPrgsVSSmartTables != null) {
                    spr.setResultsPrgVSSmartTables(resultsPrgsVSSmartTables);
                }
                this.queryStep = 4;
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.String, this.getSelected(), queryResult, conn);
                String[][] resultsPrgsVSSmartScreen = queryResult.data;
                if (resultsPrgsVSSmartScreen != null) {
                    spr.setResultsPrgsVSSmartScreen(resultsPrgsVSSmartScreen);
                }
                this.queryStep = 5;
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.String, this.getSelected(), queryResult, conn);
                String[][] resultsPrgsVSLogicalFiles = queryResult.data;
                if (resultsPrgsVSLogicalFiles != null) {
                    spr.setResultsPrgsVSLogicalFile(resultsPrgsVSLogicalFiles);
                }
                this.queryStep = 6;
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.String, this.getSelected(), queryResult, conn);
                String[][] resultsPrgsVSPrinterFiles = queryResult.data;
                if (resultsPrgsVSPrinterFiles != null) {
                    spr.setResultsPrgsVSPrinterFile(resultsPrgsVSPrinterFiles);
                }
            }
            if (Manager.getInstance().checkAvailability(this.pInfo, "summReport", "4")) {
                this.queryStep = 7;
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.String, this.getSelected(), queryResult, conn);
                String[][] resultsPrgsVSCLFiles = queryResult.data;
                if (resultsPrgsVSCLFiles != null) {
                    spr.setResultsPrgsVSCLFile(resultsPrgsVSCLFiles);
                }
            }
            this.queryStep = 8;
            queryResult = new SingleQueryResult();
            this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
            String[][] resultsProceduresOccurrences = queryResult.data;
            if (resultsProceduresOccurrences != null) {
                spr.setProceduresOccurrences(resultsProceduresOccurrences);
            }
            this.queryStep = 81;
            queryResult = new SingleQueryResult();
            this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
            String[][] resultsProceduresOccurrences2 = queryResult.data;
            if (resultsProceduresOccurrences2 != null) {
                if (spr.resultsProceduresOccurrences != null) {
                    ArrayList tmp = new ArrayList(Arrays.asList(spr.resultsProceduresOccurrences));
                    tmp.addAll(Arrays.asList(resultsProceduresOccurrences2));
                    spr.setProceduresOccurrences((String[][])tmp.toArray((T[])new String[0][]));
                } else {
                    spr.setProceduresOccurrences(resultsProceduresOccurrences2);
                }
            }
            this.queryStep = 82;
            NumberOfStatementsCollector stmtCalc = new NumberOfStatementsCollector(!this.report.useAllResources());
            String[][] resultsStmtsOccurrences = stmtCalc.compute(conn, this.getSelected(), pmonitor);
            if (resultsStmtsOccurrences != null) {
                spr.setStmtsOccurrences(resultsStmtsOccurrences);
            }
            this.queryStep = 9;
            queryResult = new SingleQueryResult();
            this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
            String[][] resultsCallsOccurrences = queryResult.data;
            if (resultsCallsOccurrences != null) {
                spr.setResultsCallsOccur(resultsCallsOccurrences);
            }
            if (Manager.getInstance().checkAvailability(this.pInfo, "summReport", "2")) {
                this.queryStep = 10;
                collector2 = new ProgramVsIDMSRecordsAndSetsCollector(!this.report.useAllResources(), false, 0);
                String[][] resultsIDMSRecord = collector2.compute(pmonitor, prgIDs = this.filterSelectedIDs(), conn);
                if (resultsIDMSRecord != null) {
                    spr.setResultsIDMSRecord(resultsIDMSRecord);
                }
            }
            if (Manager.getInstance().checkAvailability(this.pInfo, "summReport", "1")) {
                this.queryStep = 11;
                collector2 = new ProgramVsIDMSRecordsAndSetsCollector(!this.report.useAllResources(), false, 1);
                String[][] resultsIDMSSet = collector2.compute(pmonitor, prgIDs = this.filterSelectedIDs(), conn);
                if (resultsIDMSSet != null) {
                    spr.setResultsIDMSSet(resultsIDMSSet);
                }
            }
            DecimalFormat format = new DecimalFormat();
            format.setMaximumFractionDigits(1);
            this.queryStep = 12;
            queryResult = new SingleQueryResult();
            this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
            String[][] resultsBFPCobol = queryResult.data;
            if (resultsBFPCobol != null) {
                this.formatBFPdata(format, resultsBFPCobol);
                spr.setResultsBFPCobol(resultsBFPCobol);
            }
            this.queryStep = 13;
            queryResult = new SingleQueryResult();
            this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
            String[][] resultsBFPPl1 = queryResult.data;
            if (resultsBFPPl1 != null) {
                this.formatBFPdata(format, resultsBFPPl1);
                spr.setResultsBFPPl1(resultsBFPPl1);
            }
            this.queryStep = 14;
            queryResult = new SingleQueryResult();
            this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
            String[][] resultsBFPNatural = queryResult.data;
            if (resultsBFPNatural != null) {
                this.formatBFPdata(format, resultsBFPNatural);
                spr.setResultsBFPNatural(resultsBFPNatural);
            }
            this.queryStep = 18;
            queryResult = new SingleQueryResult();
            this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
            String[][] resultsBFPAssembler = queryResult.data;
            if (resultsBFPAssembler != null) {
                Double bfpVal = new Double(0.0);
                int distinctParentsCounter = 0;
                String previousParentID = "";
                String previousParentName = "";
                String[][] res = new String[selectedPrgNo][3];
                int i = 0;
                while (i < resultsBFPAssembler.length) {
                    String[] result = resultsBFPAssembler[i];
                    String parentName = result[2];
                    String parentID = result[3];
                    if (parentID != null) {
                        String resBFP = result[1];
                        if (previousParentID.isEmpty()) {
                            previousParentID = parentID;
                            previousParentName = parentName;
                            bfpVal = Double.valueOf(resBFP);
                        } else if (previousParentID.equalsIgnoreCase(parentID)) {
                            bfpVal = bfpVal + Double.valueOf(resBFP);
                        } else {
                            res[distinctParentsCounter][0] = previousParentName;
                            res[distinctParentsCounter][1] = format.format(bfpVal / 400.0);
                            res[distinctParentsCounter][2] = previousParentID;
                            previousParentID = parentID;
                            previousParentName = parentName;
                            bfpVal = Double.valueOf(resBFP);
                            ++distinctParentsCounter;
                        }
                        if (i + 1 == resultsBFPAssembler.length) {
                            res[distinctParentsCounter][0] = previousParentName;
                            res[distinctParentsCounter][1] = format.format(bfpVal / 400.0);
                            res[distinctParentsCounter][2] = previousParentID;
                        }
                    }
                    ++i;
                }
                if (selectedPrgNo == distinctParentsCounter + 1) {
                    spr.setResultsBFPAssembler(res);
                } else {
                    String[][] new_res = new String[distinctParentsCounter + 1][3];
                    System.arraycopy(res, 0, new_res, 0, distinctParentsCounter + 1);
                    spr.setResultsBFPAssembler(new_res);
                }
            }
            boolean hasApp = true;
            HashSet<String> appNames = (HashSet<String>)this.getReportModel().getProperty("selected app names");
            if (appNames == null) {
                appNames = new HashSet<String>();
                appNames.add("");
                hasApp = false;
            }
            for (String this.currentApp : appNames) {
                this.queryStep = 15;
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
                String[][] totalBFPCobol = queryResult.data;
                if (totalBFPCobol != null) {
                    spr.setTotalBFPCobol(this.currentApp, totalBFPCobol);
                }
                this.queryStep = 16;
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
                String[][] totalBFPPl1 = queryResult.data;
                if (totalBFPPl1 != null) {
                    spr.setTotalBFPPl1(this.currentApp, totalBFPPl1);
                }
                this.queryStep = 17;
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.Integer, this.filterSelectedIDs(), queryResult, conn);
                String[][] totalBFPNatural = queryResult.data;
                if (totalBFPNatural != null) {
                    spr.setTotalBFPNatural(this.currentApp, totalBFPNatural);
                }
                this.queryStep = 19;
                boolean hasAsm = false;
                for (ProgramInputNoGUI prg : selected) {
                    boolean bl = hasAsm = prg.getTypeCode() == 8 || prg.getTypeCode() == 15 || prg.getTypeCode() == 16;
                    if (hasAsm) break;
                }
                if (!hasAsm) continue;
                Collection ids = this.filterSelectedIDs(hasApp ? this.currentApp : null);
                queryResult = new SingleQueryResult();
                this.queryForData(new String[0], EZSourceDataType.Integer, ids, queryResult, conn);
                String[][] totalBFPAssembler = queryResult.data;
                if (totalBFPAssembler == null) continue;
                spr.setTotalBFPAssembler(this.currentApp, totalBFPAssembler);
            }
            if (Manager.getInstance().checkAvailability(this.pInfo, "summReport", "6")) {
                this.queryStep = 20;
                collector = new ProgramVsDatacomTablesCollector(!this.report.useAllResources(), false);
                String[][] resultsPrgsVSDatacomTables = collector.compute(pmonitor, prgIDs = this.filterSelectedIDs(), conn);
                if (resultsPrgsVSDatacomTables != null) {
                    spr.setResultsPrgVSDatacomTables(resultsPrgsVSDatacomTables);
                }
            }
            if (Manager.getInstance().checkAvailability(this.pInfo, "summReport", "7")) {
                this.queryStep = 21;
                collector = new ProgramVsIMSDBCollector(!this.report.useAllResources(), false);
                String[][] results = collector.compute(pmonitor, prgIDs = this.filterSelectedIDs(), conn);
                if (results != null) {
                    spr.setResultsPrgVSIMSDB(results);
                }
            }
            this.currentApp = "";
        }
        return spr;
    }

    private void formatBFPdata(DecimalFormat format, String[][] resultsBFPCobol) {
        int i = 0;
        while (i < resultsBFPCobol.length) {
            try {
                String[] v = resultsBFPCobol[i];
                Double bfpVal = new Double(v[1]);
                resultsBFPCobol[i][1] = format.format(bfpVal);
            }
            catch (Throwable th) {
                L.warn("error trying to format BFP value; skip it!", th);
            }
            ++i;
        }
    }

    Collection filterSelectedIDs(String appName) {
        if (appName == null) {
            return this.filterSelectedIDs();
        }
        HashSet<Integer> selectedIds = new HashSet<Integer>();
        this.currentApp = "";
        Collection selectedResources = this.getSelected();
        this.currentApp = appName;
        for (ProgramInputNoGUI inpt : selectedResources) {
            boolean consider = true;
            if (appName != null) {
                Set apps = inpt.getApplications();
                consider = apps != null ? apps.contains(appName) : false;
            }
            if (!consider) continue;
            if (inpt.getTypeCode() == 8) {
                Collection childrens = inpt.getChildrenIDs();
                if (childrens != null) {
                    selectedIds.addAll(childrens);
                    continue;
                }
                L.warn("assembler program without children?! {}", (Object)inpt.getName());
                selectedIds.add(inpt.getResourceID());
                continue;
            }
            selectedIds.add(inpt.getResourceID());
        }
        return selectedIds;
    }

    protected Collection getSelected() {
        if (!"".equals(this.currentApp)) {
            return this.getPrograms(this.currentApp);
        }
        return super.getSelected();
    }

    private Collection getPrograms(String currentApp) {
        return this.apps.get(currentApp) != null ? ((ApplicationInputNoGUI)this.apps.get(currentApp)).getPrograms() : null;
    }

    protected void clearForJasperReport() {
        this.resultList.clear();
    }

    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        params.put("showInputs1", params.get("showInputs"));
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReportWithFrame.jasper", (String)"headingsTemplate", (Map)this.parameters);
    }

    protected void putExternalizedParameters(Map params) {
        String externalized = null;
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        if (showSummaryOnly) {
            externalized = Messages.getString(((Object)((Object)this)).getClass(), "onlySummaryReport.title");
            params.put("report.title", externalized);
        } else {
            externalized = Messages.getString(((Object)((Object)this)).getClass(), "report.title");
            params.put("report.title", externalized);
        }
        externalized = Messages.getString(((Object)((Object)this)).getClass(), "group1.name");
        params.put("group1.name", externalized);
        this.printIgnoredPrograms();
    }

    protected void printIgnoredPrograms() {
        List ignored = (List)this.inputs.get("ignoredPrograms");
        if (ignored != null && !ignored.isEmpty()) {
            Collections.sort(ignored);
            StringBuilder sb = new StringBuilder(ignored.toString());
            sb = sb.deleteCharAt(0);
            sb = sb.deleteCharAt(sb.length() - 1);
            this.parameters.put("resourcesSummary.2", Messages.getString(ReportBuilder.class, "appendix.ignoredPrograms.label"));
            this.parameters.put("inputResources.2", sb.toString());
        }
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = this.buildModelObj();
            List prgList = (List)this.inputs.get("selected resources");
            this.report.setInput((Object)prgList);
            Boolean value = (Boolean)this.inputs.get("show summary only");
            this.report.addProperty("show summary only", (Object)value);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    protected AbstractReport buildModelObj() {
        return new SummaryGenericReport(this.project, false);
    }

    protected void customizeJasperPrint(JasperPrint print) {
        List pages;
        if (print != null && (pages = print.getPages()) != null && pages.size() > 0) {
            ReportsUtils.removeEmptyPages((List)pages, (String)"programs inventory");
        }
    }

    protected void displayCancelMessage() {
        super.displayCancelMessage();
    }

    public void cleanMemory() {
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        super.cleanMemory();
    }

    protected int countAvailableProjectPrograms(EZSourceConnection conn) {
        return Utils.countAvailablePrograms((String)"SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (9, 13, 14, 15, 16) ", (EZSourceConnection)conn);
    }

    protected String getQuery4CountEntries() {
        return "SELECT Count(ProgramName) FROM Programs where OccurID <> 0 and ProgramTypeID not in (15, 16) ";
    }

    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.program"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.resourceType"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.resourceName")});
        }
    }
}

