/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.missing;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.missing.DataSource;
import com.ez.report.application.ezreport.reports.summary.missing.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends com.ez.report.application.ezreport.reports.summary.programSummary.ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String EZREP_MISSING_PROGRAMS_SELECTIVE_1 = "EZReports_Missing_Components_Selective_1";
    private static final String EZREP_MISSING_PROGRAMS_SELECTIVE_2 = "EZReports_Missing_Components_Selective_2";
    private static final String EZREP_MISSING_PROGRAMS_SELECTIVE_1_FORVME = "EZReports_Missing_Components_Selective_1_forVME";
    private static final String EZREP_MISSING_PROGRAMS_SELECTIVE_2_FORVME = "EZReports_Missing_Components_Selective_2_forVME";
    int step = 1;
    boolean isVME = false;

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project, false);
            List prgList = (List)this.inputs.get("selected resources");
            this.report.setInput((Object)prgList);
            Object selectedApps = this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            Object selectedAppsNames = this.inputs.get("selected applications names");
            this.report.addProperty("selected app names", selectedAppsNames);
            this.addAppendixProperties(this.report);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        externalized = Messages.getString(ReportBuilder.class, "missingListLbl");
        params.put("unusedListLbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum1.lbl");
        params.put("report.sum1.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "report.sum2.lbl");
        params.put("report.sum2.lbl", externalized);
        params.put("group1.name", "");
        externalized = Messages.getString(ReportBuilder.class, "application.summary.group.prefix");
        params.put("group2.name", externalized);
        this.printIgnoredPrograms();
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        if (csvWriter != null) {
            this.writeCSVHeader(csvWriter, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csvWriter.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.prg.col.lbl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.comp.col.lbl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.lines.col.lbl")});
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        HashMap<ProgramInputNoGUI, ElementGroupInfo> inputPrgMap = new HashMap<ProgramInputNoGUI, ElementGroupInfo>();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        for (ProgramInputNoGUI prg : prgList) {
            String prgName = prg.getName();
            inputPrgMap.put(prg, new ElementGroupInfo(prgName));
        }
        this.parameters.put("appendixFirstLineValue", String.valueOf(prgList.size()));
        Collection apps = (Collection)this.getReportModel().getProperty("selected app names");
        DataSource dataSource = new DataSource(inputPrgMap, false, csvWriter);
        dataSource.setApplications(apps);
        dataSource.setData(this.buildData((IProgressMonitor)monitor.newChild(100)));
        if (csvWriter != null) {
            csvWriter.close();
        }
        monitor.done();
        return dataSource;
    }

    private Pair<String[][], String[][]> buildData(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "compute.taskName"));
        final Pair res = new Pair();
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        if (ph != null) {
            try {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                        block14: {
                            String tempTableName = "missing_string_param_temp";
                            String callTempTable = null;
                            try {
                                try {
                                    Utils.createTempTable((EZSourceConnection)conn, (String)tempTableName);
                                    callTempTable = com.ez.report.application.ezreport.utils.Utils.createCallingTempTable(conn, L);
                                    ReportBuilder.this.isVME = com.ez.report.application.ezreport.utils.Utils.isVME(conn);
                                    if (ReportBuilder.this.isVME) {
                                        com.ez.report.application.ezreport.utils.Utils.insertSCLProcs(conn, tempTableName);
                                    } else {
                                        L.debug("no SCL selected; no insert into temp table");
                                    }
                                    SingleQueryResult queryResult = new SingleQueryResult();
                                    Object[] procParam = new String[]{};
                                    ReportBuilder.this.queryForData(procParam, EZSourceDataType.Integer, ReportBuilder.this.filterSelectedIDs(), queryResult, conn);
                                    String[][] results = queryResult.data;
                                    res.setFirst((Object)results);
                                    L.debug("after first query");
                                    boolean hasResults = results != null;
                                    ReportBuilder.this.step = 2;
                                    queryResult = new SingleQueryResult();
                                    ReportBuilder.this.queryForData(procParam, EZSourceDataType.Integer, ReportBuilder.this.filterSelectedIDs(), queryResult, conn);
                                    results = queryResult.data;
                                    res.setSecond((Object)results);
                                    L.debug("after second query");
                                    boolean bl = hasResults = results != null;
                                    if (!hasResults) {
                                        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"/reports/subCols1.jasper", (String)"summarySubreportTemplateS2", (Map)ReportBuilder.this.parameters);
                                    }
                                }
                                catch (EZSourceConnectionException e) {
                                    L.error("exception at getting data for report", (Throwable)e);
                                    EZReportErrorLog.err(Messages.getString(ReportBuilder.class, "gettingDataError.logMessage"), e);
                                    if (callTempTable != null) {
                                        Utils.cleanTable((EZSourceConnection)conn, (String)callTempTable);
                                        Utils.dropTempTable((EZSourceConnection)conn, (String)callTempTable);
                                        L.debug("after cleaning calling temporary table");
                                    }
                                    if (ReportBuilder.this.isVME) {
                                        Utils.cleanTable((EZSourceConnection)conn, (String)tempTableName);
                                    }
                                    Utils.dropTempTable((EZSourceConnection)conn, (String)tempTableName);
                                    L.debug("end of getting data");
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                if (callTempTable != null) {
                                    Utils.cleanTable((EZSourceConnection)conn, callTempTable);
                                    Utils.dropTempTable((EZSourceConnection)conn, (String)callTempTable);
                                    L.debug("after cleaning calling temporary table");
                                }
                                if (ReportBuilder.this.isVME) {
                                    Utils.cleanTable((EZSourceConnection)conn, (String)tempTableName);
                                }
                                Utils.dropTempTable((EZSourceConnection)conn, (String)tempTableName);
                                L.debug("end of getting data");
                                throw throwable;
                            }
                            if (callTempTable != null) {
                                Utils.cleanTable((EZSourceConnection)conn, (String)callTempTable);
                                Utils.dropTempTable((EZSourceConnection)conn, (String)callTempTable);
                                L.debug("after cleaning calling temporary table");
                            }
                            if (ReportBuilder.this.isVME) {
                                Utils.cleanTable((EZSourceConnection)conn, (String)tempTableName);
                            }
                            Utils.dropTempTable((EZSourceConnection)conn, (String)tempTableName);
                            L.debug("end of getting data");
                        }
                    }
                }, LockType.Shared, pmonitor);
            }
            catch (InterruptedException interruptedException) {
                throw new CanceledException("connection interrupted");
            }
            catch (ExecutionException e) {
                ErrorUtils.handleExecutionException((ExecutionException)e);
            }
        }
        int allPrgNo = this.getSelected().size();
        this.parameters.put("report.sum1", String.valueOf(allPrgNo));
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.buildInputs4Appendix(prgList);
        this.parameters.put("title.appFieldValues", this.applicationsName);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/subBase.jasper", (String)"detailsSubreportTemplate", (Map)this.parameters);
        monitor.setWorkRemaining(0);
        return res;
    }

    @Override
    protected String getSelectiveProcedure() {
        return this.step == 1 ? (this.isVME ? EZREP_MISSING_PROGRAMS_SELECTIVE_1_FORVME : EZREP_MISSING_PROGRAMS_SELECTIVE_1) : (this.isVME ? EZREP_MISSING_PROGRAMS_SELECTIVE_2_FORVME : EZREP_MISSING_PROGRAMS_SELECTIVE_2);
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
        List pages;
        if (print != null && (pages = print.getPages()) != null && pages.size() > 0) {
            ReportsUtils.removeEmptyPages((List)pages, (String)"mainframe missing components", (boolean)true);
        }
    }
}

