/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.missing;

import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.SummaryGenericDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC1DataSource;
import com.ez.report.generation.common.datasource.SC2DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
extends SummaryGenericDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DataSource.class);
    private static final String BY_PROGRAM_LABEL = Messages.getString(DataSource.class, "group.byProgram.name");
    private static final String BY_PROCEDURE_LABEL = Messages.getString(DataSource.class, "group.byComponent.name");
    private static final String DISTINCT_ACCESSED_COMPONENTS_TOTAL_LABEL = Messages.getString(DataSource.class, "group.byProgram.total.label2");
    private static final String DISTINCT_ACCESSING_PROGRAMS_TOTAL_LABEL = Messages.getString(DataSource.class, "group.byComponent.total.label2");
    private static final String BY_UNRESOLVED_VAR_LABEL = Messages.getString(DataSource.class, "group.byUnresolvedVariables");
    private static final String BY_MISSING_PROGRAMS = Messages.getString(DataSource.class, "group.byMissingPrograms");
    Map<String, Pair<Integer, Set<String>>> totals;
    int prgHavingMissing = 0;
    private Set<String> applications;

    public DataSource(Map prgVsElemGroupMap, boolean showOnlySummary, CSVWriter csvWriter) {
        super(prgVsElemGroupMap, showOnlySummary, csvWriter);
    }

    @Override
    protected void init() {
        this.applications = new HashSet<String>();
        this.applications.add("");
    }

    public void setData(Pair<String[][], String[][]> pair) {
        this.buildDetails((String[][])pair.getFirst(), true);
        this.buildDetails((String[][])pair.getSecond(), false);
        if (this.list.isEmpty()) {
            this.list.add(new ElementGroupInfo(null));
        }
    }

    @Override
    protected SubreportDataSource getAvgSummaryDataSource(String appName) {
        return null;
    }

    @Override
    protected SubreportDataSource getTotalSummaryDataSource(String appName) {
        SC1DataSource subReportDS = null;
        ObjectForSubreport obj = null;
        ArrayList<ObjectForSubreport> list2 = new ArrayList<ObjectForSubreport>();
        if (this.totals != null) {
            Pair<Integer, Set<String>> vals = this.totals.get(appName);
            obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(DataSource.class, "report.summary.total.label1"));
            obj.setExpVal("" + (vals != null ? (Comparable)vals.getFirst() : "0"));
            list2.add(obj);
            obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(DataSource.class, "report.summary.total.label2"));
            obj.setExpVal("" + (vals != null ? Integer.valueOf(((Set)vals.getSecond()).size()) : "0"));
            list2.add(obj);
            subReportDS = new SC2DataSource(null, list2);
        } else {
            obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(DataSource.class, "report.summary.noResults"));
            obj.setExpVal("");
            list2.add(obj);
            subReportDS = new SC1DataSource("", list2);
        }
        return subReportDS;
    }

    protected Set<String> getApplications(String prgName, ProgramInputNoGUI prgInpt) {
        return this.applications;
    }

    private void buildDetails(String[][] results, boolean isByProgram) {
        if (results == null || results.length == 0) {
            L.warn("no results for MissingComponents report");
        } else {
            L.debug("MissingComponents results:");
            String currentProgram = null;
            String currentComp = null;
            Set allComponents = null;
            Set apps = null;
            if (isByProgram) {
                this.totals = new HashMap<String, Pair<Integer, Set<String>>>();
                apps = new HashSet<String>();
                apps.add("");
            }
            ArrayList<ObjectForSubreport> compsList = null;
            ObjectForSubreport current = null;
            int occ = 0;
            int compNr = 0;
            String groupName = isByProgram ? BY_PROGRAM_LABEL : BY_PROCEDURE_LABEL;
            String totalPerObjLabel2 = isByProgram ? DISTINCT_ACCESSED_COMPONENTS_TOTAL_LABEL : DISTINCT_ACCESSING_PROGRAMS_TOTAL_LABEL;
            String totalPerObjLabel1 = Messages.getString(DataSource.class, "group.byComponent.total.label1");
            String column1Name = isByProgram ? Messages.getString(DataSource.class, "group.byProgram.column1.label") : Messages.getString(DataSource.class, "group.byComponent.column1.label");
            String column2Name = Messages.getString(DataSource.class, "group.byProgram.column2.label");
            if (isByProgram) {
                this.list = new ArrayList();
            }
            int i = 0;
            while (i < results.length) {
                String prgName = results[i][0];
                String compName = results[i][1];
                String line = results[i][2];
                Integer typeID = Integer.valueOf(results[i][3]);
                String prgID = results[i][4];
                ProgramInputNoGUI prgInpt = (ProgramInputNoGUI)this.getProgramInput(prgID, this.prgVsElemGroupMap);
                if (prgInpt == null) {
                    L.warn("program not found as input: {}", (Object)prgName);
                } else {
                    if (isByProgram) {
                        prgName = prgInpt.getListableName();
                    } else {
                        compName = prgInpt.getListableName();
                    }
                    if (isByProgram && prgInpt.getApplications() != null && !prgInpt.getApplications().isEmpty()) {
                        apps = prgInpt.getApplications();
                    }
                }
                if (this.csvWriter != null) {
                    this.csvWriter.write(new String[]{prgName, compName, line});
                }
                String compEscapeText = ReportsUtils.stripNonValidXMLCharacters((String)compName, (boolean)true);
                if (!prgName.equalsIgnoreCase(currentProgram)) {
                    if (current != null) {
                        this.buildAndAddSummary(current, occ, compNr, totalPerObjLabel1, totalPerObjLabel2);
                    }
                    currentProgram = prgName;
                    currentComp = compName;
                    occ = 1;
                    compNr = 1;
                    ++this.prgHavingMissing;
                    ElementGroupInfo prgGroup = new ElementGroupInfo(isByProgram ? BY_PROGRAM_LABEL : (typeID == -1 ? BY_UNRESOLVED_VAR_LABEL : BY_MISSING_PROGRAMS));
                    SC1DataSource compDS = new SC1DataSource();
                    compDS.setLayout(3);
                    compDS.setColumn1Name(column1Name);
                    compDS.setColumn2Name(column2Name);
                    compsList = new ArrayList<ObjectForSubreport>();
                    compDS.setList(compsList);
                    compDS.setTocEntry(ReportsUtils.stripNonValidXMLCharacters((String)prgName, (boolean)true));
                    prgGroup.addDataSource((SubreportDataSource)compDS);
                    this.list.add(prgGroup);
                    current = new ObjectForSubreport();
                    compsList.add(current);
                    String txt = isByProgram ? (typeID == -1 ? Messages.getString(DataSource.class, "variable.label", new String[]{compEscapeText}) : compEscapeText) : compEscapeText;
                    current.setExp(txt);
                    current.setExpVal(line);
                    current.setParent(groupName);
                    current.setElGroup(prgName);
                    if (isByProgram) {
                        for (String appName : apps) {
                            Pair pair = this.totals.get(appName);
                            if (pair == null) {
                                pair = new Pair();
                                pair.setFirst((Object)0);
                                pair.setSecond(new HashSet());
                                this.totals.put(appName, (Pair<Integer, Set<String>>)pair);
                            }
                            Integer t = (Integer)pair.getFirst();
                            pair.setFirst((Object)(t + 1));
                            allComponents = (Set)pair.getSecond();
                            allComponents.add(compName);
                        }
                    }
                } else {
                    if (!currentComp.equalsIgnoreCase(compName)) {
                        currentComp = compName;
                        ++compNr;
                        current = new ObjectForSubreport();
                        compsList.add(current);
                        String txt = typeID == -1 ? Messages.getString(DataSource.class, "variable.label", new String[]{compEscapeText}) : compEscapeText;
                        current.setExp(txt);
                        current.setExpVal(line);
                        current.setParent(groupName);
                        current.setElGroup(prgName);
                        if (isByProgram) {
                            for (String appName : apps) {
                                Pair<Integer, Set<String>> pair = this.totals.get(appName);
                                allComponents = (Set)pair.getSecond();
                                allComponents.add(compName);
                            }
                        }
                    } else {
                        String val = current.getExpVal();
                        current.setExpVal(String.valueOf(val) + ", " + line);
                    }
                    ++occ;
                }
                L.debug("{}", (Object)(String.valueOf(column1Name) + results[i][0]));
                L.debug("comp: {}", (Object)results[i][1]);
                L.debug("line: {}", (Object)results[i][2]);
                L.debug("\n");
                ++i;
            }
            if (current != null) {
                this.buildAndAddSummary(current, occ, compNr, totalPerObjLabel1, totalPerObjLabel2);
            }
        }
    }

    private void buildAndAddSummary(ObjectForSubreport current, int occ, int compNr, String totalPerObjLabel1, String totalPerObjLabel2) {
        SC1DataSource summDS = new SC1DataSource();
        summDS.setLayout(7);
        ArrayList<ObjectForSubreport> lst = new ArrayList<ObjectForSubreport>();
        summDS.setList(lst);
        ObjectForSubreport obj = new ObjectForSubreport();
        obj.setExp(totalPerObjLabel1);
        obj.setExpVal(String.valueOf(occ));
        lst.add(obj);
        obj = new ObjectForSubreport();
        obj.setExp(totalPerObjLabel2);
        obj.setExpVal(String.valueOf(compNr));
        lst.add(obj);
        current.setSubreportName(summDS.getReportName());
        current.setSubreportDS((BaseSubreportDataSource)summDS);
    }

    public int getNrProgramsHavingMissingComp() {
        return this.prgHavingMissing;
    }

    public void setApplications(Collection<String> apps) {
        if (apps != null && !apps.isEmpty()) {
            this.applications = new HashSet<String>(apps);
        }
    }
}

