/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.membersInventory;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.membersInventory.MFLibraryInput;
import com.ez.report.application.ezreport.reports.summary.membersInventory.MemberDataSource;
import com.ez.report.application.ezreport.reports.summary.membersInventory.Obj4MemberReport;
import com.ez.report.application.ezreport.reports.summary.membersInventory.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.application.utils.Utils;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.Object4TestReport;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC2DataSourceWithGroup;
import com.ez.report.generation.common.datasource.SC3TableDataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String MEMBER_INVENTORY_SP = "EZReports_MemberInventoryReport";
    private static final String LIBRARIAN_MEMBER_INVENTORY_SP = "EZReports_LibrarianMemberInventoryReport";
    private static final String NATURAL_MEMBER_INVENTORY_SP = "EZReports_NaturalMemberInventoryReport";
    private List resultList = new LinkedList();
    private SortedMap<MFLibraryInput, SC2DataSourceWithGroup> detailsDS = new TreeMap<MFLibraryInput, SC2DataSourceWithGroup>();
    private static final String memberTypeLbl = Messages.getString(ReportBuilder.class, "member.type");
    private static final String memberListingLbl = Messages.getString(ReportBuilder.class, "members.listing.lbl");
    private CSVWriter csvWriter;
    String summaryElementKey = "summary";

    public ReportBuilder(String reportName, String settings) {
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new ReportModel(this.project);
            List mfLibs = (List)this.inputs.get("selected resources");
            this.report.setInput((Object)mfLibs);
            this.setOwnerInfos(this.inputs);
            Boolean value = (Boolean)this.inputs.get("show summary only");
            this.report.addProperty("show summary only", (Object)value);
            this.addAppendixProperties(this.report);
        }
        return this.report;
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        this.csvWriter = this.initTempCSVFile();
        if (this.csvWriter != null) {
            this.writeCSVHeader(this.csvWriter, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            this.csvWriter.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "objectType.mfLibs"), Messages.getString(((Object)((Object)this)).getClass(), "member.type.lbl"), Messages.getString(((Object)((Object)this)).getClass(), "member.name"), Messages.getString(((Object)((Object)this)).getClass(), "number.of.lines")});
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        Set selectedMFLibs = (Set)this.report.getProperty("inputs");
        HashSet<MFLibraryInput> naturalMFLibs = new HashSet<MFLibraryInput>();
        HashSet<MFLibraryInput> simpleMFLibs = new HashSet<MFLibraryInput>();
        HashSet<MFLibraryInput> librarianMFLibs = new HashSet<MFLibraryInput>();
        HashSet<MFLibraryInput> empties = new HashSet<MFLibraryInput>();
        HashMap<String, HashSet<String>> naturalMFLibsNames = new HashMap<String, HashSet<String>>();
        for (MFLibraryInput lib : selectedMFLibs) {
            if (lib.isNaturalLibrary()) {
                naturalMFLibs.add(lib);
            } else if (lib.isLibrarianLibrary()) {
                librarianMFLibs.add(lib);
            } else {
                simpleMFLibs.add(lib);
            }
            HashSet<String> libs = (HashSet<String>)naturalMFLibsNames.get(lib.getTypeText());
            if (libs == null) {
                libs = new HashSet<String>();
                naturalMFLibsNames.put(lib.getTypeText(), libs);
            }
            libs.add(lib.getListableName());
            empties.add(lib);
        }
        ElementGroupInfo sumElem = new ElementGroupInfo(this.summaryElementKey);
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        RunwithLock lockRunn = new RunwithLock(simpleMFLibs, librarianMFLibs, naturalMFLibs);
        try {
            ph.executeWithLock(ph, (IMFRunnable)lockRunn, LockType.Shared, (IProgressMonitor)monitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
        String[][] membersInventory = lockRunn.membersInventory;
        String[][] librarianMembersInventory = lockRunn.librarianMembersInventory;
        String[][] naturalMembersInventory = lockRunn.naturalMembersInventory;
        this.buildReportData(empties, membersInventory, librarianMembersInventory, naturalMembersInventory, sumElem, showSummaryOnly);
        if (showSummaryOnly && this.resultList.isEmpty()) {
            Obj4MemberReport obj = new Obj4MemberReport("fake");
            this.resultList.add(obj);
        }
        this.parameters.put("color", "violet");
        MemberDataSource dataSource = new MemberDataSource(this.resultList, sumElem);
        StringBuilder inputRes = new StringBuilder();
        ArrayList types = new ArrayList(naturalMFLibsNames.keySet());
        Collections.sort(types);
        ArrayList sortedLibs = null;
        for (String type : types) {
            inputRes.append(type).append(": ");
            Set libs = (Set)naturalMFLibsNames.get(type);
            sortedLibs = new ArrayList(libs);
            Collections.sort(sortedLibs);
            inputRes.append(sortedLibs);
            inputRes.append("\n");
            inputRes.append("\n");
        }
        this.parameters.put("inputResources", inputRes.toString());
        this.parameters.put("appendixFirstLineValue", String.valueOf(selectedMFLibs.size()));
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
        monitor.done();
        return dataSource;
    }

    private void buildReportData(Set<MFLibraryInput> empties, String[][] membersInventory, String[][] librarianMembersInventory, String[][] naturalMembersInventory, ElementGroupInfo sumElem, boolean showSummaryOnly) {
        DSFactory factory = new DSFactory();
        BaseSubreportDataSource summaryDS = factory.createDS(0);
        ArrayList summaryList = new ArrayList();
        String repTotalsLbl = Messages.getString(ReportBuilder.class, "report.totals.lbl");
        summaryDS.setList(summaryList);
        summaryDS.setExtraTitle(repTotalsLbl);
        summaryDS.setTocEntry(repTotalsLbl);
        sumElem.addDataSource((SubreportDataSource)summaryDS);
        if (membersInventory != null || librarianMembersInventory != null || naturalMembersInventory != null) {
            MFLibrariesResult generalResult = new MFLibrariesResult();
            this.computeMFResults(generalResult, membersInventory, false, false, empties);
            this.computeMFResults(generalResult, librarianMembersInventory, false, true, empties);
            this.computeMFResults(generalResult, naturalMembersInventory, true, false, empties);
            String totalMemberLbl = Messages.getString(ReportBuilder.class, "total.member.lbl");
            String totalLinesLbl = Messages.getString(ReportBuilder.class, "total.lines.lbl");
            String totalLinExcludeNat = Messages.getString(ReportBuilder.class, "total.lines.exnat.lbl");
            String librariesLbl = Messages.getString(ReportBuilder.class, "libraries.lbl");
            Utils.makeGenericEntry(summaryList, (String)librariesLbl, (Object)("" + generalResult.summaryResult.size()), (String)this.summaryElementKey);
            if (!empties.isEmpty()) {
                String lblNoMembers = Messages.getString(ReportBuilder.class, "libraries.noMembers.lbl");
                Utils.makeGenericEntry(summaryList, (String)lblNoMembers, (Object)("" + empties.size()), (String)this.summaryElementKey);
            }
            if (membersInventory != null) {
                String lbl = naturalMembersInventory != null ? totalLinExcludeNat : totalLinesLbl;
                Utils.makeGenericEntry(summaryList, (String)lbl, (Object)generalResult.totalLines.toString(), (String)this.summaryElementKey);
            }
            Utils.makeGenericEntry(summaryList, (String)totalMemberLbl, (Object)generalResult.totalMembers.toString(), (String)this.summaryElementKey);
            String memTypeLbl = Messages.getString(ReportBuilder.class, "member.type.lbl");
            String countLbl = Messages.getString(ReportBuilder.class, "count.lbl");
            String linesLbl = Messages.getString(ReportBuilder.class, "total.lines.table.lbl");
            ArrayList<Object4TestReport> list = new ArrayList<Object4TestReport>();
            for (String type : generalResult.typesResult.keySet()) {
                Pair<Integer, Integer> valuesPerType = generalResult.typesResult.get(type);
                Object4TestReport o = new Object4TestReport();
                o.setLeftExpresion(type);
                o.setMiddleExpresion(((Integer)valuesPerType.getFirst()).toString());
                if (valuesPerType.getSecond() != null) {
                    o.setRightExpresion(((Integer)valuesPerType.getSecond()).toString());
                }
                list.add(o);
            }
            if (!list.isEmpty()) {
                Collections.sort(list, new TableEntriesComparator());
                SC3TableDataSource ds = new SC3TableDataSource(memTypeLbl, countLbl, linesLbl, list);
                sumElem.addDataSource((SubreportDataSource)ds);
            }
            if (generalResult.summaryResult.size() > 1) {
                for (MFLibraryInput lib : generalResult.summaryResult.keySet()) {
                    Map<String, Pair<Integer, Integer>> types = generalResult.summaryResult.get(lib);
                    Integer totalMembersPerLib = new Integer(0);
                    Integer totalLinesPerLib = null;
                    summaryDS = factory.createDS(0);
                    summaryList = new ArrayList();
                    summaryDS.setList(summaryList);
                    String summaryLibraryTitle = Messages.getString(ReportBuilder.class, "library.summary.section.title", new String[]{lib.getListableName(), lib.getTypeText()});
                    summaryDS.setExtraTitle(summaryLibraryTitle);
                    summaryDS.setTocEntry(lib.getListableName());
                    sumElem.addDataSource((SubreportDataSource)summaryDS);
                    list = new ArrayList();
                    for (String type : types.keySet()) {
                        Pair<Integer, Integer> values = types.get(type);
                        totalMembersPerLib = totalMembersPerLib + (Integer)values.getFirst();
                        if (values.getSecond() != null) {
                            totalLinesPerLib = totalLinesPerLib == null ? new Integer((Integer)values.getSecond()) : Integer.valueOf(totalLinesPerLib + (Integer)values.getSecond());
                        }
                        Object4TestReport o = new Object4TestReport();
                        o.setLeftExpresion(type);
                        o.setMiddleExpresion(((Integer)values.getFirst()).toString());
                        if (values.getSecond() != null) {
                            o.setRightExpresion(((Integer)values.getSecond()).toString());
                        }
                        list.add(o);
                    }
                    if (!list.isEmpty()) {
                        Collections.sort(list, new TableEntriesComparator());
                        SC3TableDataSource ds = new SC3TableDataSource(memTypeLbl, countLbl, linesLbl, list);
                        sumElem.addDataSource((SubreportDataSource)ds);
                    }
                    Utils.makeGenericEntry(summaryList, (String)totalMemberLbl, (Object)totalMembersPerLib.toString(), (String)this.summaryElementKey);
                    if (totalLinesPerLib == null) continue;
                    Utils.makeGenericEntry(summaryList, (String)totalLinesLbl, (Object)totalLinesPerLib.toString(), (String)this.summaryElementKey);
                }
            }
            if (!empties.isEmpty()) {
                SC2DataSourceWithGroup empty = this.buildEmptyLibsList(empties, factory);
                empty.setExtraTitle(Messages.getString(ReportBuilder.class, "emptyLibraries.summary.title"));
                empty.setCol1Name(Messages.getString(ReportBuilder.class, "emptyLibraries.column1Title"));
                empty.setCol2Name("");
                sumElem.addDataSource((SubreportDataSource)empty);
            }
            if (!showSummaryOnly) {
                for (MFLibraryInput lib : this.detailsDS.keySet()) {
                    ElementGroupInfo elemDetails = new ElementGroupInfo(lib.getListableName());
                    SubreportDataSource ds = (SubreportDataSource)this.detailsDS.get(lib);
                    List dsList = ((SC2DataSourceWithGroup)ds).getList();
                    Collections.sort(dsList, new LibraryDetailsComparator());
                    elemDetails.addDataSource(ds);
                    Obj4MemberReport obj = new Obj4MemberReport(lib, elemDetails);
                    this.resultList.add(obj);
                }
            }
        } else if (!empties.isEmpty()) {
            String lblNoMembers = Messages.getString(ReportBuilder.class, "libraries.noMembers.lbl");
            Utils.makeGenericEntry(summaryList, (String)lblNoMembers, (Object)("" + empties.size()), (String)this.summaryElementKey);
            SC2DataSourceWithGroup empty = this.buildEmptyLibsList(empties, factory);
            empty.setExtraTitle(Messages.getString(ReportBuilder.class, "emptyLibraries.summary.title"));
            empty.setCol1Name(Messages.getString(ReportBuilder.class, "emptyLibraries.column1Title"));
            empty.setCol2Name("");
            sumElem.addDataSource((SubreportDataSource)empty);
            Obj4MemberReport obj = new Obj4MemberReport("fake");
            this.resultList.add(obj);
        }
    }

    private SC2DataSourceWithGroup buildEmptyLibsList(Set<MFLibraryInput> empties, DSFactory factory) {
        SC2DataSourceWithGroup ds = (SC2DataSourceWithGroup)factory.createDS(2);
        ArrayList<ObjectForSubreport> dsList = new ArrayList<ObjectForSubreport>();
        ds.setList(dsList);
        for (MFLibraryInput lib : empties) {
            String[] results = new String[]{"", lib.getTypeText(), lib.getListableName(), ""};
            ObjectForSubreport obj = factory.createObj(2, results, memberTypeLbl);
            dsList.add(obj);
        }
        Collections.sort(dsList, new LibraryDetailsComparator());
        return ds;
    }

    private void computeMFResults(MFLibrariesResult generalResult, String[][] membersInventory, boolean isNaturalLib, boolean isLibrarianLib, Set<MFLibraryInput> empties) {
        if (membersInventory == null) {
            return;
        }
        DSFactory factory = new DSFactory();
        MFLibraryInput libInput = null;
        Set inpts = (Set)this.report.getProperty("inputs");
        int i = 0;
        while (i < membersInventory.length) {
            ArrayList<ObjectForSubreport> detailList;
            Integer lines;
            Integer lines2;
            String[] memberInfo = membersInventory[i];
            String libName = memberInfo[0];
            String memberName = memberInfo[1];
            String memberType = memberInfo[2];
            String numberOfLines = null;
            if (libInput == null || !libInput.getListableName().equalsIgnoreCase(libName)) {
                for (MFLibraryInput libraryInput : inpts) {
                    if (!libName.equalsIgnoreCase(libraryInput.getListableName()) || !(isLibrarianLib && libraryInput.isLibrarianLibrary() || isNaturalLib && libraryInput.isNaturalLibrary()) && (isLibrarianLib || isNaturalLib || libraryInput.isLibrarianLibrary() || libraryInput.isNaturalLibrary())) continue;
                    libInput = libraryInput;
                    break;
                }
            }
            if (libInput == null) {
                L.warn("no input found for libName={}", (Object)libName);
                libInput = new MFLibraryInput(libName, "", "UNDEF");
            } else if (empties != null) {
                empties.remove(libInput);
            }
            if (isNaturalLib) {
                memberType = Messages.getString(ReportBuilder.class, "natural.typeName", new String[]{memberType});
            } else if (!isLibrarianLib) {
                numberOfLines = memberInfo[3];
                memberType = this.getTypeName(memberType);
            }
            L.debug("libName {}; memberName {}; memberType {}; numberOfLines {}", new Object[]{libName, memberName, memberType, numberOfLines});
            Map<String, Pair<Integer, Integer>> types = generalResult.summaryResult.get(libInput);
            Pair values = null;
            if (types == null) {
                types = new HashMap<String, Pair<Integer, Integer>>();
                generalResult.summaryResult.put(libInput, types);
                lines2 = numberOfLines != null ? new Integer(numberOfLines) : null;
                values = new Pair((Object)new Integer(1), (Object)lines2);
                generalResult.totalMembers = generalResult.totalMembers + 1;
                if (lines2 != null) {
                    generalResult.totalLines = generalResult.totalLines + lines2;
                }
                types.put(memberType, (Pair<Integer, Integer>)values);
            } else {
                values = types.get(memberType);
                if (values == null) {
                    lines2 = numberOfLines != null ? new Integer(numberOfLines) : null;
                    values = new Pair((Object)new Integer(1), (Object)lines2);
                    generalResult.totalMembers = generalResult.totalMembers + 1;
                    if (lines2 != null) {
                        generalResult.totalLines = generalResult.totalLines + lines2;
                    }
                    types.put(memberType, (Pair<Integer, Integer>)values);
                } else {
                    values.setFirst((Object)((Integer)values.getFirst() + 1));
                    generalResult.totalMembers = generalResult.totalMembers + 1;
                    Integer n = lines2 = numberOfLines != null ? new Integer(numberOfLines) : null;
                    if (lines2 != null) {
                        values.setSecond((Object)((Integer)values.getSecond() + lines2));
                        generalResult.totalLines = generalResult.totalLines + lines2;
                    }
                    types.put(memberType, (Pair<Integer, Integer>)values);
                }
            }
            Pair valuesPerType = generalResult.typesResult.get(memberType);
            if (valuesPerType == null) {
                lines = numberOfLines != null ? new Integer(numberOfLines) : null;
                valuesPerType = new Pair((Object)new Integer(1), (Object)lines);
                generalResult.typesResult.put(memberType, (Pair<Integer, Integer>)valuesPerType);
            } else {
                valuesPerType.setFirst((Object)((Integer)valuesPerType.getFirst() + 1));
                Integer n = lines = numberOfLines != null ? new Integer(numberOfLines) : null;
                if (lines != null) {
                    valuesPerType.setSecond((Object)((Integer)valuesPerType.getSecond() + lines));
                }
            }
            SC2DataSourceWithGroup detailDS = (SC2DataSourceWithGroup)this.detailsDS.get(libInput);
            if (detailDS == null) {
                detailDS = (SC2DataSourceWithGroup)factory.createDS(2);
                detailDS.setTitle(memberListingLbl);
                this.detailsDS.put(libInput, detailDS);
            }
            if ((detailList = detailDS.getList()) == null) {
                detailList = new ArrayList<ObjectForSubreport>();
                detailDS.setList(detailList);
            }
            String[] results = new String[]{libName, memberType, memberName, numberOfLines};
            if (this.csvWriter != null) {
                this.csvWriter.write(new String[]{libName, memberType, memberName, numberOfLines});
            }
            ObjectForSubreport obj = factory.createObj(2, results, memberTypeLbl);
            detailList.add(obj);
            ++i;
        }
    }

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "computeParameters.process.name"));
        this.addLocaleParameter(this.parameters);
        this.putExternalizedParameters(this.parameters);
        this.parameters.put("separateColumn", false);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"/reports/subBase.jasper", (String)"subBaseTemplate", (Map)this.parameters);
        monitor.worked(100);
        return this.parameters;
    }

    private void putExternalizedParameters(Map params) {
        String externalized = null;
        boolean showInputs = (Boolean)this.getReportModel().getProperty("showInputDetails");
        Boolean showAppendix = (Boolean)this.getReportModel().getProperty("show appendix");
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        if (showSummaryOnly) {
            externalized = Messages.getString(ReportBuilder.class, "onlySummaryReport.title");
            params.put("report.title", externalized);
            params.put("showInputs", Boolean.TRUE.equals(showAppendix) ? showInputs : Boolean.FALSE);
            params.put("showTOC", Boolean.FALSE);
        } else {
            externalized = Messages.getString(ReportBuilder.class, "report.title");
            params.put("report.title", externalized);
            params.put("showInputs", showInputs);
            params.put("showTOC", Boolean.TRUE);
        }
        params.put("showAppendix", showAppendix);
        externalized = Messages.getString(ReportBuilder.class, "group1.name");
        params.put("group1.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "member.name");
        params.put("stmt.name.lbl", externalized);
        externalized = Messages.getString(ReportBuilder.class, "number.of.lines");
        params.put("stmt.occurrences.lbl", externalized);
    }

    protected String getReportTemplatePath() {
        return "reports/membersReport.jasper";
    }

    private String getTypeName(String shortType) {
        String ret = shortType;
        if ("UNDEF".equalsIgnoreCase(shortType) || "UND".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "undefinedType.name");
        } else if ("COB".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "cobolProgram.typeName");
        } else if ("PLI".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "pl1Program.typeName");
        } else if ("NAT".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "naturalProgram.typeName");
        } else if ("JOB".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "job.typeName");
        } else if ("DBD".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "imsDbd.typeName");
        } else if ("SQL".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "sqlDclGen.typeName");
        } else if ("BMS".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "cicsMap.typeName");
        } else if ("MFS".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "imsMap.typeName");
        } else if ("PSB".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "imsPsb.typeName");
        } else if ("PRC".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "proc.typeName");
        } else if ("PCP".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "pl1Copybook.typeName");
        } else if ("CCP".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "declarativeCobolInclude.typeName");
        } else if ("ASM".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "assembler.typeName");
        } else if ("JCL".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "jcl.typeName");
        } else if ("END".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "end.typeName");
        } else if ("CIN".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "functionalCobolInclude.typeName");
        } else if ("MAC".equalsIgnoreCase(shortType)) {
            ret = Messages.getString(ReportBuilder.class, "assemblerMacro.typeName");
        }
        return ret;
    }

    public void cleanMemory() {
        if (this.detailsDS != null) {
            this.detailsDS.clear();
            this.detailsDS = null;
        }
        if (this.resultList != null) {
            this.resultList.clear();
            this.resultList = null;
        }
        super.cleanMemory();
    }

    private class LibraryDetailsComparator
    implements Comparator {
        private LibraryDetailsComparator() {
        }

        public int compare(Object obj, Object obj1) {
            int result = 0;
            if (obj != null && obj1 != null) {
                String memberType1;
                ObjectForSubreport res = (ObjectForSubreport)obj;
                ObjectForSubreport res1 = (ObjectForSubreport)obj1;
                String memberType = res.getElGroup();
                result = memberType.compareTo(memberType1 = res1.getElGroup());
                if (result == 0) {
                    result = res.getExp().compareTo(res1.getExp());
                }
            }
            return result;
        }
    }

    private class MFLibrariesResult {
        Integer totalMembers = new Integer(0);
        Integer totalLines = new Integer(0);
        TreeMap<MFLibraryInput, Map<String, Pair<Integer, Integer>>> summaryResult = new TreeMap();
        Map<String, Pair<Integer, Integer>> typesResult = new HashMap<String, Pair<Integer, Integer>>();

        private MFLibrariesResult() {
        }
    }

    private class RunwithLock
    implements IMFRunnable {
        Set<MFLibraryInput> simpleMFLibs;
        Set<MFLibraryInput> librarianMFLibs;
        Set<MFLibraryInput> naturalMFLibs;
        String[][] membersInventory = null;
        String[][] librarianMembersInventory = null;
        String[][] naturalMembersInventory = null;

        public RunwithLock(Set<MFLibraryInput> simpleMFLibs, Set<MFLibraryInput> librarianMFLibs, Set<MFLibraryInput> naturalMFLibs) {
            this.simpleMFLibs = simpleMFLibs;
            this.librarianMFLibs = librarianMFLibs;
            this.naturalMFLibs = naturalMFLibs;
        }

        public void run(EZSourceConnection conn, IProgressMonitor monitor) {
            try {
                List<EZSourceDataType> types;
                if (!this.simpleMFLibs.isEmpty()) {
                    types = Arrays.asList(new EZSourceDataType[this.simpleMFLibs.size()]);
                    Collections.fill(types, EZSourceDataType.Integer);
                    this.membersInventory = conn.execNonTransactionalStoredProc(ReportBuilder.MEMBER_INVENTORY_SP, new String[0], types, new ArrayList<MFLibraryInput>(this.simpleMFLibs));
                }
                if (!this.librarianMFLibs.isEmpty()) {
                    types = Arrays.asList(new EZSourceDataType[this.librarianMFLibs.size()]);
                    Collections.fill(types, EZSourceDataType.Integer);
                    this.librarianMembersInventory = conn.execNonTransactionalStoredProc(ReportBuilder.LIBRARIAN_MEMBER_INVENTORY_SP, new String[0], types, new ArrayList<MFLibraryInput>(this.librarianMFLibs));
                }
                if (!this.naturalMFLibs.isEmpty()) {
                    types = Arrays.asList(new EZSourceDataType[this.naturalMFLibs.size()]);
                    Collections.fill(types, EZSourceDataType.Integer);
                    this.naturalMembersInventory = conn.execNonTransactionalStoredProc(ReportBuilder.NATURAL_MEMBER_INVENTORY_SP, new String[0], types, new ArrayList<MFLibraryInput>(this.naturalMFLibs));
                }
            }
            catch (EZSourceConnectionException e) {
                L.error("exception at executing stored procedure", (Throwable)e);
            }
        }
    }

    private class TableEntriesComparator
    implements Comparator {
        private TableEntriesComparator() {
        }

        public int compare(Object obj, Object obj1) {
            int result = 0;
            if (obj != null && obj1 != null) {
                Object4TestReport res = (Object4TestReport)obj;
                Object4TestReport res1 = (Object4TestReport)obj1;
                String memberType = res.getLeftExpresion();
                String memberType1 = res1.getLeftExpresion();
                result = memberType.compareTo(memberType1);
            }
            return result;
        }
    }
}

