/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.membersInventory;

import com.ez.common.ui.listselection.Listable;
import com.ez.report.application.ui.PluginImages;
import com.ez.report.application.utils.Utils;
import java.io.Serializable;
import org.eclipse.jface.resource.ImageDescriptor;

public class MFLibraryInput
implements Listable,
Serializable,
Comparable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 1L;
    private String name;
    private String mfLibID = null;
    private String libType;
    private boolean isNaturalLibrary = false;
    private boolean isLibrarianLibrary = false;

    public MFLibraryInput(String name, String mfLibID) {
        this.name = name;
        this.mfLibID = mfLibID;
    }

    public MFLibraryInput(String name, String mfLibID, String libType) {
        this(name, mfLibID);
        this.libType = "UNDEF".equalsIgnoreCase(libType) ? "Undefined" : libType;
        if ("LIBRARIAN".equalsIgnoreCase(libType)) {
            this.isLibrarianLibrary = true;
        }
    }

    public String getListableName() {
        return this.name;
    }

    public String toString() {
        return this.mfLibID;
    }

    public String getMFLibID() {
        return this.mfLibID;
    }

    public boolean isNaturalLibrary() {
        return this.isNaturalLibrary;
    }

    public void setNaturalLibrary(boolean isNaturalLibrary) {
        this.isNaturalLibrary = isNaturalLibrary;
    }

    public boolean isLibrarianLibrary() {
        return this.isLibrarianLibrary;
    }

    public void setLibType(String libType) {
        this.libType = libType == null ? "" : libType;
    }

    public int compareTo(Object o) {
        int res = 0;
        if (o instanceof MFLibraryInput) {
            res = this.name.compareTo(((MFLibraryInput)o).name);
            if (res == 0 && this.mfLibID.compareTo(((MFLibraryInput)o).mfLibID) != 0) {
                res = -this.mfLibID.compareTo(((MFLibraryInput)o).mfLibID);
            }
            if (res == 0 && (this.isNaturalLibrary && !((MFLibraryInput)o).isNaturalLibrary || !this.isNaturalLibrary && ((MFLibraryInput)o).isNaturalLibrary)) {
                res = this.isNaturalLibrary ? 1 : -1;
            }
        }
        return res;
    }

    public String getTypeText() {
        return Utils.getExternalizedType4Library((Integer)this.getTypeCode());
    }

    public Integer getTypeCode() {
        return Utils.getIntegerLibType((String)this.libType);
    }

    public boolean hasType() {
        return !this.libType.isEmpty();
    }

    public ImageDescriptor getTypeImageDescriptor() {
        return PluginImages.getDescriptor4Library((Integer)this.getTypeCode());
    }
}

