/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.membersInventory;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.report.application.ezreport.reports.summary.membersInventory.MFLibraryInput;
import com.ez.report.application.ui.PluginImages;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import com.ez.report.application.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFLibraryCollector
extends BridgeResourcesCollectorAdapter<MFLibraryInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MFLibraryCollector.class);
    private String mfLibrariesQuery = "SELECT MFLibraries.LibraryID, MFLibraries.LibraryName, Types.TypeVal FROM MFLibraries INNER JOIN MFLibTypes Types ON MFLibraries.LibType = Types.LibTypeID WHERE (MFLibraries.LibraryID <> - 1) AND (MFLibraries.Scanned=1) ORDER BY MFLibraries.LibraryName";
    private String mfNaturalLibrariesQuery = "select LibID, LibraryName from MFNaturalLibraries order by LibraryName";
    List<ImageObj4Wizard> imagesObjsList;

    public List<MFLibraryInput> collect(boolean useFilters, Set<String> apps, EZSourceConnection bridge) {
        List<MFLibraryInput> libs = this.getAvailableMFLibraries(bridge);
        ArrayList<Integer> availableTypes = new ArrayList<Integer>();
        this.imagesObjsList = new ArrayList<ImageObj4Wizard>();
        for (MFLibraryInput inpt : libs) {
            Integer type = inpt.getTypeCode();
            if (availableTypes.contains(type)) continue;
            String textType = Utils.getExternalizedType4Library((Integer)type);
            ImageDescriptor imageDesc = PluginImages.getDescriptor4Library((Integer)type);
            ImageObj4Wizard imageObj = new ImageObj4Wizard(type, textType, imageDesc);
            this.imagesObjsList.add(imageObj);
            availableTypes.add(type);
        }
        return libs;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return this.imagesObjsList;
    }

    private List<MFLibraryInput> getAvailableMFLibraries(EZSourceConnection conn) {
        ArrayList<MFLibraryInput> availableMFLibs = new ArrayList<MFLibraryInput>();
        try {
            String[][] mfNaturalLibraries;
            String[][] mfLibraries = conn.executeSQL(this.mfLibrariesQuery);
            if (mfLibraries != null) {
                MFLibraryInput inpt = null;
                int i = 0;
                while (i < mfLibraries.length) {
                    L.debug("library name: {}", (Object)mfLibraries[i][1]);
                    if (mfLibraries[i][0] != null) {
                        inpt = new MFLibraryInput(mfLibraries[i][1], mfLibraries[i][0], mfLibraries[i][2]);
                        availableMFLibs.add(inpt);
                    }
                    ++i;
                }
            }
            if ((mfNaturalLibraries = conn.executeSQL(this.mfNaturalLibrariesQuery)) != null) {
                MFLibraryInput inpt = null;
                int i = 0;
                while (i < mfNaturalLibraries.length) {
                    L.debug("natural library name: {}", (Object)mfNaturalLibraries[i][1]);
                    if (mfNaturalLibraries[i][0] != null && !mfNaturalLibraries[i][0].equals("-1")) {
                        inpt = new MFLibraryInput(mfNaturalLibraries[i][1], mfNaturalLibraries[i][0], "NATURAL");
                        inpt.setNaturalLibrary(true);
                        availableMFLibs.add(inpt);
                    }
                    ++i;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return availableMFLibs;
    }
}

