/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.ddclProjectInventory;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.report.application.ezreport.reports.summary.ddclProjectInventory.DataSource;
import com.ez.report.application.ezreport.reports.summary.ddclProjectInventory.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.SingleQueryResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends com.ez.report.application.ezreport.reports.summary.projectInventory.ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    String query = "select DDCLElement.id, DDCLElement.Name, DDCLElement.DdsTypeId, DDCLDdsType.name from DDCLElement join DDCLDdsType on DDCLElement.DdsTypeId=DDCLDdsType.id where DDCLElement.isLocal='false' and DDCLDdsType.id > 0 order by DDCLDdsType.name, DDCLElement.Name";

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected AbstractReport buildModel() {
        return new ReportModel(this.project, true);
    }

    @Override
    protected DataSource buildDSObject(Boolean showOnlySummary, CSVWriter csvWriter) {
        return new DataSource(showOnlySummary != null ? showOnlySummary : false, csvWriter);
    }

    @Override
    protected Map<String, List<ProgramInputNoGUI>> getData(IProgressMonitor pmonitor) {
        this.clearForJasperReport();
        HashMap<String, List<ProgramInputNoGUI>> results = new HashMap<String, List<ProgramInputNoGUI>>();
        SingleQueryResult queryResult = this.querySQLForData(this.query, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pmonitor, (int)100));
        String[][] res = queryResult.data;
        if (res == null || res.length == 0) {
            L.warn("project has no DDCL elements!");
        } else {
            int i = 0;
            while (i < res.length) {
                Integer idElem = new Integer(Integer.parseInt(res[i][0]));
                String elemName = res[i][1];
                Integer idElemType = new Integer(Integer.parseInt(res[i][2]));
                String elemTypeName = res[i][3];
                ArrayList<ProgramInputNoGUI> prgs = (ArrayList<ProgramInputNoGUI>)results.get(elemTypeName);
                if (prgs == null) {
                    prgs = new ArrayList<ProgramInputNoGUI>();
                    results.put(elemTypeName, prgs);
                }
                prgs.add(new ProgramInputNoGUI(elemName, idElemType, idElem));
                ++i;
            }
        }
        return results;
    }
}

