/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.ddclElementInventory;

import com.ez.common.model.BaseResourceInput;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.ErrorUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.ApplicationElementsOfTpServiceCollector;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.DBResults;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.DDCLElementsVsCollector;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.DDCLInventoryDataSource;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.DialogueElementsOfApplicationCollector;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.ElementsUsingFilesCollector;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.ElementsUsingRecordsCollector;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.ElementsUsingScreensCollector;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.ElementsUsingSetsCollector;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.ReportModel;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.TaskElementsOfApplicationCollector;
import com.ez.report.application.ezreport.utils.Utils;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.utils.ReportsUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends com.ez.report.application.ezreport.reports.summary.programSummary.ReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    protected AbstractReport buildModelObj() {
        return new ReportModel(this.project, this.getSelectionFlagFromInputs());
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        HashMap<DDCLElementInput, ElementGroupInfo> inputPrgMap = new HashMap<DDCLElementInput, ElementGroupInfo>();
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        for (DDCLElementInput prg : prgList) {
            String prgName = prg.getName();
            String prgType = prg.getTypeText().toLowerCase();
            inputPrgMap.put(prg, new ElementGroupInfo(prgName, prgType));
        }
        DDCLInventoryDataSource dataSource = new DDCLInventoryDataSource(inputPrgMap, showSummaryOnly, csvWriter);
        dataSource.setData(this.data((IProgressMonitor)monitor));
        if (csvWriter != null) {
            csvWriter.close();
        }
        monitor.done();
        return dataSource;
    }

    @Override
    protected StoredProcedureResults data(IProgressMonitor pmonitor) {
        this.clearForJasperReport();
        int selectedPrgNo = 0;
        Collection selected = this.getSelected();
        if (selected != null) {
            selectedPrgNo = selected.size();
        }
        Set prgList = (Set)this.getReportModel().getProperty("inputs");
        this.parameters.put("appendixFirstLineValue", String.valueOf(prgList.size()));
        this.buildInputs4Appendix(prgList);
        this.parameters.put("color", "blue");
        DBResults spr = new DBResults();
        if (selectedPrgNo == 0) {
            L.warn("no results for DDCL Element Inventory Report");
        } else {
            this.extractDBData(pmonitor, spr);
        }
        return spr;
    }

    private void extractDBData(IProgressMonitor pmonitor, final DBResults spr) {
        L.debug("DDCL Element Inventory results:");
        IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    ReportBuilder.this.queryStep = 0;
                    boolean selective = !ReportBuilder.this.report.useAllResources();
                    DDCLElementsVsCollector collector = new ElementsUsingScreensCollector(selective);
                    Collection ids = ReportBuilder.this.filterSelectedIDs();
                    String[][] results = collector.compute(pmonitor, ids, conn);
                    if (results != null) {
                        spr.setResultsPrgsVSInclude(results);
                    }
                    ReportBuilder.this.queryStep = 1;
                    collector = new ElementsUsingRecordsCollector(true);
                    results = collector.compute(pmonitor, ids, conn);
                    if (results != null) {
                        spr.setResultsIDMSRecord(results);
                    }
                    ReportBuilder.this.queryStep = 2;
                    collector = new ElementsUsingSetsCollector(selective);
                    results = collector.compute(pmonitor, ids, conn);
                    if (results != null) {
                        spr.setResultsIDMSSet(results);
                    }
                    ReportBuilder.this.queryStep = 3;
                    collector = new ElementsUsingFilesCollector(selective);
                    results = collector.compute(pmonitor, ids, conn);
                    if (results != null) {
                        spr.setResultsPrgVSFiles(results);
                    }
                    ReportBuilder.this.queryStep = 4;
                    collector = new DialogueElementsOfApplicationCollector(selective);
                    results = collector.compute(pmonitor, ids, conn);
                    if (results != null) {
                        spr.resultsDialoguesOfApp = results;
                    }
                    ReportBuilder.this.queryStep = 5;
                    collector = new TaskElementsOfApplicationCollector(selective);
                    results = collector.compute(pmonitor, ids, conn);
                    if (results != null) {
                        spr.resultsTasksOfApp = results;
                    }
                    ReportBuilder.this.queryStep = 6;
                    collector = new ApplicationElementsOfTpServiceCollector(selective);
                    results = collector.compute(pmonitor, ids, conn);
                    if (results != null) {
                        spr.resultsAppsOfTpService = results;
                    }
                    pmonitor.subTask("");
                }
            }, LockType.Shared, pmonitor);
        }
        catch (InterruptedException interruptedException) {
            throw new CanceledException("connection interrupted");
        }
        catch (ExecutionException e) {
            ErrorUtils.handleExecutionException((ExecutionException)e);
        }
    }

    protected Collection filterSelectedIDs() {
        if (this.selectedIds == null) {
            this.selectedIds = Utils.getIDs(this.getSelected());
        }
        return this.selectedIds;
    }

    @Override
    protected String getQuery4CountEntries() {
        return "select count(DDCLElement.id) from DDCLElement where DDCLElement.isLocal='false' and DDCLElement.DdsTypeId in (11,16,24,25,26,27,28) ";
    }

    @Override
    protected void customizeJasperPrint(JasperPrint print) {
        List pages;
        if (print != null && (pages = print.getPages()) != null && pages.size() > 0) {
            ReportsUtils.removeEmptyPages((List)pages, (String)"DDDCL elements inventory", (boolean)true);
        }
    }

    protected void buildInputs4Appendix(Set<? extends BaseResourceInput> prgList) {
        super.buildInputs4Appendix(prgList);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.ddcl"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.resourceType"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.resourceName")});
        }
    }
}

