/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.ddclElementInventory;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.DDCLElementsVsCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementsUsingScreensCollector
extends DDCLElementsVsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ElementsUsingScreensCollector.class);

    public ElementsUsingScreensCollector(boolean selective) {
        this.isSelective = selective;
        this.considerChildrens = false;
    }

    @Override
    public String[][] compute(IProgressMonitor monitor, Collection<Integer> ids, EZSourceConnection conn) {
        String[][] no = null;
        monitor.subTask(Messages.getString(ElementsUsingScreensCollector.class, "monitor.executingquery.subtask"));
        String procName = this.isSelective ? "EZReports_DDCLUsingScreens_Selective" : "EZReports_DDCLUsingScreens";
        try {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            no = conn.execNonTransactionalStoredProc(procName, new String[0], types, new ArrayList<Integer>(ids));
        }
        catch (EZSourceConnectionException e) {
            L.error("exception at executing stored procedure", (Throwable)e);
            EZReportErrorLog.err(Messages.getString(ElementsUsingScreensCollector.class, "storedProcedureError.logMessage", new String[]{procName}), e);
        }
        monitor.subTask(Messages.getString(ElementsUsingScreensCollector.class, "monitor.preparingdata.subtask"));
        String[][] result = null;
        if (no != null) {
            ArrayList<String[]> res = new ArrayList<String[]>();
            HashMap<String, Integer> temp = new HashMap<String, Integer>();
            String prevProgram = null;
            int i = 0;
            while (i < no.length) {
                String prgName = no[i][0];
                String inclName = no[i][1];
                String stmtCount = no[i][2];
                String parentName = "";
                L.debug("element: {}", (Object)prgName);
                L.debug("numberOfValues value: {}", (Object)stmtCount);
                L.debug("\n");
                if (Utils.filterNullValue((String)parentName) == null || parentName.isEmpty()) {
                    this.storeData(res, temp, prevProgram);
                    prevProgram = null;
                    temp = null;
                    res.add(no[i]);
                } else {
                    String name;
                    String string = name = this.considerChildrens ? String.valueOf(parentName) + ": " + prgName : parentName;
                    if (name.equalsIgnoreCase(prevProgram)) {
                        Integer v = (Integer)temp.get(inclName);
                        if (v == null) {
                            v = new Integer(0);
                        }
                        v = new Integer(v + Integer.valueOf(stmtCount));
                        temp.put(inclName, v);
                    } else {
                        this.storeData(res, temp, prevProgram);
                        prevProgram = name;
                        temp = new HashMap();
                        temp.put(inclName, Integer.valueOf(stmtCount));
                    }
                }
                ++i;
            }
            this.storeData(res, temp, prevProgram);
            prevProgram = null;
            temp = null;
            result = (String[][])res.toArray((T[])new String[0][]);
        }
        return result;
    }

    private void storeData(Collection<String[]> res, Map<String, Integer> temp, String prevProgram) {
        if (prevProgram != null) {
            ArrayList<String> includes = new ArrayList<String>(temp.keySet());
            Collections.sort(includes);
            for (String include : includes) {
                String[] v = new String[]{prevProgram, include, temp.get(include).toString()};
                res.add(v);
            }
        }
    }
}

