/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.ddclElementInventory;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.DDCLElementsVsCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementsUsingFilesCollector
extends DDCLElementsVsCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ElementsUsingFilesCollector.class);

    public ElementsUsingFilesCollector(boolean selective) {
        this.isSelective = selective;
        this.considerChildrens = false;
    }

    @Override
    public String[][] compute(IProgressMonitor monitor, Collection<Integer> ids, EZSourceConnection conn) {
        String[][] results = null;
        monitor.subTask(Messages.getString(ElementsUsingFilesCollector.class, "monitor.subtask"));
        String procName = this.isSelective ? "EZReports_DDCLUsingFiles_Selective" : "EZReports_DDCLUsingFiles";
        try {
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            results = conn.execNonTransactionalStoredProc(procName, new String[0], types, new ArrayList<Integer>(ids));
        }
        catch (EZSourceConnectionException e) {
            L.error("exception at executing stored procedure", (Throwable)e);
            EZReportErrorLog.err(Messages.getString(ElementsUsingFilesCollector.class, "storedProcedureError.logMessage", new String[]{procName}), e);
        }
        return results;
    }
}

