/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.ddclElementInventory;

import com.ez.common.model.BaseResourceInput;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.SummaryGenericDataSource;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.DBResults;
import com.ez.report.application.ezreport.reports.summary.ddclElementInventory.InputsSummaryComparator;
import com.ez.report.application.model.DDCLElementInput;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SC2DataSource;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDCLInventoryDataSource
extends SummaryGenericDataSource {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DDCLInventoryDataSource.class);
    private static final String listingDialogueTitle = Messages.getString(DDCLInventoryDataSource.class, "listing.dialogues.title");
    private static final String totalDialogueOccurencesLbl = Messages.getString(DDCLInventoryDataSource.class, "total.dialogues.occurences");
    private static final String dialogueTocEntry = Messages.getString(DDCLInventoryDataSource.class, "dialogues.tocEntry");
    private static final String tasksTocEntry = Messages.getString(DDCLInventoryDataSource.class, "tasks.tocEntry");
    private static final String listingTasksTitle = Messages.getString(DDCLInventoryDataSource.class, "listing.tasks.title");
    private static final String totalTasksOccurencesLbl = Messages.getString(DDCLInventoryDataSource.class, "total.tasks.occurences");
    private static final String listingAppsOfTpServiceTitle = Messages.getString(DDCLInventoryDataSource.class, "listing.appsInTpService.title");
    private static final String totalAppsOfTpServiceLbl = Messages.getString(DDCLInventoryDataSource.class, "total.appsInTpService.occurences");
    private static final String appsOfTpServiceTocEntry = Messages.getString(DDCLInventoryDataSource.class, "appsInTpService.tocEntry");
    private static final String dialogueNameString = Messages.getString(DDCLInventoryDataSource.class, "dialogue.name");
    private static final String taskNameString = Messages.getString(DDCLInventoryDataSource.class, "task.name");
    private static final String applicationNameString = Messages.getString(DDCLInventoryDataSource.class, "application.name");
    private String key4dialogueGlobalTotal = "totalAppDialogueNumber";
    private String key4TasksGlobalTotal = "totalAppTasksNumber";
    private String key4AppsFromTpServiceGlobalTotal = "totalTpServiceAppsNumber";
    private String splitConstant = "----";

    public DDCLInventoryDataSource(Map prgVsElemGroupMap, boolean showOnlySummary, CSVWriter csvWriter) {
        super(prgVsElemGroupMap, showOnlySummary, csvWriter);
        this.summaryExtraTitle = Messages.getString(DDCLInventoryDataSource.class, "summary.inputssection.extratitle");
        this.totalNoProgramsInReportLabel = Messages.getString(DDCLInventoryDataSource.class, "total.noPrograms.inreport");
        this.totalIncludeOccurencesLbl = Messages.getString(DDCLInventoryDataSource.class, "total.include.occurences");
        this.includeTocEntry = Messages.getString(DDCLInventoryDataSource.class, "screens.tocEntry");
        this.listingIncludeTitle = Messages.getString(DDCLInventoryDataSource.class, "listing.screens.title");
        this.totalIDMSRecordOccurencesLbl = Messages.getString(DDCLInventoryDataSource.class, "total.record.occurences");
        this.listingIdmsRecordTitle = Messages.getString(DDCLInventoryDataSource.class, "listing.record.title");
        this.idmsRecordTocEntry = Messages.getString(DDCLInventoryDataSource.class, "record.tocEntry");
        this.idmsRecordNameString = Messages.getString(DDCLInventoryDataSource.class, "record.name");
        this.idmsSetNameString = Messages.getString(DDCLInventoryDataSource.class, "set.name");
        this.idmsSetTocEntry = Messages.getString(DDCLInventoryDataSource.class, "sets.tocEntry");
        this.totalIDMSSetOccurencesLbl = Messages.getString(DDCLInventoryDataSource.class, "total.sets.occurences");
        this.listingIdmsSetTitle = Messages.getString(DDCLInventoryDataSource.class, "listing.sets.title");
        this.totalFileOccurencesLbl = Messages.getString(DDCLInventoryDataSource.class, "total.file.occurences");
    }

    @Override
    protected void init() {
        Set inputPrgSet = this.prgVsElemGroupMap.keySet();
        ArrayList inputPrgList = new ArrayList(inputPrgSet);
        if (!this.isOnlySummary()) {
            Collections.sort(inputPrgList);
        }
        int i = 0;
        while (i < inputPrgList.size()) {
            DDCLElementInput inpt = (DDCLElementInput)inputPrgList.get(i);
            if (!this.isOnlySummary()) {
                this.list.add(i, this.prgVsElemGroupMap.get(inpt));
            } else if (i == 0) {
                this.list.add(i, new ElementGroupInfo(null));
            }
            Integer nr = (Integer)this.prgByTypes.get(inpt.getTypeCode());
            if (nr == null) {
                nr = new Integer(0);
                this.prgByTypes.put(inpt.getTypeCode(), nr);
            }
            nr = nr + 1;
            this.prgByTypes.put(inpt.getTypeCode(), nr);
            ++i;
        }
    }

    @Override
    protected String getResourceTypesForSummary(Integer type) {
        return Utils.getExternalizedType4DDCLComponent((Integer)type);
    }

    @Override
    protected void setAdditionalData(StoredProcedureResults data) {
        DSFactory factory = new DSFactory();
        String[][] results = ((DBResults)data).resultsDialoguesOfApp;
        if (results == null) {
            L.warn("selected application elements has no dialogue elements");
        } else {
            this.fill(results, this.key4dialogueGlobalTotal, factory, 0, 1, null, listingDialogueTitle, totalDialogueOccurencesLbl, dialogueNameString, dialogueTocEntry);
            ((DBResults)data).resultsDialoguesOfApp = null;
        }
        results = ((DBResults)data).resultsTasksOfApp;
        if (results == null) {
            L.warn("selected application elements has no tasks elements");
        } else {
            this.fill(results, this.key4TasksGlobalTotal, factory, 0, 1, null, listingTasksTitle, totalTasksOccurencesLbl, taskNameString, tasksTocEntry);
            ((DBResults)data).resultsTasksOfApp = null;
        }
        results = ((DBResults)data).resultsAppsOfTpService;
        if (results == null) {
            L.warn("selected TpService elements has no Applications elements");
        } else {
            this.fill(results, this.key4AppsFromTpServiceGlobalTotal, factory, 0, 1, null, listingAppsOfTpServiceTitle, totalAppsOfTpServiceLbl, applicationNameString, appsOfTpServiceTocEntry);
            ((DBResults)data).resultsAppsOfTpService = null;
        }
    }

    @Override
    protected BaseResourceInput getProgramInput(String prgKey, Map prgVsElemGroupMap) {
        BaseResourceInput inpt = (BaseResourceInput)this.prgs.get(prgKey);
        if (inpt == null) {
            String type = null;
            String prgName = null;
            String[] parts = prgKey.split(this.splitConstant);
            if (parts.length == 2) {
                prgName = parts[0];
                type = parts[1];
            } else {
                prgName = prgKey;
            }
            for (BaseResourceInput prg : prgVsElemGroupMap.keySet()) {
                if (!prg.getName().equalsIgnoreCase(prgName)) continue;
                if (type == null) {
                    inpt = prg;
                    break;
                }
                if (!prg.getTypeCode().toString().equals(type)) continue;
                inpt = prg;
                break;
            }
            if (inpt != null) {
                this.prgs.put(prgKey, inpt);
            } else {
                L.warn("no prg input {}", (Object)prgKey);
            }
        }
        return inpt;
    }

    @Override
    protected String getProgramKey(String[] results) {
        String ret = results[0];
        try {
            Integer type = Integer.valueOf(results[results.length - 1]);
            ret = String.valueOf(ret) + this.splitConstant + type;
        }
        catch (Exception exception) {
            L.info("no type in {}", (Object)Arrays.toString(results));
        }
        return ret;
    }

    @Override
    protected SubreportDataSource getTotalSummaryDataSource(String appName) {
        ObjectForSubreport obj;
        SC2DataSource ds = (SC2DataSource)super.getTotalSummaryDataSource(appName);
        List list2 = ds != null ? ds.getList() : new ArrayList();
        String total = this.getTotal(appName, this.key4dialogueGlobalTotal);
        if (total != null) {
            obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(DDCLInventoryDataSource.class, "summary.dialogues.entry"));
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, this.key4TasksGlobalTotal)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(DDCLInventoryDataSource.class, "summary.tasks.entry"));
            obj.setExpVal(total);
            list2.add(obj);
        }
        if ((total = this.getTotal(appName, this.key4AppsFromTpServiceGlobalTotal)) != null) {
            obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(DDCLInventoryDataSource.class, "summary.applications.entry"));
            obj.setExpVal(total);
            list2.add(obj);
        }
        if (!list2.isEmpty() && ds == null) {
            ds = new SC2DataSource(null, list2);
        }
        return ds;
    }

    @Override
    protected void sortInputsSummarySubreport(List<ObjectForSubreport> lst) {
        InputsSummaryComparator comp = new InputsSummaryComparator();
        Collections.sort(lst, comp);
    }

    @Override
    protected String getTotalLabelPrgsByType(Integer prgType) {
        return Messages.getString(DDCLInventoryDataSource.class, "total.prgs.type.inreport", new String[]{this.getResourceTypesForSummary(prgType)});
    }

    @Override
    protected String getTotalLabelElementsByType(Integer type) {
        return Messages.getString(DDCLInventoryDataSource.class, "total.elements.byType.inSummary", new String[]{this.getResourceTypesForSummary(type)});
    }

    @Override
    protected String getTotalLabelPrograms(int total) {
        return Messages.getString(DDCLInventoryDataSource.class, "total.prgs.inreport", new String[]{String.valueOf(total)});
    }
}

