/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare.projects;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.CompareBuilder;
import com.ez.report.application.ezreport.reports.summary.compare.CompareManager;
import com.ez.report.application.ezreport.reports.summary.compare.projects.CompareProjectManager;
import com.ez.report.application.ezreport.reports.summary.compare.projects.CompareProjectsReport;
import com.ez.report.application.model.AbstractReport;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends CompareBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);
    private boolean resultsAreFixed = false;

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.singleProject = false;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new CompareProjectsReport(this.project, this.secondProject);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    public Map getReportParameters(IProgressMonitor pmonitor) {
        this.parameters = super.getReportParameters(pmonitor);
        this.putExternalizedParameters(this.parameters);
        return this.parameters;
    }

    private void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        params.put("title.appFieldValues", this.applicationsName);
        params.put("color", "blue");
    }

    @Override
    protected String buildAppendix() {
        String ret = "";
        String leftResource = ((CompareProjectsReport)this.report).getFirstProject();
        String rightResource = ((CompareProjectsReport)this.report).getSecondProject();
        if (leftResource != null && rightResource != null) {
            String leftStr = this.getResourceTree(leftResource);
            ret = leftStr.concat("\n").concat("\n");
            String rightStr = this.getResourceTree(rightResource);
            ret = ret.concat(rightStr);
        }
        return ret.equals("") ? null : ret;
    }

    @Override
    protected String getResourceTree(String res) {
        return res;
    }

    public void setCompareManager(CompareManager compareManager) {
        this.compareManager = compareManager;
        this.resultsAreFixed = true;
    }

    @Override
    protected CompareManager getCompareManager() {
        if (this.compareManager == null) {
            this.compareManager = new CompareProjectManager();
            this.compareManager.setLeftProject(this.project);
            this.compareManager.setRightProject(this.secondProject);
            this.resultsAreFixed = false;
        }
        return this.compareManager;
    }

    @Override
    protected boolean resultsAreFixed() {
        return this.resultsAreFixed;
    }

    public void setModel(AbstractReport model) {
        super.setModel(model);
        this.secondProject = ((CompareProjectsReport)model).getSecondProject();
    }
}

