/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare.projects;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareProjectsWizardPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CompareProjectsWizardPage.class);
    private List prjList;
    private String project;
    private PrepareReportWizard wizard;

    protected CompareProjectsWizardPage(String pageName, PrepareReportWizard wizard) {
        super(pageName);
        this.setTitle(Messages.getString(CompareProjectsWizardPage.class, "compareProjects.pageTitle"));
        this.setDescription(Messages.getString(CompareProjectsWizardPage.class, "compareProjects.pageDescription"));
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        FormLayout fl = new FormLayout();
        c.setLayout((Layout)fl);
        Group prjGroup = new Group(c, 0);
        Group outGroup = new Group(c, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)outGroup, 2);
        prjGroup.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -5);
        outGroup.setLayoutData((Object)fd);
        prjGroup.setText(Messages.getString(CompareProjectsWizardPage.class, "targetProject.label"));
        prjGroup.setLayout((Layout)new FillLayout());
        this.prjList = new List((Composite)prjGroup, 2564);
        final ArrayList prjNames = new ArrayList();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    EZSourceConnection bridge = null;
                    try {
                        try {
                            String[] projects;
                            bridge = EZSourceConnectionManager.getCurrent();
                            String[] stringArray = projects = bridge.getProjects();
                            int n = projects.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String prj = stringArray[n2];
                                if (!prj.equalsIgnoreCase(CompareProjectsWizardPage.this.project)) {
                                    prjNames.add(prj);
                                }
                                ++n2;
                            }
                        }
                        catch (EZSourceNativeException exGen) {
                            L.error("error in GetProjects(...)", (Throwable)exGen);
                            if (bridge != null) {
                                EZSourceConnectionManager.release((EZSourceConnection)bridge);
                            }
                        }
                    }
                    finally {
                        if (bridge != null) {
                            EZSourceConnectionManager.release((EZSourceConnection)bridge);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            L.error("could not get project list", (Throwable)e);
        }
        this.prjList.setItems(prjNames.toArray(new String[0]));
        this.prjList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareProjectsWizardPage.this.setPageComplete(true);
                CompareProjectsWizardPage.this.wizard.set("target project", (Object)CompareProjectsWizardPage.this.prjList.getSelection()[0]);
            }
        });
        outGroup.setLayout((Layout)new GridLayout());
        outGroup.setText(Messages.getString(CompareProjectsWizardPage.class, "compareOutput.groupName"));
        final Button inEditor = new Button((Composite)outGroup, 16);
        inEditor.setText(Messages.getString(CompareProjectsWizardPage.class, "outputInEditor.label"));
        inEditor.setSelection(true);
        this.wizard.set("target output editor", (Object)true);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareProjectsWizardPage.this.wizard.set("target output editor", (Object)e.getSource().equals(inEditor));
            }
        };
        inEditor.addSelectionListener((SelectionListener)listener);
        Button asReport = new Button((Composite)outGroup, 16);
        asReport.setText(Messages.getString(CompareProjectsWizardPage.class, "outputInReport.label"));
        asReport.addSelectionListener((SelectionListener)listener);
        this.setControl((Control)parent);
    }

    public boolean isPageComplete() {
        return this.prjList.getSelectionCount() != 0;
    }

    public void setProject(String project) {
        this.project = project;
    }
}

