/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare.projects;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.rdz.HookUtils;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.CompareManager;
import com.ez.report.application.ezreport.reports.summary.compare.EZFile;
import com.ez.report.application.reports.SingleQueryResult;
import com.ez.workspace.gotosource.IGoToSourceService;
import com.ez.workspace.gotosource.ReceiveContentCallback;
import com.ez.workspace.model.EZWorkspace;
import com.ibm.ad.oauth2.fileservice.FileAuthUtils;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareProjectManager
extends CompareManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CompareProjectManager.class);
    private Integer filesCount;

    @Override
    protected IStatus buildCompareModel(Map<String, Pair<Integer, Set<EZFile>>> model, EZSourceConnection bridge, String project, String application, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        IStatus st = Status.OK_STATUS;
        SingleQueryResult queryResult = this.querySQLForData(bridge, "select * from pj_folder");
        String[][] results = queryResult.data;
        if (results == null) {
            L.warn("project has no folders!");
            monitor.worked(100);
        } else {
            Integer idFolder;
            HashMap<Integer, Object[]> temp = new HashMap<Integer, Object[]>();
            HashMap<String, EZFile> ezFilesMap = new HashMap<String, EZFile>();
            int i = 0;
            while (i < results.length) {
                idFolder = new Integer(Integer.parseInt(results[i][0]));
                String folderName = results[i][1];
                Integer idParent = new Integer(Integer.parseInt(results[i][3]));
                temp.put(idFolder, new Object[]{folderName, idParent});
                ++i;
            }
            Iterator iterator = temp.keySet().iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    st = Status.CANCEL_STATUS;
                    break;
                }
                idFolder = (Integer)iterator.next();
                String fullPath = this.getPath(idFolder, temp);
                HashSet<EZFile> files = new HashSet<EZFile>();
                model.put(fullPath, (Pair<Integer, Set<EZFile>>)new Pair((Object)idFolder, files));
                queryResult = this.querySQLForData(bridge, "select * from pj_file where id_folder = " + idFolder);
                results = queryResult.data;
                if (results == null) {
                    L.info("folder {} has no files!", (Object)fullPath);
                } else {
                    int i2 = 0;
                    while (i2 < results.length) {
                        Integer idFile = new Integer(Integer.parseInt(results[i2][0]));
                        String fileName = this.filterLibrary(results[i2][1]);
                        Integer idFileType = new Integer(Integer.parseInt(results[i2][2]));
                        String filePath = results[i2][4];
                        EZFile ezfile = new EZFile(fileName, idFile, idFileType, idFolder, filePath);
                        files.add(ezfile);
                        ezFilesMap.put(filePath, ezfile);
                        ++i2;
                    }
                }
                monitor.worked(60 / temp.size());
            }
            monitor.worked(20);
            temp = null;
            if (!ezFilesMap.isEmpty()) {
                try {
                    this.computeInputStream(project, ezFilesMap);
                }
                catch (Exception e) {
                    String message = Messages.getString(CompareProjectManager.class, "computingResults.error.message");
                    st = new Status(4, "com.ez.mainframe.reports.gui", message, (Throwable)e);
                }
                L.debug("after ComputeInputStream");
            }
            monitor.worked(20);
        }
        monitor.done();
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void computeInputStream(String project, final Map<String, EZFile> filesMap) throws Exception {
        Object goToService;
        this.filesCount = filesMap.size();
        final boolean[] wait = new boolean[]{this.filesCount == 0};
        Collection viewSrcContributors = EZWorkspace.getInstance().getViewSourceContributors();
        boolean doRequest = false;
        if (viewSrcContributors != null) {
            Iterator<Object> iterator = viewSrcContributors.iterator();
            while (iterator.hasNext()) {
                goToService = (IGoToSourceService)iterator.next();
                HashMap<String, Properties> map = new HashMap<String, Properties>();
                for (String file : filesMap.keySet()) {
                    map.put(file, new Properties());
                }
                if (goToService.isEnableGoToSource(map)) {
                    doRequest = true;
                }
                if (!doRequest) continue;
                String queryforVersion = goToService.getQueryForVersion();
                if (queryforVersion != null) {
                    Utils.getFilesVersion((String)project, (String)queryforVersion, map);
                }
                ReceiveContentCallback rc = new ReceiveContentCallback(){

                    public void receiveContent(String pathStr, IFile file, StringBuilder sb) {
                        L.trace("getting content of file {} using CARMA extension", (Object)file);
                        EZFile ezfile = (EZFile)filesMap.get(pathStr);
                        ezfile.setFile(new File(file.getLocationURI()));
                        CompareProjectManager.this.notification(wait, false);
                    }

                    public void onErrorOrCancel() {
                        CompareProjectManager.this.notification(wait, true);
                    }
                };
                Display.getDefault().asyncExec(new Runnable((IGoToSourceService)goToService, rc){
                    private final /* synthetic */ IGoToSourceService val$goToService;
                    private final /* synthetic */ ReceiveContentCallback val$rc;
                    {
                        this.val$goToService = iGoToSourceService;
                        this.val$rc = receiveContentCallback;
                    }

                    @Override
                    public void run() {
                        this.val$goToService.openSource(this.val$rc, null);
                    }
                });
            }
        }
        if (doRequest) {
            goToService = wait;
            synchronized (wait) {
                while (true) {
                    while (true) {
                        if (wait[0]) {
                            // ** MonitorExit[goToService /* !! */ ] (shouldn't be in output)
                            return;
                        }
                        try {
                            wait.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            L.error("exception");
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    // ** MonitorExit[goToService /* !! */ ] (shouldn't be in output)
                    throw throwable;
                }
            }
        }
        for (String file : filesMap.keySet()) {
            String content = null;
            if (HookUtils.isValitRemotePath((String)file)) {
                L.trace("getting content of file {} using RDz extension", (Object)file);
                try {
                    StringBuilder sb = HookUtils.getContent((IProgressMonitor)new NullProgressMonitor(), (String)project, (String)file);
                    content = sb.toString();
                }
                catch (IOException iOException) {
                    L.error("exception for file {} ", (Object)file);
                }
            } else {
                L.trace("getting content of file {} using FileService", (Object)file);
                try {
                    HttpResponseConsumer consumer = FileAuthUtils.getFileContent((String)file);
                    if (consumer != null) {
                        content = consumer.getContent();
                    } else {
                        L.debug("no consumer for file {}", (Object)file);
                    }
                }
                catch (Exception e) {
                    L.error("error getting file {}", (Object)file, (Object)e);
                    String msg = Messages.getString(CompareProjectManager.class, "accessingfile.error.message", new String[]{file});
                    LogUtil.displayErrorMessage((Throwable)e, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
                    throw e;
                }
            }
            if (content != null) {
                EZFile ezfile = filesMap.get(file);
                ezfile.setContent(content);
                continue;
            }
            L.info("no content for file {}", (Object)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notification(boolean[] wait, boolean canceled) {
        this.filesCount = this.filesCount - 1;
        boolean[] blArray = wait;
        synchronized (wait) {
            if (canceled || this.filesCount == 0) {
                L.trace("mark wait[0]=true");
                wait[0] = true;
                this.filesCount = null;
                wait.notifyAll();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private String filterLibrary(String fullName) {
        int fpos;
        int lpos;
        String name = fullName;
        int idx = fullName.indexOf("\\");
        if (idx > 0 && (lpos = fullName.lastIndexOf(")")) != -1 && (fpos = fullName.lastIndexOf("(", lpos)) != -1 && (name = fullName.substring(fpos + 1, lpos)).trim().isEmpty()) {
            name = fullName;
        }
        return name;
    }

    private String getPath(Integer idFolder, Map<Integer, Object[]> temp) {
        String path = "";
        Integer parent = (Integer)temp.get(idFolder)[1];
        while (parent != -1) {
            path = this.getPath(parent, temp);
            path = String.valueOf(path) + "/";
            parent = (Integer)temp.get(parent)[1];
        }
        path = String.valueOf(path) + (String)temp.get(idFolder)[0];
        return path;
    }
}

