/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare.app;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.CompareBuilder;
import com.ez.report.application.ezreport.reports.summary.compare.CompareManager;
import com.ez.report.application.ezreport.reports.summary.compare.app.CompareApplicationsManager;
import com.ez.report.application.ezreport.reports.summary.compare.app.CompareApplicationsReport;
import com.ez.report.application.model.AbstractReport;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends CompareBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);

    public ReportBuilder(String reportName, String settings) {
        this.report = null;
        this.singleProject = false;
    }

    public AbstractReport getReportModel() {
        if (this.report == null) {
            this.report = new CompareApplicationsReport(this.project, this.secondProject, this.leftApplication, this.rightApplication);
            this.setOwnerInfos(this.inputs);
        }
        return this.report;
    }

    @Override
    public Map getReportParameters(IProgressMonitor pmonitor) {
        this.parameters = super.getReportParameters(pmonitor);
        this.putExternalizedParameters(this.parameters);
        return this.parameters;
    }

    private void putExternalizedParameters(Map params) {
        String externalized = Messages.getString(ReportBuilder.class, "report.title");
        params.put("report.title", externalized);
        this.applicationsName = String.valueOf(this.leftApplication) + "(" + this.project + "), " + this.rightApplication + "(" + this.secondProject + ")";
        params.put("title.appFieldValues", this.applicationsName);
        params.put("color", "blue");
    }

    @Override
    protected String buildAppendix() {
        String ret = "";
        String leftResource = ((CompareApplicationsReport)this.report).getFirstApplication();
        String rightResource = ((CompareApplicationsReport)this.report).getSecondApplication();
        if (leftResource != null && rightResource != null) {
            String leftPrj = ((CompareApplicationsReport)this.report).getFirstProject();
            String rightPrj = ((CompareApplicationsReport)this.report).getSecondProject();
            String leftStr = this.getResourceTree(leftResource);
            ret = leftStr.concat(" (").concat(leftPrj).concat(")").concat("\n").concat("\n");
            String rightStr = this.getResourceTree(rightResource);
            ret = ret.concat(rightStr).concat(" (").concat(rightPrj).concat(")");
        }
        return ret.equals("") ? null : ret;
    }

    @Override
    protected String getResourceTree(String res) {
        return res;
    }

    @Override
    protected CompareManager getCompareManager() {
        if (this.compareManager == null) {
            this.compareManager = new CompareApplicationsManager();
            this.compareManager.setLeftProject(this.project);
            this.compareManager.setRightProject(this.secondProject);
            this.compareManager.setLeftApplication(this.leftApplication);
            this.compareManager.setRightApplication(this.rightApplication);
        }
        return this.compareManager;
    }

    @Override
    protected boolean resultsAreFixed() {
        return false;
    }

    public void setModel(AbstractReport model) {
        super.setModel(model);
        this.secondProject = ((CompareApplicationsReport)model).getSecondProject();
        this.leftApplication = ((CompareApplicationsReport)model).getFirstApplication();
        this.rightApplication = ((CompareApplicationsReport)model).getSecondApplication();
    }
}

