/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare.app;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.manager.EZSourceConnectionManager;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.model.ApplicationInput;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareApplicationsWizardPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CompareApplicationsWizardPage.class);
    private String project;
    private PrepareReportWizard wizard;
    private org.eclipse.swt.widgets.List sourceAppList;
    private org.eclipse.swt.widgets.List targetAppList;
    private Combo targetProjectsCombo;
    private String targetProject;

    protected CompareApplicationsWizardPage(String pageName, PrepareReportWizard wizard) {
        super(pageName);
        this.setTitle(Messages.getString(CompareApplicationsWizardPage.class, "compareApplications.pageTitle"));
        this.setDescription(Messages.getString(CompareApplicationsWizardPage.class, "compareApplications.pageDescription"));
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        FormLayout fl = new FormLayout();
        c.setLayout((Layout)fl);
        FormData fd = null;
        Group source = new Group(c, 0);
        source.setText(Messages.getString(CompareApplicationsWizardPage.class, "sourceApplication.label"));
        Group target = new Group(c, 0);
        target.setText(Messages.getString(CompareApplicationsWizardPage.class, "targetApplication.label"));
        Group outGroup = new Group(c, 0);
        outGroup.setText(Messages.getString(CompareApplicationsWizardPage.class, "compareOutput.groupName"));
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(50, 0);
        fd.bottom = new FormAttachment((Control)outGroup, 0);
        source.setLayoutData((Object)fd);
        source.setLayout((Layout)new FormLayout());
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(50, 2);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)outGroup, 0);
        target.setLayoutData((Object)fd);
        target.setLayout((Layout)new FormLayout());
        Label spl = new Label((Composite)source, 0);
        spl.setText(Messages.getString(CompareApplicationsWizardPage.class, "project"));
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(100, -2);
        spl.setLayoutData((Object)fd);
        Combo sac = new Combo((Composite)source, 12);
        sac.add(this.project);
        sac.select(0);
        fd = new FormData();
        fd.top = new FormAttachment((Control)spl, 2);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(100, -2);
        sac.setLayoutData((Object)fd);
        Label salb = new Label((Composite)source, 0);
        salb.setText(Messages.getString(CompareApplicationsWizardPage.class, "application"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)sac, 2);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(100, -2);
        salb.setLayoutData((Object)fd);
        this.sourceAppList = new org.eclipse.swt.widgets.List((Composite)source, 2564);
        fd = new FormData();
        fd.top = new FormAttachment((Control)salb, 2);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(100, -2);
        fd.bottom = new FormAttachment(100, -2);
        this.sourceAppList.setLayoutData((Object)fd);
        ArrayList<String> appNames = new ArrayList<String>();
        this.fillApplications(this.project, appNames);
        this.sourceAppList.setItems(appNames.toArray(new String[0]));
        this.sourceAppList.deselectAll();
        this.sourceAppList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String leftApp = CompareApplicationsWizardPage.this.sourceAppList.getSelection()[0];
                String rightApp = (String)CompareApplicationsWizardPage.this.wizard.getValue("target application");
                String rightPrj = (String)CompareApplicationsWizardPage.this.wizard.getValue("target project");
                if (leftApp != null) {
                    if (CompareApplicationsWizardPage.this.project.equals(rightPrj) && leftApp.equals(rightApp)) {
                        CompareApplicationsWizardPage.this.setPageComplete(false);
                        CompareApplicationsWizardPage.this.setMessage(Messages.getString(CompareApplicationsWizardPage.class, "errorMessage"), 3);
                        leftApp = null;
                        CompareApplicationsWizardPage.this.sourceAppList.deselectAll();
                    } else {
                        CompareApplicationsWizardPage.this.setMessage("");
                    }
                }
                CompareApplicationsWizardPage.this.wizard.set("source application", (Object)leftApp);
                CompareApplicationsWizardPage.this.pageComplete();
            }
        });
        Label tpl = new Label((Composite)target, 0);
        tpl.setText(Messages.getString(CompareApplicationsWizardPage.class, "project"));
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(100, -2);
        tpl.setLayoutData((Object)fd);
        this.targetProjectsCombo = new Combo((Composite)target, 12);
        fd = new FormData();
        fd.top = new FormAttachment((Control)tpl, 2);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(100, -2);
        this.targetProjectsCombo.setLayoutData((Object)fd);
        if (this.targetProject != null && !this.targetProject.isEmpty()) {
            this.targetProjectsCombo.add(this.targetProject);
            this.targetProjectsCombo.select(0);
            this.wizard.set("target project", (Object)this.targetProject);
        } else {
            ArrayList<String> prjNames = new ArrayList<String>();
            this.getProjectsList(prjNames);
            this.targetProjectsCombo.setItems(prjNames.toArray(new String[0]));
            this.targetProjectsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CompareApplicationsWizardPage.this.wizard.set("target project", (Object)CompareApplicationsWizardPage.this.targetProjectsCombo.getItem(CompareApplicationsWizardPage.this.targetProjectsCombo.getSelectionIndex()));
                    CompareApplicationsWizardPage.this.wizard.set("target application", null);
                    CompareApplicationsWizardPage.this.targetAppList.deselectAll();
                    CompareApplicationsWizardPage.this.changeTargetApplications();
                    CompareApplicationsWizardPage.this.pageComplete();
                }
            });
        }
        Label talb = new Label((Composite)target, 0);
        talb.setText(Messages.getString(CompareApplicationsWizardPage.class, "application"));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.targetProjectsCombo, 2);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(100, -2);
        talb.setLayoutData((Object)fd);
        this.targetAppList = new org.eclipse.swt.widgets.List((Composite)target, 2564);
        fd = new FormData();
        fd.top = new FormAttachment((Control)talb, 2);
        fd.left = new FormAttachment(0, 2);
        fd.right = new FormAttachment(100, -2);
        fd.bottom = new FormAttachment(100, -2);
        this.targetAppList.setLayoutData((Object)fd);
        this.targetAppList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String leftApp = (String)CompareApplicationsWizardPage.this.wizard.getValue("source application");
                String[] rightSelection = CompareApplicationsWizardPage.this.targetAppList.getSelection();
                String rightApp = rightSelection != null && rightSelection.length > 0 ? rightSelection[0] : null;
                String rightPrj = (String)CompareApplicationsWizardPage.this.wizard.getValue("target project");
                if (rightApp != null) {
                    if (CompareApplicationsWizardPage.this.project.equals(rightPrj) && rightApp.equals(leftApp)) {
                        CompareApplicationsWizardPage.this.setPageComplete(false);
                        CompareApplicationsWizardPage.this.setMessage(Messages.getString(CompareApplicationsWizardPage.class, "errorMessage"), 3);
                        rightApp = null;
                        CompareApplicationsWizardPage.this.targetAppList.deselectAll();
                    } else {
                        CompareApplicationsWizardPage.this.setMessage("");
                    }
                }
                CompareApplicationsWizardPage.this.wizard.set("target application", (Object)rightApp);
                CompareApplicationsWizardPage.this.pageComplete();
            }
        });
        if (this.targetProject != null && !this.targetProject.isEmpty()) {
            this.wizard.set("target application", null);
            this.targetAppList.deselectAll();
            this.changeTargetApplications();
            this.pageComplete();
        }
        outGroup.setLayout((Layout)new GridLayout());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        outGroup.setLayoutData((Object)fd);
        final Button inEditor = new Button((Composite)outGroup, 16);
        inEditor.setText(Messages.getString(CompareApplicationsWizardPage.class, "outputInEditor.label"));
        inEditor.setSelection(true);
        this.wizard.set("target output editor", (Object)Boolean.TRUE);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompareApplicationsWizardPage.this.wizard.set("target output editor", (Object)e.getSource().equals(inEditor));
            }
        };
        inEditor.addSelectionListener((SelectionListener)listener);
        Button asReport = new Button((Composite)outGroup, 16);
        asReport.setText(Messages.getString(CompareApplicationsWizardPage.class, "outputInReport.label"));
        asReport.addSelectionListener((SelectionListener)listener);
        this.setControl((Control)c);
    }

    private void getProjectsList(final List<String> prjNames) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    EZSourceConnection bridge = null;
                    try {
                        try {
                            bridge = EZSourceConnectionManager.getCurrent();
                            List prjs = com.ez.report.application.utils.Utils.getUCMDBProjects((SubMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10000), (EZSourceConnection)bridge);
                            for (ProjectInfo pjInfo : prjs) {
                                prjNames.add(pjInfo.getProjectName());
                            }
                        }
                        catch (EZSourceNativeException exGen) {
                            L.error("error in GetProjects(...)", (Throwable)exGen);
                            if (bridge != null) {
                                EZSourceConnectionManager.release((EZSourceConnection)bridge);
                            }
                        }
                    }
                    finally {
                        if (bridge != null) {
                            EZSourceConnectionManager.release((EZSourceConnection)bridge);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            L.error("could not get project list", (Throwable)e);
        }
    }

    public boolean isPageComplete() {
        return this.targetProjectsCombo.getSelectionIndex() != -1 && this.wizard.getValue("source application") != null && this.wizard.getValue("target application") != null;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setTargetProject(String projectName) {
        this.targetProject = projectName;
    }

    public void pageComplete() {
        if (this.isPageComplete()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void changeTargetApplications() {
        String targetPrj = (String)this.wizard.getValue("target project");
        ArrayList<String> appNames = new ArrayList<String>();
        if (targetPrj != null && !"".equals(targetPrj)) {
            if (this.project.equals(targetPrj)) {
                appNames.addAll(Arrays.asList(this.sourceAppList.getItems()));
            } else {
                this.fillApplications(targetPrj, appNames);
            }
        }
        this.targetAppList.setItems(appNames.toArray(new String[0]));
        this.targetAppList.deselectAll();
    }

    private void fillApplications(String project, final List<String> appNames) {
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(project, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    List apps = Utils.getAvailableApplications((EZSourceConnection)conn);
                    for (ApplicationInput string : apps) {
                        appNames.add(string.getListableName());
                    }
                }
            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            L.error("could not get project list", (Throwable)e);
        }
        catch (ExecutionException e) {
            L.error("could not get project list", (Throwable)e);
        }
    }
}

