/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare.app;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.utils.Pair;
import com.ez.report.application.ezreport.reports.summary.compare.CompareManager;
import com.ez.report.application.ezreport.reports.summary.compare.EZFile;
import com.ez.report.application.reports.SingleQueryResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareApplicationsManager
extends CompareManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CompareApplicationsManager.class);
    private static final String folderQuery = "select * from pj_folder";
    private static final String filesQuery_part1 = "select * from pj_file where filepath in ( SELECT distinct components.resourcePath FROM (Components INNER JOIN Programs ON Components.ResourceID = Programs.ProgramID) INNER JOIN (Applications INNER JOIN AppToComponents ON Applications.ApplicationID = AppToComponents.ApplicationID) ON Components.ComponentID = AppToComponents.ComponentID WHERE (((Components.ResourceType)=5)) and (Programs.OccurID <> 0) \t and applications.Applicationid= ";
    private static final String filesQuery_part2 = " ) ";
    Map<Integer, String> folders = new HashMap<Integer, String>();
    int currentParent = -1;

    @Override
    protected IStatus buildCompareModel(Map<String, Pair<Integer, Set<EZFile>>> model, EZSourceConnection bridge, String project, String application, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)90);
        this.folders.clear();
        this.currentParent = -1;
        String q = String.format("select ApplicationID from Applications where ApplicationName = %s ", application);
        SingleQueryResult queryResult = this.querySQLForData(bridge, q);
        String appId = queryResult.data[0][0];
        monitor.worked(30);
        queryResult = this.querySQLForData(bridge, filesQuery_part1 + appId + filesQuery_part2);
        String[][] results = queryResult.data;
        monitor.worked(30);
        if (results == null) {
            L.warn("project has no files in given application!");
        } else {
            SingleQueryResult queryResult2 = this.querySQLForData(bridge, folderQuery);
            String[][] results2 = queryResult2.data;
            int i = 0;
            while (i < results.length) {
                Integer idFile = new Integer(Integer.parseInt(results[i][0]));
                String fileName = results[i][1];
                Integer idFileType = new Integer(Integer.parseInt(results[i][2]));
                Integer idFolder = new Integer(Integer.parseInt(results[i][3]));
                String filePath = results[i][4];
                String folderPath = this.folders.get(idFolder);
                if (folderPath == null) {
                    folderPath = this.getPath(idFolder, results2);
                    this.folders.put(idFolder, folderPath);
                }
                Pair pair = model.get(folderPath);
                Set<EZFile> files = null;
                if (pair == null) {
                    files = new HashSet();
                    pair = new Pair((Object)idFolder, files);
                    model.put(folderPath, (Pair<Integer, Set<EZFile>>)pair);
                } else {
                    files = (Set)pair.getSecond();
                }
                files.add(new EZFile(fileName, idFile, idFileType, idFolder, filePath));
                ++i;
            }
        }
        monitor.worked(30);
        return Status.OK_STATUS;
    }

    private String getPath(Integer idFolder, String[][] folderResults) {
        String path = "";
        int i = 0;
        while (i < folderResults.length) {
            Integer id = new Integer(Integer.parseInt(folderResults[i][0]));
            if (id.equals(idFolder)) {
                String folderName = folderResults[i][1];
                Integer idParent = new Integer(Integer.parseInt(folderResults[i][3]));
                this.currentParent = idParent;
                while (this.currentParent != -1) {
                    path = this.getPath(idParent, folderResults);
                    path = String.valueOf(path) + "/";
                }
                path = String.valueOf(path) + folderName;
                break;
            }
            ++i;
        }
        return path;
    }
}

