/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare.app;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.app.CompareApplicationsJob;
import com.ez.report.application.ezreport.reports.summary.compare.app.CompareApplicationsWizardPage;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;

public class CompareApplicationsAnalysis
extends EZReportAnalysis {
    public CompareApplicationsAnalysis() {
        this(null);
    }

    public CompareApplicationsAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    protected boolean checkInputs(List inputs) {
        return inputs.size() == 2 && inputs.get(0) instanceof EZSourceProjectInputType && inputs.get(1) instanceof EZSourceProjectInputType;
    }

    @Override
    protected PrepareReportWizard getWizard() {
        List inputs = this.getContextListValue("input_list");
        this.projectName = ((EZSourceProjectInputType)inputs.get(0)).getName();
        String targetProject = ((EZSourceProjectInputType)inputs.get(1)).getName();
        this.params = new HashMap();
        this.params.put("project_name", this.projectName);
        this.params.put("target project", targetProject);
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(CompareApplicationsAnalysis.class, "wizzard.title");
        CompareApplicationsWizardPage cpwp = new CompareApplicationsWizardPage("compare applications", wizard);
        cpwp.setProject(this.projectName);
        cpwp.setTargetProject(targetProject);
        wizard.addPage((IWizardPage)cpwp);
        wizard.setWindowTitle(wizardName);
        return wizard;
    }

    protected AbstractAnalysisJob getJob(EZEntityID arg0) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(this.id, CompareApplicationsJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_COMPAREAPPLICATIONS_ANALYSIS;
    }

    @Override
    protected boolean parametersEquals(Map<String, Object> params1, Map<String, Object> params2) {
        boolean ret = super.parametersEquals(params1, params2);
        if (ret) {
            String p1 = (String)params1.get("target project");
            String p2 = (String)params2.get("target project");
            if (p1 != null) {
                ret = p1.equals(p2);
            } else {
                boolean bl = ret = p2 == null;
            }
            if (ret) {
                p1 = (String)params1.get("source application");
                p2 = (String)params2.get("source application");
                if (p1 != null) {
                    ret = p1.equals(p2);
                } else {
                    boolean bl = ret = p2 == null;
                }
                if (ret) {
                    p1 = (String)params1.get("target application");
                    p2 = (String)params2.get("target application");
                    ret = p1 != null ? p1.equals(p2) : p2 == null;
                }
            }
        }
        return ret;
    }
}

