/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare;

import com.ez.internal.utils.PathMapping;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.DefaultCompareEditorInput;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZFile
implements Comparable<EZFile> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZFile.class);
    String fileName;
    Integer idFile;
    Integer idFileType;
    Integer idFolder;
    private String filePath;
    File downloadedFile;
    String content;

    public EZFile(String fileName, Integer idFile, Integer idFileType, Integer idFolder, String filePath) {
        this.fileName = fileName;
        this.idFile = idFile;
        this.idFileType = idFileType;
        this.idFolder = idFolder;
        this.filePath = filePath;
    }

    @Override
    public int compareTo(EZFile other) {
        int ret = this.fileName.compareTo(other.fileName);
        if (ret == 0 && (ret = this.filePath.compareTo(other.filePath)) == 0) {
            ret = this.idFileType.compareTo(other.idFileType);
        }
        return ret;
    }

    public void setFile(File file) {
        this.downloadedFile = file;
    }

    public void setContent(String s) {
        this.content = s;
    }

    private File getFile() {
        if (this.downloadedFile != null) {
            return this.downloadedFile;
        }
        return new File(PathMapping.convertToMapped((String)this.filePath));
    }

    public InputStream getInputStream() {
        InputStream inputStream = null;
        if (this.content != null) {
            inputStream = new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
        } else {
            try {
                inputStream = new FileInputStream(this.getFile());
            }
            catch (FileNotFoundException e) {
                EZReportErrorLog.err(Messages.getString(DefaultCompareEditorInput.class, "file.not.found.msg"), e);
                L.error("file exception for file {} / path {} ", (Object)this.fileName, (Object)this.filePath);
            }
        }
        return inputStream;
    }
}

