/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare;

import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.reports.gui.internal.Activator;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.ChangeEncodingDialog;
import com.ez.report.application.ezreport.reports.summary.compare.CompareManager;
import com.ez.report.application.ezreport.reports.summary.compare.EZCompareConfiguration;
import com.ez.report.application.ezreport.reports.summary.compare.EZDiffTreeViewer;
import com.ez.report.application.ezreport.reports.summary.compare.EZFile;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCompareEditorInput
extends CompareEditorInput {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DefaultCompareEditorInput.class);
    private Runnable generateReportAction;
    protected String leftProject;
    protected String leftApplication;
    protected String rightProject;
    protected String rightApplication;
    private CompareManager cm;
    private EZCompareConfiguration config;
    private static final String DEFAULT_ENCODING = "UTF-8";
    String currentEncoding = null;
    private EZDiffTreeViewer diffTreeViewer;
    private boolean editorOpened = false;

    public void setLeftProject(String leftPrj) {
        this.leftProject = leftPrj;
    }

    public void setRightProject(String rightPrj) {
        this.rightProject = rightPrj;
    }

    public void setLeftApplication(String leftApplication) {
        this.leftApplication = leftApplication;
    }

    public void setRightApplication(String rightApplication) {
        this.rightApplication = rightApplication;
    }

    public DefaultCompareEditorInput(EZCompareConfiguration config, CompareManager cm) {
        super((CompareConfiguration)config);
        this.config = config;
        this.cm = cm;
    }

    public void setGenerateReportAction(Runnable generateReportAction) {
        this.generateReportAction = generateReportAction;
    }

    public boolean canRunAsJob() {
        return true;
    }

    public Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        FormLayout fl = new FormLayout();
        c.setLayout((Layout)fl);
        Button button = new Button(c, 0x800008);
        button.setImage(this.config.getImage(Activator.getImageDescriptor("icons/generate.gif")));
        final String tooltip = Messages.getString(DefaultCompareEditorInput.class, "btn.tooltip");
        button.setToolTipText(tooltip);
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = tooltip;
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultCompareEditorInput.this.generateReportAction.run();
            }
        });
        Button btnEncoding = new Button(c, 0x800008);
        btnEncoding.setImage(this.config.getImage(Activator.getImageDescriptor("icons/encoding.gif")));
        final String etooltip = Messages.getString(DefaultCompareEditorInput.class, "btnEncoding.tooltip");
        btnEncoding.setToolTipText(etooltip);
        btnEncoding.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = etooltip;
            }
        });
        final Shell shell = this.getWorkbenchPart().getSite().getShell();
        btnEncoding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ChangeEncodingDialog dialog = new ChangeEncodingDialog(shell, DefaultCompareEditorInput.this.getEncoding());
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        dialog.open();
                    }
                });
                if (dialog.close() && dialog.getReturnCode() == 0) {
                    String selEncoding = dialog.getSelectedEncoding();
                    L.debug("selected encoding: {}", (Object)selEncoding);
                    if (!selEncoding.equalsIgnoreCase(DefaultCompareEditorInput.this.currentEncoding)) {
                        DefaultCompareEditorInput.this.currentEncoding = selEncoding;
                        if (DefaultCompareEditorInput.this.editorOpened) {
                            L.debug("reload editor with new encoding: {}", (Object)DefaultCompareEditorInput.this.currentEncoding);
                            Object inpt = DefaultCompareEditorInput.this.diffTreeViewer.getInput();
                            ISelection sel = DefaultCompareEditorInput.this.diffTreeViewer.getSelection();
                            DefaultCompareEditorInput.this.diffTreeViewer.setInput(null);
                            DefaultCompareEditorInput.this.diffTreeViewer.setInput(inpt);
                            DefaultCompareEditorInput.this.diffTreeViewer.setSelection(sel);
                            DefaultCompareEditorInput.this.diffTreeViewer.openElement();
                        }
                    }
                }
            }
        });
        Control inside = super.createContents(c);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.right = new FormAttachment(100, -1);
        button.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 1);
        fd.right = new FormAttachment((Control)button);
        btnEncoding.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        inside.setLayoutData((Object)fd);
        c.setTabList(new Control[]{inside, btnEncoding, button});
        return c;
    }

    public Viewer createDiffViewer(Composite parent) {
        this.diffTreeViewer = new EZDiffTreeViewer(parent, this.getCompareConfiguration());
        this.diffTreeViewer.getControl().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Messages.getString(DefaultCompareEditorInput.class, "viewer.title"));
        this.diffTreeViewer.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                TreeItem[] tis = DefaultCompareEditorInput.this.diffTreeViewer.getTree().getSelection();
                String s = (String)DefaultCompareEditorInput.this.diffTreeViewer.getControl().getData("org.eclipse.compare.CompareUI.CompareViewerTitle");
                TreeItem[] treeItemArray = tis;
                int n = tis.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    s = String.valueOf(s) + ti.getText();
                    ++n2;
                }
                e.result = s;
            }
        });
        this.diffTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                DefaultCompareEditorInput.this.editorOpened = true;
            }
        });
        return this.diffTreeViewer;
    }

    public Image getTitleImage() {
        Image img = null;
        img = this.leftApplication != null ? this.config.getImage(Activator.getImageDescriptor("icons/compareApplications.png")) : this.config.getImage(Activator.getImageDescriptor("icons/compareProjects.png"));
        return img;
    }

    protected Object prepareInput(IProgressMonitor pmonitor) throws InvocationTargetException, InterruptedException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1000);
        StringBuilder titleBuilder = new StringBuilder();
        if (this.leftApplication != null) {
            titleBuilder.append(this.leftApplication);
            titleBuilder.append(" (").append(this.leftProject).append(")");
        } else {
            titleBuilder.append(this.leftProject);
        }
        titleBuilder.append(" - ");
        if (this.rightApplication != null) {
            titleBuilder.append(this.rightApplication);
            titleBuilder.append(" (").append(this.rightProject).append(")");
        } else {
            titleBuilder.append(this.rightProject);
        }
        this.setTitle(titleBuilder.toString());
        this.cm.setLeftProject(this.leftProject);
        this.cm.setRightProject(this.rightProject);
        this.cm.setLeftApplication(this.leftApplication);
        this.cm.setRightApplication(this.rightApplication);
        monitor.worked(30);
        DiffNode root = new DiffNode(0);
        IStatus st = this.cm.execute((IProgressMonitor)monitor.newChild(670));
        if (st.isOK()) {
            TreeSet<String> allFolders = new TreeSet<String>();
            Set<String> addFolders = this.cm.getAdded().keySet();
            Set<String> remFolders = this.cm.getRemoved().keySet();
            Set<String> leftChangedFolders = this.cm.getLeftChanged().keySet();
            allFolders.addAll(addFolders);
            allFolders.addAll(remFolders);
            allFolders.addAll(leftChangedFolders);
            int foldersSize = allFolders.size();
            HashMap<String, FolderInput> folders = new HashMap<String, FolderInput>();
            for (String folder : allFolders) {
                DiffNode parent = root;
                String fName = folder;
                int pos = folder.lastIndexOf("/");
                if (pos >= 0) {
                    String parentName = folder.substring(0, pos);
                    parent = (DiffNode)folders.get(parentName);
                    if (parent == null) {
                        L.warn("parent is null in diff for: {}. It will be added as changed.", (Object)folder);
                        parent = new FolderInput(parentName, root, 3);
                        folders.put(parentName, (FolderInput)parent);
                    }
                    fName = folder.substring(pos + 1);
                }
                FolderInput df = new FolderInput(fName, parent, 0);
                folders.put(folder, df);
                int i = 0;
                if (addFolders.contains(folder)) {
                    this.addFiles(df, (Set)this.cm.getAdded().get(folder).getSecond(), null, 1);
                    df.setKind(1);
                    ++i;
                }
                if (remFolders.contains(folder)) {
                    this.addFiles(df, null, (Set)this.cm.getRemoved().get(folder).getSecond(), 2);
                    df.setKind(2);
                    ++i;
                }
                if (leftChangedFolders.contains(folder)) {
                    ++i;
                    this.addFiles(df, (Set)this.cm.getLeftChanged().get(folder).getSecond(), (Set)this.cm.getRightChanged().get(folder).getSecond(), 3);
                    df.setKind(3);
                }
                if (i != 1) {
                    df.setKind(3);
                }
                monitor.worked(300 / foldersSize);
            }
        } else {
            LogUtil.displayErrorMessage((Throwable)st.getException(), (String)st.getMessage(), (Plugin)Activator.getDefault(), (boolean)true);
        }
        return root;
    }

    private Image getImageForType(Integer idFileType) {
        Image image = null;
        switch (idFileType) {
            case 56: 
            case 57: 
            case 58: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/adsProcess.png"));
                break;
            }
            case 49: 
            case 63: 
            case 64: 
            case 65: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/assembler.png"));
                break;
            }
            case 1: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 59: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/cobol.png"));
                break;
            }
            case 2: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/cobol.png"));
                break;
            }
            case 18: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/Pl1.png"));
                break;
            }
            case 51: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/ico_REXX_programs.gif"));
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/natural.png"));
                break;
            }
            case 17: 
            case 60: 
            case 62: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/Pl1.png"));
                break;
            }
            case 5: 
            case 28: 
            case 46: 
            case 47: 
            case 48: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/job.png"));
                break;
            }
            default: {
                image = this.config.getImage(Activator.getImageDescriptor("icons/ezsource/root.gif"));
            }
        }
        return image;
    }

    private void addFiles(DiffNode parent, Set<EZFile> left, Set<EZFile> right, int type) {
        int side = 0;
        if (left != null) {
            side = 1;
        }
        if (right != null) {
            side = 10 * side + 2;
        }
        if (side < 10) {
            Set<EZFile> list = side == 1 ? left : right;
            for (final EZFile f : list) {
                DiffNode df = new DiffNode((IDiffContainer)parent, type){

                    public String getName() {
                        return f.fileName;
                    }

                    public Image getImage() {
                        return DefaultCompareEditorInput.this.getImageForType(f.idFileType);
                    }
                };
                if (side == 1) {
                    df.setLeft((ITypedElement)new FileInput(f));
                    continue;
                }
                df.setRight((ITypedElement)new FileInput(f));
            }
        } else {
            Set<EZFile> list = left != null ? left : right;
            Set<EZFile> other = left != null ? right : left;
            block1: for (final EZFile f : list) {
                DiffNode df = new DiffNode((IDiffContainer)parent, type){

                    public String getName() {
                        return f.fileName;
                    }
                };
                if (left != null) {
                    df.setLeft((ITypedElement)new FileInput(f));
                } else {
                    df.setRight((ITypedElement)new FileInput(f));
                }
                if (other == null) continue;
                for (EZFile fr : other) {
                    if (!fr.fileName.equalsIgnoreCase(f.fileName)) continue;
                    if (left != null) {
                        df.setRight((ITypedElement)new FileInput(fr));
                        continue block1;
                    }
                    df.setLeft((ITypedElement)new FileInput(fr));
                    continue block1;
                }
            }
        }
    }

    private String getEncoding() {
        return this.currentEncoding != null && !this.currentEncoding.isEmpty() ? this.currentEncoding : DEFAULT_ENCODING;
    }

    private class FileInput
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private EZFile file;

        public FileInput(EZFile file) {
            this.file = file;
        }

        public Image getImage() {
            return DefaultCompareEditorInput.this.getImageForType(this.file.idFileType);
        }

        public String getName() {
            return this.file.fileName;
        }

        public String getType() {
            return "type: file.idFileType";
        }

        public String getCharset() throws CoreException {
            return DefaultCompareEditorInput.this.getEncoding();
        }

        public InputStream getContents() throws CoreException {
            return this.file.getInputStream();
        }
    }

    class FolderInput
    extends DiffNode {
        private String name;

        public FolderInput(String name, DiffNode parent, int type) {
            super((IDiffContainer)parent, type);
            this.name = name;
        }

        public Image getImage() {
            return DefaultCompareEditorInput.this.config.getImage(Activator.getImageDescriptor("icons/compareProjects.png"));
        }

        public String getName() {
            return this.name;
        }
    }
}

