/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare;

import com.ez.report.application.ezreport.reports.summary.compare.AbstractCompareBuilder;
import com.ez.report.application.ezreport.reports.summary.compare.CompareEditorOutputProvider;
import com.ez.report.application.ezreport.reports.summary.compare.DefaultCompareEditorInput;
import com.ez.report.application.viewer.execution.ReportExecutor;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ReportInputProvider;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareReportExecutor
extends ReportExecutor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CompareReportExecutor.class);
    private String reportName;
    private Boolean isEditor = null;

    public CompareReportExecutor(Map<String, Object> settings) {
        super(settings);
    }

    @Override
    protected void processInputs(IProgressMonitor pmonitor, Map<String, Object> inputs) {
        this.isEditor = (Boolean)inputs.get("target output editor");
        ((AbstractCompareBuilder)this.builder).reportName = this.reportName;
        super.processInputs(pmonitor, inputs);
    }

    @Override
    protected void fillReportViewer(IProgressMonitor pmonitor) {
        if (this.isEditor != null && this.isEditor.booleanValue()) {
            this.outputProvider = new CompareEditorOutputProvider();
            DefaultCompareEditorInput output = ((AbstractCompareBuilder)this.builder).getOutput();
            if (output != null) {
                output.setGenerateReportAction(new Runnable(){

                    @Override
                    public void run() {
                        ReportInputProvider inputProvider2 = CompareReportExecutor.this.inputProvider;
                        Map inputs = inputProvider2.getInputs();
                        inputs.put("target output editor", false);
                        ((AbstractCompareBuilder)((CompareReportExecutor)CompareReportExecutor.this).builder).job.setParameters(inputs);
                        ((AbstractCompareBuilder)((CompareReportExecutor)CompareReportExecutor.this).builder).job.schedule();
                    }
                });
                ((CompareEditorOutputProvider)this.outputProvider).setContent(output);
                this.genStatus = this.outputProvider.showResults(pmonitor);
            } else {
                L.warn("no results from builder!");
                this.genStatus = GenerationStatus.ERROR;
            }
            this.genStatus = pmonitor.isCanceled() ? GenerationStatus.CANCELED : this.genStatus;
        } else {
            super.fillReportViewer(pmonitor);
        }
    }
}

