/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.EZReportErrorLog;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.EZFile;
import com.ez.report.application.reports.SingleQueryResult;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompareManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CompareManager.class);
    private Map<String, Pair<Integer, Set<EZFile>>> added = new HashMap<String, Pair<Integer, Set<EZFile>>>();
    private Map<String, Pair<Integer, Set<EZFile>>> changed = new HashMap<String, Pair<Integer, Set<EZFile>>>();
    private Map<String, Pair<Integer, Set<EZFile>>> removed = new HashMap<String, Pair<Integer, Set<EZFile>>>();
    private Map<String, Pair<Integer, Set<EZFile>>> leftChanged = new HashMap<String, Pair<Integer, Set<EZFile>>>();
    private Map<String, Pair<Integer, Set<EZFile>>> rightChanged = new HashMap<String, Pair<Integer, Set<EZFile>>>();
    private Map<String, Pair<Integer, Set<EZFile>>> left = new HashMap<String, Pair<Integer, Set<EZFile>>>();
    private Map<String, Pair<Integer, Set<EZFile>>> right = new HashMap<String, Pair<Integer, Set<EZFile>>>();
    protected String leftProject;
    protected String leftApplication;
    protected String rightProject;
    protected String rightApplication;

    public void setLeftProject(String leftPrj) {
        this.leftProject = leftPrj;
    }

    public void setRightProject(String rightPrj) {
        this.rightProject = rightPrj;
    }

    public void setLeftApplication(String leftApplication) {
        this.leftApplication = leftApplication;
    }

    public void setRightApplication(String rightApplication) {
        this.rightApplication = rightApplication;
    }

    public IStatus execute(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (String)Messages.getString(CompareManager.class, "executingcompare.taskname"), (int)90);
        IStatus status = this.getCompareModel(this.left, this.leftProject, this.leftApplication, (IProgressMonitor)monitor.newChild(30));
        if (Status.OK_STATUS.equals(status)) {
            status = this.getCompareModel(this.right, this.rightProject, this.rightApplication, (IProgressMonitor)monitor.newChild(30));
        }
        if (Status.OK_STATUS.equals(status)) {
            monitor.subTask(Messages.getString(CompareManager.class, "calculatingDifferences.subtask"));
            status = this.makeDiff((IProgressMonitor)monitor.newChild(30));
            monitor.subTask("");
        }
        return status;
    }

    protected abstract IStatus buildCompareModel(Map<String, Pair<Integer, Set<EZFile>>> var1, EZSourceConnection var2, String var3, String var4, IProgressMonitor var5);

    public Map<String, Pair<Integer, Set<EZFile>>> getAdded() {
        return this.added;
    }

    public Map<String, Pair<Integer, Set<EZFile>>> getChanged() {
        return this.leftChanged;
    }

    public Map<String, Pair<Integer, Set<EZFile>>> getLeftChanged() {
        return this.leftChanged;
    }

    public Map<String, Pair<Integer, Set<EZFile>>> getRightChanged() {
        return this.rightChanged;
    }

    public Map<String, Pair<Integer, Set<EZFile>>> getRemoved() {
        return this.removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus getCompareModel(Map<String, Pair<Integer, Set<EZFile>>> model, String project, String application, IProgressMonitor monitor) {
        WorkThread t = new WorkThread();
        t.setMonitor(monitor);
        t.setName(Messages.getString(CompareManager.class, "compareData.thread", new String[]{project}));
        t.setProject(project);
        t.setApplication(application);
        t.setModel(model);
        WorkThread workThread = t;
        synchronized (workThread) {
            t.start();
            try {
                t.wait();
            }
            catch (InterruptedException e) {
                L.error("Error:", (Throwable)e);
            }
            return t.getStatus();
        }
    }

    private IStatus makeDiff(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        IStatus st = Status.OK_STATUS;
        HashSet<String> leftMinusRight = new HashSet<String>(this.left.keySet());
        leftMinusRight.removeAll(this.right.keySet());
        HashSet<String> rightMinusLeft = new HashSet<String>(this.right.keySet());
        rightMinusLeft.removeAll(this.left.keySet());
        HashSet<String> intersect = new HashSet<String>(this.left.keySet());
        intersect.retainAll(this.right.keySet());
        for (String folder : leftMinusRight) {
            this.added.put(folder, this.left.remove(folder));
        }
        monitor.worked(10);
        for (String folder : rightMinusLeft) {
            this.removed.put(folder, this.right.remove(folder));
        }
        monitor.worked(10);
        for (String folder : intersect) {
            if (monitor.isCanceled()) {
                st = Status.CANCEL_STATUS;
                monitor.done();
                break;
            }
            Pair<Integer, Set<EZFile>> lrPair = this.left.get(folder);
            Pair<Integer, Set<EZFile>> rlPair = this.right.get(folder);
            HashSet<EZFile> l_r_files = new HashSet<EZFile>();
            HashSet<EZFile> r_l_files = new HashSet<EZFile>();
            HashSet<EZFile> l_int_files = new HashSet<EZFile>();
            HashSet<EZFile> r_int_files = new HashSet<EZFile>();
            r_l_files = new HashSet((Collection)rlPair.getSecond());
            boolean found = false;
            for (EZFile fl : (Set)lrPair.getSecond()) {
                found = false;
                for (EZFile fr : (Set)rlPair.getSecond()) {
                    if (!fl.fileName.equalsIgnoreCase(fr.fileName) || !fl.idFileType.equals(fr.idFileType)) continue;
                    if (this.contentChanged(fl.getInputStream(), fr.getInputStream())) {
                        r_int_files.add(fr);
                        l_int_files.add(fl);
                    }
                    r_l_files.remove(fr);
                    found = true;
                    break;
                }
                if (found) continue;
                l_r_files.add(fl);
            }
            this.addFilesTo(this.added, folder, lrPair, l_r_files);
            this.addFilesTo(this.removed, folder, rlPair, r_l_files);
            this.addFilesTo(this.leftChanged, folder, lrPair, l_int_files);
            this.addFilesTo(this.rightChanged, folder, rlPair, r_int_files);
            monitor.worked(80 / intersect.size());
        }
        return st;
    }

    /*
     * Exception decompiling
     */
    private boolean contentChanged(InputStream is1, InputStream is2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[DOLOOP]], but top level block is 29[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addFilesTo(Map<String, Pair<Integer, Set<EZFile>>> target, String folder, Pair<Integer, Set<EZFile>> pair, Set<EZFile> diff) {
        if (diff.size() > 0) {
            Pair tmpPair = target.get(folder);
            if (tmpPair == null) {
                tmpPair = new Pair((Object)((Integer)pair.getFirst()), diff);
                target.put(folder, (Pair<Integer, Set<EZFile>>)tmpPair);
            } else {
                ((Set)tmpPair.getSecond()).addAll(diff);
            }
        }
    }

    public void clean() {
        this.added.clear();
        this.changed.clear();
        this.removed.clear();
        this.left.clear();
        this.right.clear();
    }

    public SingleQueryResult querySQLForData(EZSourceConnection bridge, String query) {
        SingleQueryResult queryResult = new SingleQueryResult();
        try {
            queryResult.data = bridge.executeSQL(query);
        }
        catch (EZSourceNativeException e) {
            L.error("exception at executing stored procedure", (Throwable)e);
            EZReportErrorLog.err(Messages.getString(CompareManager.class, "storedProcedureError.logMessage"), e);
        }
        return queryResult;
    }

    class WorkThread
    extends Thread {
        private IProgressMonitor monitor;
        private IStatus status;
        private String application;
        private String project;
        private Map<String, Pair<Integer, Set<EZFile>>> model;

        WorkThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block19: {
                IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = connService.getProjectHandler(this.project, null);
                if (ph != null) {
                    try {
                        ph.executeWithLock(ph, new IMFRunnable(){

                            public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                                if (conn != null) {
                                    WorkThread.this.monitor.subTask(Messages.getString(CompareManager.class, "buildModel.subtask", new String[]{WorkThread.this.project}));
                                    WorkThread.this.status = CompareManager.this.buildCompareModel(WorkThread.this.model, conn, WorkThread.this.project, WorkThread.this.application, WorkThread.this.monitor);
                                    WorkThread.this.monitor.subTask("");
                                } else {
                                    L.error("connection null for project: {}", (Object)WorkThread.this.project);
                                    WorkThread.this.status = (IStatus)new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(CompareManager.class, "noconnection.status.error", new String[]{WorkThread.this.project}));
                                }
                            }
                        }, LockType.Shared, this.monitor);
                    }
                    catch (InterruptedException e) {
                        L.error("", (Throwable)e);
                        this.status = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(CompareManager.class, "error.collectingData.status.error", new String[]{this.project}));
                        WorkThread workThread = this;
                        synchronized (workThread) {
                            this.notifyAll();
                            break block19;
                        }
                    }
                    catch (ExecutionException e) {
                        WorkThread workThread;
                        try {
                            L.error("", (Throwable)e);
                            this.status = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(CompareManager.class, "error.collectingData.status.error", new String[]{this.project}));
                            workThread = this;
                        }
                        catch (Throwable throwable) {
                            WorkThread workThread2 = this;
                            synchronized (workThread2) {
                                this.notifyAll();
                            }
                            throw throwable;
                        }
                        synchronized (workThread) {
                            this.notifyAll();
                            break block19;
                        }
                    }
                    WorkThread workThread = this;
                    synchronized (workThread) {
                        this.notifyAll();
                    }
                }
                L.error("null project handler for project: {}", (Object)this.project);
                this.status = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(CompareManager.class, "errorAccessingProject.status.error", new String[]{this.project}));
            }
        }

        public void setModel(Map<String, Pair<Integer, Set<EZFile>>> model) {
            this.model = model;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }
    }
}

