/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare;

import com.ez.internal.utils.CSVWriter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.CompareDataSource;
import com.ez.report.application.ezreport.reports.summary.compare.CompareElementGroupInfo;
import com.ez.report.application.ezreport.reports.summary.compare.CompareManager;
import com.ez.report.application.ezreport.reports.summary.compare.EZFile;
import com.ez.report.application.reports.AbstractReportBuilder;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompareBuilder
extends AbstractReportBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CompareBuilder.class);
    protected static final String addedGroup = Messages.getString(CompareBuilder.class, "added.resources.lbl");
    protected static final String changedGroup = Messages.getString(CompareBuilder.class, "changed.resource.lbl");
    protected static final String removedGroup = Messages.getString(CompareBuilder.class, "removed.resource.lbl");
    protected static final String NEW_LINE_STR = "\n";
    protected Map<String, CompareElementGroupInfo> dsMap = new HashMap<String, CompareElementGroupInfo>();
    protected Map<String, Integer> globalTotals = new HashMap<String, Integer>();
    protected Map<String, Map<String, Number>> totals = new HashMap<String, Map<String, Number>>();
    protected String secondProject;
    protected String leftApplication;
    protected String rightApplication;
    protected CompareManager compareManager;
    protected Shell shell;
    protected IWorkbenchWindow window;

    protected void customizeJasperPrint(JasperPrint print) {
    }

    public AbstractReportDataSource getDataSource(IProgressMonitor monitor) throws Exception {
        Throwable ex;
        IStatus st = this.computeResults(monitor);
        if (st != null && st.isOK()) {
            CompareDataSource dataSource = new CompareDataSource(this.dsMap, this.totals);
            dataSource.setSummaryExtraTitle(this.getSummaryExtraTitle());
            return dataSource;
        }
        Throwable throwable = ex = st != null && st.getException() != null ? (Exception)st.getException() : new Exception(Messages.getString(CompareBuilder.class, "errorGeneratingReport.exception"));
        if (st != null && st.equals(Status.CANCEL_STATUS)) {
            ex = new CanceledException(Messages.getString(CompareBuilder.class, "reportCanceled.exception"));
        }
        throw ex;
    }

    private IStatus computeResults(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IStatus st = Status.OK_STATUS;
        CompareManager compareManager = this.getCompareManager();
        if (compareManager != null) {
            if (!this.resultsAreFixed()) {
                this.dsMap.clear();
                this.globalTotals.clear();
                this.totals.clear();
                compareManager.clean();
                st = compareManager.execute((IProgressMonitor)pmonitor.newChild(70));
                L.debug("status after executing compare manager: {}", (Object)st);
            }
        } else {
            st = new Status(4, "com.ez.mainframe.reports.gui", Messages.getString(CompareBuilder.class, "cannotcompare.status.error"));
        }
        if (st != null && st.isOK()) {
            st = this.buildReportDS(pmonitor);
        }
        pmonitor.worked(30);
        return st;
    }

    protected abstract CompareManager getCompareManager();

    protected abstract boolean resultsAreFixed();

    private IStatus buildReportDS(SubMonitor pmonitor) {
        IStatus st = Status.OK_STATUS;
        Map<String, Pair<Integer, Set<EZFile>>> foldersMap = this.getCompareManager().getAdded();
        pmonitor.subTask(Messages.getString(CompareBuilder.class, "buildingData.subtask"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        if ((st = this.buildReportData(foldersMap, addedGroup, pmonitor, csvWriter)) != null && st.isOK() && (st = this.buildReportData(foldersMap = this.getCompareManager().getChanged(), changedGroup, pmonitor, csvWriter)) != null && st.isOK()) {
            foldersMap = this.getCompareManager().getRemoved();
            st = this.buildReportData(foldersMap, removedGroup, pmonitor, csvWriter);
        }
        if (csvWriter != null) {
            csvWriter.close();
        }
        pmonitor.subTask("");
        return st;
    }

    private IStatus buildReportData(Map<String, Pair<Integer, Set<EZFile>>> foldersMap, String groupName, SubMonitor monitor, CSVWriter csvWriter) {
        IStatus st = Status.OK_STATUS;
        ArrayList<ObjectForSubreport> summaryList = null;
        BaseSubreportDataSource summaryDS = null;
        BaseSubreportDataSource elemDS = null;
        DSFactory factory = new DSFactory();
        ArrayList<String> orderedFold = new ArrayList<String>(foldersMap.keySet());
        Collections.sort(orderedFold);
        Iterator iterator = orderedFold.iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                st = Status.CANCEL_STATUS;
                break;
            }
            String folderName = (String)iterator.next();
            Set files = (Set)foldersMap.get(folderName).getSecond();
            CompareElementGroupInfo gr = this.dsMap.get(groupName);
            if (gr == null) {
                gr = new CompareElementGroupInfo(groupName);
                summaryList = new ArrayList<ObjectForSubreport>();
                summaryDS = factory.createDS(0);
                summaryDS.setList(summaryList);
                summaryDS.setTitle("");
                gr.addDataSource((SubreportDataSource)summaryDS);
                gr.hasSummaryAdded = true;
                this.dsMap.put(groupName, gr);
            } else {
                summaryDS = gr.getDS("");
                summaryList = summaryDS.getList();
            }
            String resourceStringType = folderName;
            elemDS = gr.getDS(resourceStringType);
            List<ObjectForSubreport> lst = null;
            ObjectForSubreport obj = null;
            if (elemDS == null) {
                elemDS = factory.createDS(0);
                lst = new ArrayList();
                elemDS.setList(lst);
                elemDS.setTitle(resourceStringType);
                elemDS.setTocEntry(resourceStringType);
                gr.addDataSource((SubreportDataSource)elemDS);
                obj = new ObjectForSubreport();
                obj.setExp(resourceStringType);
                summaryList.add(obj);
            } else {
                for (ObjectForSubreport object : summaryList) {
                    if (!object.getExp().equalsIgnoreCase(resourceStringType)) continue;
                    obj = object;
                    break;
                }
                lst = elemDS.getList();
            }
            Map<String, Number> resrs = this.totals.get(groupName);
            if (resrs == null) {
                resrs = new HashMap<String, Number>();
                this.totals.put(groupName, resrs);
            }
            Number nr = resrs.get(resourceStringType);
            if (files.isEmpty()) {
                obj.setExp(Messages.getString(CompareBuilder.class, "totals.folder.entry", new String[]{resourceStringType}));
            } else {
                if (nr == null) {
                    nr = new Integer(0);
                }
                nr = files.size();
                obj.setExpVal(nr.toString());
            }
            resrs.put(resourceStringType, nr);
            ArrayList orderedFiles = new ArrayList(files);
            Collections.sort(orderedFiles);
            for (EZFile file : orderedFiles) {
                obj = new ObjectForSubreport();
                String reportEntry = file.fileName;
                if (addedGroup.equals(groupName)) {
                    reportEntry = "&gt; ".concat(reportEntry);
                } else if (changedGroup.equals(groupName)) {
                    reportEntry = "&lt;".concat("&gt; ").concat(reportEntry);
                } else if (removedGroup.equals(groupName)) {
                    reportEntry = "&lt; ".concat(reportEntry);
                } else {
                    L.warn("strange group name: {}", (Object)groupName);
                }
                obj.setExp(reportEntry);
                obj.setElGroup(groupName);
                obj.setParent(groupName);
                lst.add(obj);
                if (csvWriter != null) {
                    csvWriter.write(new String[]{groupName, folderName, file.fileName});
                }
                this.updateGlobalTotal(groupName, 1);
            }
            if (!files.isEmpty()) continue;
            obj = new ObjectForSubreport();
            obj.setExp(Messages.getString(CompareBuilder.class, "nofiles.entry"));
            obj.setElGroup(groupName);
            obj.setParent(groupName);
            lst.add(obj);
            if (csvWriter == null) continue;
            csvWriter.write(new String[]{groupName, folderName, Messages.getString(CompareBuilder.class, "nofiles.csv.entry")});
        }
        return st;
    }

    private void updateGlobalTotal(String globalTotal, int total) {
        Integer value = this.globalTotals.get(globalTotal);
        value = value != null ? new Integer(total + value) : new Integer(total);
        this.globalTotals.put(globalTotal, value);
    }

    private String getSummaryExtraTitle() {
        String title = null;
        String leftRes = null;
        String rightRes = null;
        if (this.leftApplication != null && this.rightApplication != null) {
            leftRes = String.valueOf(this.leftApplication) + "(" + this.project + ")";
            rightRes = String.valueOf(this.rightApplication) + "(" + this.secondProject + ")";
        } else {
            leftRes = this.project;
            rightRes = this.secondProject;
        }
        title = Messages.getString(CompareBuilder.class, "compare.entry", new String[]{leftRes, rightRes});
        return title;
    }

    public JasperPrint getReportDocument() {
        return this.report != null ? this.report.print : null;
    }

    public Map getReportParameters(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CompareBuilder.class, "computeParams.taskName"));
        this.addLocaleParameter(this.parameters);
        String inputs = this.buildAppendix();
        this.parameters.put("inputResources", inputs);
        this.parameters.put("separateColumn", Boolean.FALSE);
        this.putSubreportStream("reports/subCols4.jasper", "summarySubreportTemplate");
        this.putSubreportStream("reports/subBase.jasper", "detailsSubreportTemplate");
        monitor.worked(100);
        return this.parameters;
    }

    protected String buildAppendix() {
        return "";
    }

    protected String getResourceTree(String res) {
        return res;
    }

    protected String getReportTemplatePath() {
        return "reports/projectsCompare.jasper";
    }

    public void setSecondProject(String value) {
        this.secondProject = value;
    }

    public void setRightApplication(String rightApplication) {
        this.rightApplication = rightApplication;
    }

    public void setLeftApplication(String leftApplication) {
        this.leftApplication = leftApplication;
    }

    public void cleanMemory() {
        if (this.compareManager != null) {
            this.compareManager.clean();
            this.compareManager = null;
        }
        if (this.dsMap != null) {
            this.dsMap.clear();
            this.dsMap = null;
        }
        if (this.globalTotals != null) {
            this.globalTotals.clear();
            this.globalTotals = null;
        }
        if (this.totals != null) {
            this.totals.clear();
            this.totals = null;
        }
        this.window = null;
        this.shell = null;
        super.cleanMemory();
    }

    protected Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public void setWindow(IWorkbenchWindow window) {
        this.window = window;
    }

    protected void writeCSVHeader(CSVWriter csvWriter, String reportTitle) {
        if (csvWriter != null) {
            if (reportTitle == null || reportTitle.isEmpty()) {
                reportTitle = (String)this.parameters.get("report.title");
            }
            csvWriter.writeLine(reportTitle == null ? "" : reportTitle);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd' 'HH:mm");
            csvWriter.writeLine(Messages.getString(CompareBuilder.class, "csv.header.date", new String[]{sdf.format(new Date())}));
            String leftRes = null;
            String rightRes = null;
            if (this.leftApplication != null && this.rightApplication != null) {
                leftRes = String.valueOf(this.leftApplication) + "(" + this.project + ")";
                rightRes = String.valueOf(this.rightApplication) + "(" + this.secondProject + ")";
            } else {
                leftRes = this.project;
                rightRes = this.secondProject;
            }
            csvWriter.writeLine(Messages.getString(((Object)((Object)this)).getClass(), "csv.header.projectsOrApplications", new String[]{leftRes, rightRes}));
            csvWriter.writeLine("");
        }
    }

    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            this.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(CompareBuilder.class, "csv.table.header.diff"), Messages.getString(CompareBuilder.class, "csv.table.header.type"), Messages.getString(CompareBuilder.class, "csv.table.header.name")});
        }
    }
}

