/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare;

import com.ez.mainframe.reports.gui.internal.Messages;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEncodingDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ChangeEncodingDialog.class);
    private String selected = null;

    protected ChangeEncodingDialog(Shell shell, String selected) {
        super(shell);
        this.selected = selected;
    }

    public String getSelectedEncoding() {
        return this.selected;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString(ChangeEncodingDialog.class, "dialog.title"));
        newShell.setMinimumSize(300, 120);
        Rectangle rect = newShell.getBounds();
        newShell.setLocation(rect.x + rect.width / 6, rect.y + rect.height / 8);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalIndent = 10;
        data.verticalIndent = 10;
        comp.setLayoutData((Object)data);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label infoLbl = new Label(comp, 0);
        infoLbl.setText(Messages.getString(ChangeEncodingDialog.class, "encoding.label"));
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.grabExcessHorizontalSpace = false;
        data.verticalAlignment = 0x1000000;
        infoLbl.setLayoutData((Object)data);
        final CCombo cmbEncodings = new CCombo(comp, 2056);
        Display display = Display.getCurrent();
        Color white = display.getSystemColor(1);
        cmbEncodings.setBackground(white);
        String[] items = new String[]{"UTF-8", "UTF-16", "8859_1", "8859_2", "8859_3", "8859_4", "8859_5", "8859_6", "8859_7", "8859_8", "8859_9", "ISO8859_13", "ISO8859_15_FDIS", "JIS", "SJIS", "EUCJIS", "ASCII", "GBK", "Big5", "ISO2022CN", "ISO2022KR"};
        cmbEncodings.setItems(items);
        int idx = this.selected == null ? 0 : cmbEncodings.indexOf(this.selected);
        cmbEncodings.select(idx);
        cmbEncodings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChangeEncodingDialog.this.selected = cmbEncodings.getText();
                L.trace("selected: {}", (Object)ChangeEncodingDialog.this.selected);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData();
        data.horizontalAlignment = 1;
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 5;
        data.verticalAlignment = 0x1000000;
        cmbEncodings.setLayoutData((Object)data);
        return parent;
    }
}

