/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.compare;

import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.compare.AbstractCompareJob;
import com.ez.report.application.ezreport.reports.summary.compare.CompareBuilder;
import com.ez.report.application.ezreport.reports.summary.compare.CompareManager;
import com.ez.report.application.ezreport.reports.summary.compare.DefaultCompareEditorInput;
import com.ez.report.application.ezreport.reports.summary.compare.EZCompareConfiguration;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.reports.AbstractBuilder;
import com.ez.report.generation.common.ExtraFileType;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompareBuilder
extends AbstractBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractCompareBuilder.class);
    protected String reportName;
    DefaultCompareEditorInput editorInput;
    protected AbstractBuilder reportBuilder;
    AbstractCompareJob job;
    protected CompareManager compareManager;
    protected Shell shell;
    protected IWorkbenchWindow window;

    public AbstractCompareBuilder(String reportName, String settings, AbstractCompareJob job) {
        this.reportName = reportName;
        this.job = job;
    }

    public IStatus execute(IProgressMonitor monitor) {
        L.debug("entering execute()");
        IStatus st = Status.OK_STATUS;
        if (this.report == null) {
            Boolean isEditor = (Boolean)this.inputs.get("target output editor");
            if (isEditor != null && isEditor.booleanValue()) {
                st = this.runInEditor(monitor);
            } else {
                this.job.addInfoAdapter();
                CompareBuilder reportBuilder = (CompareBuilder)this.instantiateBuilder(this.inputs);
                reportBuilder.setProject(this.project);
                reportBuilder.setShell(this.shell);
                reportBuilder.setWindow(this.window);
                reportBuilder.setIndicator(this.indicator);
                st = reportBuilder.execute(monitor);
            }
        }
        return st;
    }

    protected void displayErrorMessage(final String msg) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString(AbstractCompareBuilder.class, "error.title"), (String)msg);
            }
        });
    }

    public abstract CompareManager getCompareManager();

    protected abstract AbstractBuilder instantiateBuilder(Map<String, Object> var1);

    private IStatus runInEditor(IProgressMonitor monitor) {
        EZCompareConfiguration config = new EZCompareConfiguration();
        this.editorInput = new DefaultCompareEditorInput(config, this.getCompareManager());
        this.editorInput.setLeftProject(this.project);
        this.editorInput.setRightProject((String)this.inputs.get("target project"));
        this.editorInput.setLeftApplication((String)this.inputs.get("source application"));
        this.editorInput.setRightApplication((String)this.inputs.get("target application"));
        return Status.OK_STATUS;
    }

    public AbstractReport getReportModel() {
        return this.reportBuilder != null ? this.reportBuilder.getReportModel() : null;
    }

    public JasperPrint getReportDocument() {
        return this.reportBuilder != null ? this.reportBuilder.getReportDocument() : null;
    }

    public DefaultCompareEditorInput getOutput() {
        return this.editorInput;
    }

    public Map<ExtraFileType, List<String>> getExtraFilesToExport() {
        return this.reportBuilder != null ? this.reportBuilder.getExtraFilesToExport() : super.getExtraFilesToExport();
    }

    public void cleanMemory() {
        this.window = null;
        this.shell = null;
        super.cleanMemory();
    }

    public void dispose() {
        super.dispose();
        if (this.reportBuilder != null) {
            this.reportBuilder.dispose();
        }
    }
}

