/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.applicationInventory;

import com.ez.common.model.BaseResourceInput;
import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.ezreport.reports.summary.applicationInventory.DataSource;
import com.ez.report.application.ezreport.reports.summary.applicationInventory.ReportModel;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.datasource.AbstractReportDataSource;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilder
extends com.ez.report.application.ezreport.reports.summary.programSummary.ReportBuilder {
    private static final Logger L = LoggerFactory.getLogger(ReportBuilder.class);

    public ReportBuilder(String reportName, String settings) {
        super(reportName, settings);
    }

    @Override
    public AbstractReport getReportModel() {
        Set selectedApps = null;
        if (this.report == null) {
            this.report = new ReportModel(this.project, this.getSelectionFlagFromInputs());
            selectedApps = (Set)this.inputs.get("selected applications");
            this.report.addProperty("filtered by app", (Object)(selectedApps != null ? 1 : 0));
            this.report.addProperty("selected app", (Object)selectedApps);
            this.setOwnerInfos(this.inputs);
            Boolean value = (Boolean)this.inputs.get("show summary only");
            this.report.addProperty("show summary only", (Object)value);
            this.report.addProperty("selected app names", this.inputs.get("selected applications names"));
            this.addAppendixProperties(this.report);
        }
        return this.report;
    }

    @Override
    protected void putExternalizedParameters(Map params) {
        String externalized = null;
        boolean showSummaryOnly = (Boolean)this.getReportModel().getProperty("show summary only");
        if (showSummaryOnly) {
            externalized = Messages.getString(ReportBuilder.class, "onlySummaryReport.title");
            params.put("report.title", externalized);
        } else {
            externalized = Messages.getString(ReportBuilder.class, "report.title");
            params.put("report.title", externalized);
        }
        externalized = Messages.getString(ReportBuilder.class, "details.group.name");
        params.put("group1.name", externalized);
        externalized = Messages.getString(ReportBuilder.class, "summary.group.name");
        params.put("group2.name", externalized);
    }

    @Override
    protected void putGenericParams(Map params) {
        super.putGenericParams(params);
        this.parameters.put("appendixFirstLineLabel", null);
        params.put("showInputs1", Boolean.TRUE);
    }

    @Override
    public AbstractReportDataSource getDataSource(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ReportBuilder.class, "collectingData.taskName"));
        this.csvFile = this.createTempCSVFile();
        CSVWriter csvWriter = this.initTempCSVFile();
        this.writeCSVHeader(csvWriter);
        if (csvWriter != null) {
            this.addExportedFile(ExtraFileType.CSV, this.csvFile.getAbsolutePath());
        }
        List prgList = (List)this.inputs.get("selected resources");
        this.report.setInput((Object)prgList);
        HashMap<ProgramInputNoGUI, ElementGroupInfo> inputPrgMap = new HashMap<ProgramInputNoGUI, ElementGroupInfo>();
        if (prgList != null) {
            for (ProgramInputNoGUI prg : prgList) {
                String prgName = prg.getName();
                inputPrgMap.put(prg, new ElementGroupInfo(prgName));
            }
        }
        Set apps = (Set)this.getReportModel().getProperty("selected app names");
        ArrayList ordered = new ArrayList(apps);
        Collections.sort(ordered);
        String applicationsName = "";
        for (String appName : ordered) {
            applicationsName = String.valueOf(applicationsName) + appName + ", ";
        }
        applicationsName = applicationsName.substring(0, applicationsName.length() - 2);
        Boolean showOnlySummary = (Boolean)this.getReportModel().getProperty("show summary only");
        DataSource dataSource = new DataSource(inputPrgMap, showOnlySummary != null ? showOnlySummary : false, csvWriter);
        dataSource.setApplications(apps);
        dataSource.setData(this.data((IProgressMonitor)monitor));
        this.parameters.put("inputResources", applicationsName);
        this.parameters.put("title.appFieldValues", applicationsName);
        if (csvWriter != null) {
            csvWriter.close();
        }
        monitor.done();
        return dataSource;
    }

    protected void buildInputs4Appendix(Set<? extends BaseResourceInput> prgList) {
        String appendixStr = this.prepareAppendixResrsList(prgList);
        this.parameters.put("inputResources", appendixStr);
    }

    @Override
    protected void writeCSVHeader(CSVWriter csv) {
        if (csv != null) {
            super.writeCSVHeader(csv, Messages.getString(((Object)((Object)this)).getClass(), "report.title"));
            csv.write(new String[]{Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.app"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.type"), Messages.getString(((Object)((Object)this)).getClass(), "csv.table.header.name")});
        }
    }
}

