/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.applicationInventory;

import com.ez.internal.utils.CSVWriter;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.report.application.ezreport.reports.SummaryGenericDataSource;
import com.ez.report.application.ezreport.reports.summary.applicationInventory.PrgComparator;
import com.ez.report.application.reports.summary.StoredProcedureResults;
import com.ez.report.generation.common.datasource.BaseSubreportDataSource;
import com.ez.report.generation.common.datasource.DSFactory;
import com.ez.report.generation.common.datasource.ElementGroupInfo;
import com.ez.report.generation.common.datasource.ObjectForSubreport;
import com.ez.report.generation.common.datasource.SubreportDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
extends SummaryGenericDataSource {
    private static final Logger L = LoggerFactory.getLogger(DataSource.class);
    private boolean showSummary = false;
    Map<String, Set<ProgramInputNoGUI>> applications = new HashMap<String, Set<ProgramInputNoGUI>>();

    public DataSource(Map prgVsElemGroupMap, boolean showOnlySummary, CSVWriter csvWriter) {
        super(prgVsElemGroupMap, showOnlySummary, csvWriter);
        this.showSummary = showOnlySummary;
        this.showOnlySummary = true;
    }

    @Override
    protected void init() {
        if (this.isOnlySummary()) {
            this.list.add(new ElementGroupInfo(null));
        }
    }

    protected Set<String> getApplications(String prgName, ProgramInputNoGUI prgInpt) {
        HashSet apps = null;
        if (prgName != null || prgInpt != null) {
            ProgramInputNoGUI programInput = prgInpt;
            if (programInput == null) {
                programInput = (ProgramInputNoGUI)this.getProgramInput(prgName, this.prgVsElemGroupMap);
            }
            if (programInput != null) {
                apps = programInput.getApplications();
            } else {
                L.warn("program without applications: " + prgName + ". it will be ignored!");
                apps = new HashSet();
            }
            for (String appName : apps) {
                Set<ProgramInputNoGUI> prgs = this.applications.get(appName);
                if (prgs == null) {
                    prgs = new HashSet<ProgramInputNoGUI>();
                    this.applications.put(appName, prgs);
                }
                prgs.add(programInput);
            }
        } else {
            apps = this.applications.keySet();
        }
        return apps;
    }

    @Override
    protected Integer getPrgNo(String appName, Integer prgType) {
        Set<ProgramInputNoGUI> prgs = this.applications.get(appName);
        if (prgs == null || prgs.size() == 0) {
            L.warn("no programs for application: " + appName);
        }
        return prgs != null ? prgs.size() : 0;
    }

    @Override
    public void setData(StoredProcedureResults data) {
        super.setData(data);
        if (!this.isOnlySummary()) {
            this.buildDetails();
        }
    }

    @Override
    protected boolean isOnlySummary() {
        return this.showSummary;
    }

    private void buildDetails() {
        DSFactory factory = new DSFactory();
        this.list.clear();
        HashMap<Integer, BaseSubreportDataSource> ds = new HashMap<Integer, BaseSubreportDataSource>();
        ArrayList<String> apps = new ArrayList<String>(this.applications.keySet());
        Collections.sort(apps);
        for (String appName : apps) {
            ArrayList prgs = new ArrayList(this.applications.get(appName));
            ds.clear();
            ElementGroupInfo elem = new ElementGroupInfo(appName);
            ArrayList<ObjectForSubreport> objList = null;
            BaseSubreportDataSource elemDS = null;
            ObjectForSubreport obj = null;
            if (!prgs.isEmpty()) {
                Collections.sort(prgs, new PrgComparator());
                for (ProgramInputNoGUI prgInput : prgs) {
                    String[] results = new String[]{String.valueOf(appName) + prgInput.getTypeCode().toString(), prgInput.getName()};
                    obj = factory.createObj(1, results, "");
                    String strType = Utils.getExternalizedType((Integer)prgInput.getTypeCode());
                    elemDS = (BaseSubreportDataSource)ds.get(prgInput.getTypeCode());
                    if (elemDS == null) {
                        elemDS = factory.createDS(1);
                        elemDS.setTitle(strType);
                        elemDS.setTocEntry(elemDS.getTitle());
                        elem.addDataSource((SubreportDataSource)elemDS);
                        ds.put(prgInput.getTypeCode(), elemDS);
                    }
                    if ((objList = elemDS.getList()) == null) {
                        objList = new ArrayList<ObjectForSubreport>();
                        elemDS.setList(objList);
                    }
                    objList.add(obj);
                    this.csvWriter.write(new String[]{appName, strType, prgInput.getName()});
                }
            }
            this.list.add(elem);
        }
    }

    public void setApplications(Set<String> apps) {
        for (String appName : apps) {
            this.applications.put(appName, new HashSet());
        }
        if (this.prgByTypes.isEmpty()) {
            super.init();
        }
    }

    @Override
    protected void writeLineToCSVForProgramsInventory(String ... entries) {
    }
}

