/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.summary.applicationInventory;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.mainframe.reports.gui.preferences.PreferenceUtils;
import com.ez.report.application.ezreport.reports.summary.applicationInventory.ApplicationInventoryJob;
import com.ez.report.application.model.AbstractReport;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectApplicationPage;
import com.ez.report.application.viewer.execution.EZReportAnalysis;
import com.ez.report.application.viewer.execution.EZReportJob;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class ApplicationInventoryAnalysis
extends EZReportAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public ApplicationInventoryAnalysis() {
        this(null);
    }

    public ApplicationInventoryAnalysis(AbstractReport model) {
        super(model);
    }

    @Override
    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard(true);
        String wizardName = Messages.getString(ApplicationInventoryAnalysis.class, "wizzard.title");
        wizard.setWindowTitle(wizardName);
        Boolean showAppendix = PreferenceUtils.getPreferenceStore().getBoolean("showAppendix");
        SelectApplicationPage page = new SelectApplicationPage("applications name page", true);
        page.setShowAppendixValue(showAppendix.booleanValue());
        wizard.addPage((IWizardPage)page);
        return wizard;
    }

    protected AbstractAnalysisJob getJob(EZEntityID arg0) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (EZReportJob)wk.getJob(this.id, ApplicationInventoryJob.class);
        }
        ((EZReportJob)this.job).setParameters(this.params);
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_EZREPORT_APPLICATIONINVENTORY_ANALYSIS;
    }

    @Override
    protected void completeSelectedPrograms(final PrepareReportWizard wizard) throws Exception {
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(this.projectName, null);
        ph.executeWithLock(ph, new IMFRunnable(){

            public void run(EZSourceConnection conn, IProgressMonitor arg1) {
                Set selectedApps = (Set)wizard.getValue("selected applications");
                ProgramInputsFactory4Wizard factory = ProgramInputsFactory4Wizard.getInstance();
                List prgList = factory.getAvailableProgramsWithTypesForApp(null, selectedApps);
                wizard.set("selected resources", (Object)prgList);
            }
        }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        super.completeSelectedPrograms(wizard);
    }
}

