/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ezreport.reports.mainframeperformance;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.Listable;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.BaseMainframeResourceInput;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.reports.gui.internal.Messages;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesPage<T extends Listable>
extends SelectProgramsPage<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResourcesPage.class);
    private static String jobsQuery = "SELECT DISTINCT JobName FROM  MFJobInfo WHERE RTJobID <> -1";
    private static String prgsQuery = "SELECT DISTINCT ProgramName FROM MFJCLStepInfo";
    private static String cicsQuery = "SELECT DISTINCT MFCICSTransaction.TransCode FROM MFCICSTransactionPerformance INNER JOIN MFCICSTransaction ON MFCICSTransactionPerformance.CICSTransID = MFCICSTransaction.TransID";
    private Boolean prgtypeSelected;
    private Boolean jobtypeSelected;
    private Boolean cicstypeSelected;

    public ResourcesPage(String pageName, boolean useFilters) {
        super(pageName, useFilters);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ArrayList<BaseMainframeResource4GUI> resources = new ArrayList<BaseMainframeResource4GUI>();
        this.propertiesGroup.clearUILists();
        this.wizard.set(this.availablePropName, null);
        if (visible) {
            this.prgtypeSelected = (Boolean)this.wizard.getValue("prg_resource");
            this.jobtypeSelected = (Boolean)this.wizard.getValue("job_resource");
            this.cicstypeSelected = (Boolean)this.wizard.getValue("cics_resource");
            this.getResourcesFromDB(resources);
            ArrayList imagesObjsList = new ArrayList();
            if (this.prgtypeSelected.booleanValue()) {
                this.getTypeForResource(imagesObjsList, 21);
            }
            if (this.jobtypeSelected.booleanValue()) {
                this.getTypeForResource(imagesObjsList, 22);
            }
            if (this.cicstypeSelected.booleanValue()) {
                this.getTypeForResource(imagesObjsList, 23);
            }
            if (this.propertiesGroup != null) {
                this.propertiesGroup.setAvailableImages(imagesObjsList);
                this.propertiesGroup.setAvailable(this.wizard.getList(this.availablePropName));
            }
        }
    }

    private void getTypeForResource(List imagesObjsList, int resType) {
        String textType = com.ez.mainframe.data.utils.Utils.getExternalizedType((Integer)resType);
        ImageDescriptor image_desc = Utils.getImageDescType((Integer)resType);
        ImageObj4Wizard imageObj = new ImageObj4Wizard(Integer.valueOf(resType), textType, image_desc);
        imagesObjsList.add(imageObj);
    }

    private void getResourcesFromDB(final List<BaseMainframeResource4GUI> resources) {
        this.wizard.runLongOperation(new PrepareReportWizard.LongOperation(){

            public Wizard getWizard() {
                return ResourcesPage.this.wizard;
            }

            public void runOperation(IProgressMonitor pmonitor) throws Exception {
                pmonitor.beginTask(Messages.getString(ResourcesPage.class, "task.name"), -1);
                String prjName = ResourcesPage.this.wizard.getProject();
                IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = connService.getProjectHandler(prjName, null);
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                        String[][] cicsFiles;
                        String[][] jobFiles;
                        int n;
                        int n2;
                        String[][] stringArray;
                        String[][] programFiles;
                        if (ResourcesPage.this.prgtypeSelected.booleanValue() && (programFiles = conn.executeSQL(prgsQuery)) != null) {
                            BaseMainframeResourceInput prg = null;
                            stringArray = programFiles;
                            n2 = programFiles.length;
                            n = 0;
                            while (n < n2) {
                                String[] prgFile = stringArray[n];
                                String prgName = prgFile[0];
                                if (!prgName.trim().isEmpty()) {
                                    prg = new BaseMainframeResourceInput(prgFile[0], Integer.valueOf(21));
                                    resources.add(new BaseMainframeResource4GUI((BaseResourceInput)prg));
                                }
                                ++n;
                            }
                        }
                        if (ResourcesPage.this.jobtypeSelected.booleanValue() && (jobFiles = conn.executeSQL(jobsQuery)) != null) {
                            BaseMainframeResourceInput job = null;
                            stringArray = jobFiles;
                            n2 = jobFiles.length;
                            n = 0;
                            while (n < n2) {
                                String[] jobFile = stringArray[n];
                                job = new BaseMainframeResourceInput(jobFile[0], Integer.valueOf(22));
                                resources.add(new BaseMainframeResource4GUI((BaseResourceInput)job));
                                ++n;
                            }
                        }
                        if (ResourcesPage.this.cicstypeSelected.booleanValue() && (cicsFiles = conn.executeSQL(cicsQuery)) != null) {
                            BaseMainframeResourceInput cics = null;
                            stringArray = cicsFiles;
                            n2 = cicsFiles.length;
                            n = 0;
                            while (n < n2) {
                                String[] cicsFile = stringArray[n];
                                cics = new BaseMainframeResourceInput(cicsFile[0], Integer.valueOf(23));
                                resources.add(new BaseMainframeResource4GUI((BaseResourceInput)cics));
                                ++n;
                            }
                        }
                        ResourcesPage.this.wizard.set(ResourcesPage.this.availablePropName, (Object)resources);
                        if ((resources == null || resources.isEmpty()) && !ResourcesPage.this.acceptNoRes()) {
                            String errMsg;
                            final String cpy = errMsg = localErrMsg;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ResourcesPage.this.setErrorMessage(cpy);
                                }
                            });
                        }
                    }
                }, LockType.Shared, pmonitor);
                pmonitor.done();
            }
        });
    }
}

